/*
 * Decompiled with CFR 0.152.
 */
package com.ejianc.wzxt.plan.service.impl;

import com.alibaba.fastjson.JSONObject;
import com.ejianc.foundation.file.api.IAttachmentApi;
import com.ejianc.foundation.file.vo.AttachmentVO;
import com.ejianc.foundation.message.api.IPushMessageApi;
import com.ejianc.foundation.outcontract.api.IOutcontractApi;
import com.ejianc.foundation.share.api.IProSupplierApi;
import com.ejianc.foundation.share.utils.FileUtil;
import com.ejianc.framework.cache.utils.RedisTool;
import com.ejianc.framework.core.exception.BusinessException;
import com.ejianc.framework.core.kit.mapper.BeanMapper;
import com.ejianc.framework.core.response.CommonResponse;
import com.ejianc.framework.skeleton.dataPush.ISystemDataPushService;
import com.ejianc.framework.skeleton.template.BaseServiceImpl;
import com.ejianc.wzxt.plan.bean.MaterialPlanEntity;
import com.ejianc.wzxt.plan.mapper.MaterialPlanMapper;
import com.ejianc.wzxt.plan.service.IMaterialPlanService;
import com.ejianc.wzxt.plan.vo.SupMaterialPlanDetailVO;
import com.ejianc.wzxt.plan.vo.SupMaterialPlanVO;
import com.ejianc.wzxt.utils.CommonUtils;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import javax.servlet.http.HttpServletRequest;
import org.apache.commons.collections.CollectionUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.beans.factory.annotation.Value;
import org.springframework.stereotype.Service;
import org.springframework.web.bind.annotation.RequestMethod;
import org.springframework.web.multipart.MultipartHttpServletRequest;
import redis.clients.jedis.Jedis;
import redis.clients.jedis.JedisPool;

@Service(value="materialPlanService")
public class MaterialPlanServiceImpl
extends BaseServiceImpl<MaterialPlanMapper, MaterialPlanEntity>
implements IMaterialPlanService {
    @Autowired
    private JedisPool jedisPool;
    @Autowired
    private IAttachmentApi attachmentApi;
    private Logger logger = LoggerFactory.getLogger(this.getClass());
    @Autowired
    private IOutcontractApi outcontractApi;
    @Autowired
    private ISystemDataPushService systemDataPushService;
    @Value(value="${common.env.base-host}")
    private String baseHost;
    @Value(value="${refer.base-host:null}")
    private String BASE_HOST_FRONTEND;
    @Autowired
    private IProSupplierApi proSupplierApi;
    private static final String BILL_TYPE = "EJCBT202408000008";
    @Autowired
    private IPushMessageApi pushMessageApi;
    private final String OPERATE = "MATERIAL_PLAN_SYNC";
    private final String PUSH_BILL_SERVER_URL = "/zjkj-supbusiness-web/openapi/materialPlan/saveOrUpdate";

    @Override
    public boolean pushBillToSupCenter(MaterialPlanEntity materialPlanEntity, String billTypeCode) {
        boolean syncFlag;
        block11: {
            boolean locked = false;
            syncFlag = false;
            Jedis jedis = this.jedisPool.getResource();
            String key = billTypeCode + "::" + materialPlanEntity.getId().toString();
            CommonResponse ejcCloudSystemCode = this.proSupplierApi.getEjcCloudSystemCode();
            if (!ejcCloudSystemCode.isSuccess()) {
                this.logger.error("\u63a8\u9001\u9886\u6599\u8ba1\u5212\u5355\u636e-{}\u5931\u8d25\uff0c\u83b7\u53d6\u5f53\u524d\u7cfb\u7edf\u7f16\u7801\u5931\u8d25,{}", (Object)materialPlanEntity.getId(), (Object)ejcCloudSystemCode.getMsg());
                return false;
            }
            materialPlanEntity.setSystemId((String)ejcCloudSystemCode.getData());
            materialPlanEntity.setSourceId(materialPlanEntity.getId());
            try {
                locked = RedisTool.tryLock((Jedis)jedis, (String)key, (String)"MATERIAL_PLAN_SYNC", (int)600);
                if (!locked) {
                    this.logger.error("\u5355\u636e\u63a8\u9001\u5931\u8d25\uff0c\u5355\u636e\u9501\u83b7\u53d6\u5931\u8d25\uff01");
                    this.releaseLock(jedis, false, key, "MATERIAL_PLAN_SYNC");
                    boolean bl = false;
                    return bl;
                }
                HashMap<String, String> paramMap = new HashMap<String, String>();
                SupMaterialPlanVO supMaterialPlanVO = (SupMaterialPlanVO)BeanMapper.map((Object)((Object)materialPlanEntity), SupMaterialPlanVO.class);
                List supMaterialPlanDetailVOS = BeanMapper.mapList(materialPlanEntity.getMaterialPlanDetailList(), SupMaterialPlanDetailVO.class);
                supMaterialPlanVO.setMaterialPlanDetailList(supMaterialPlanDetailVOS);
                supMaterialPlanVO.setId(null);
                paramMap.put("plan", JSONObject.toJSONString((Object)supMaterialPlanVO));
                CommonResponse fileResp = this.attachmentApi.queryListBySourceId(materialPlanEntity.getId(), BILL_TYPE, "materialPlanFile", null);
                if (fileResp.isSuccess()) {
                    HashMap files = new HashMap();
                    List fileList = (List)fileResp.getData();
                    ArrayList<Long> fileIds = new ArrayList<Long>();
                    for (AttachmentVO attach : fileList) {
                        fileIds.add(attach.getId());
                    }
                    if (CollectionUtils.isNotEmpty((Collection)fileList)) {
                        Map fileMap = FileUtil.getInstance().batchDownFileFlow(fileIds, true);
                        fileMap.keySet().stream().forEach(fileKey -> {
                            HashMap file = new HashMap(1);
                            file.put((String)fileKey, fileMap.get(fileKey));
                            files.put("file", file);
                        });
                    }
                    this.logger.info("\u5411\u4f9b\u5e94\u5546-{}\u63a8\u9001\u9886\u6599\u8ba1\u5212\u5355\u636e\u53c2\u6570-{}", (Object)materialPlanEntity.getSupplierId(), (Object)JSONObject.toJSONString(paramMap));
                    CommonResponse syncReqResp = this.systemDataPushService.exchangeDataAndFilesWithEachLinkSystem("/zjkj-supbusiness-web/openapi/materialPlan/saveOrUpdate", paramMap, materialPlanEntity.getSupplierId().toString(), files);
                    syncFlag = CommonUtils.checkCommonResponse(syncReqResp, this.logger);
                    break block11;
                }
                this.logger.error("\u83b7\u53d6\u8ba2\u5355\u5355\u636eid-{}\u5bf9\u5e94\u9644\u4ef6\u4fe1\u606f\u5931\u8d25, {}", (Object)materialPlanEntity.getId(), (Object)fileResp.getMsg());
                throw new BusinessException(fileResp.getMsg());
            }
            catch (Exception e) {
                this.logger.error("\u63a8\u9001\u8ba2\u5355\u5355\u636eid-{}\u7ed9\u4f9b\u65b9id-{} \u5f02\u5e38\uff0c", new Object[]{materialPlanEntity.getId(), materialPlanEntity.getSupplierId(), e});
                throw new BusinessException("\u63a8\u9001\u4f9b\u65b9\u5f02\u5e38!");
            }
            finally {
                this.releaseLock(jedis, locked, key, "MATERIAL_PLAN_SYNC");
            }
        }
        return syncFlag;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void releaseLock(Jedis jedis, boolean locked, String key, String OPERATE) {
        try {
            if (locked) {
                RedisTool.releaseLock((Jedis)jedis, (String)key, (String)OPERATE);
            }
        }
        finally {
            if (null != jedis) {
                jedis.close();
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public Boolean delSupPLan(Long billId, String dataInfo, String url, RequestMethod method, String supplierId, String operate, String billTypeCode) {
        Boolean locked = false;
        Boolean syncFlag = false;
        String key = billTypeCode + "::" + billId.toString();
        Jedis jedis = this.jedisPool.getResource();
        try {
            locked = RedisTool.tryLock((Jedis)jedis, (String)key, (String)operate, (int)600);
            if (!locked.booleanValue()) {
                this.releaseLock(jedis, false, key, operate);
                this.logger.error("\u5355\u636e{}\u63a8\u9001\u5931\u8d25\uff0c\u5355\u636e\u9501\u83b7\u53d6\u5931\u8d25-{}\uff01", (Object)billId, (Object)locked);
                Boolean bl = false;
                return bl;
            }
            CommonResponse syncReqResp = this.systemDataPushService.exchangeDataWithEachLinkSystem(url, method, dataInfo, supplierId);
            if (syncReqResp.isSuccess()) {
                CommonResponse billPushResp = (CommonResponse)JSONObject.parseObject((String)((String)syncReqResp.getData()), CommonResponse.class);
                if (billPushResp.isSuccess()) {
                    syncFlag = true;
                } else {
                    this.logger.error("\u4f9b\u65b9id-{}\u5904\u7406\u63a8\u9001\u5355\u636eid-{}\u5931\u8d25, {}", new Object[]{supplierId, billId, billPushResp.getMsg()});
                }
            } else {
                this.logger.error("\u4f9b\u65b9id-{}\u5904\u7406\u63a8\u9001\u5355\u636eid-{}\u5931\u8d25, {}", new Object[]{supplierId, billId, syncReqResp.getMsg()});
            }
        }
        catch (Exception e) {
            this.logger.error("\u63a8\u9001\u53d1\u8d27\u5355\u5355\u636eid-{}\u7ed9\u4f9b\u65b9id-{} \u5f02\u5e38\uff0c", new Object[]{billId, supplierId, e});
        }
        finally {
            this.releaseLock(jedis, locked, key, operate);
        }
        return syncFlag;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public String updateBillSupSignSyncInfo(HttpServletRequest request) {
        String authority = request.getHeader("authority");
        String msg = null;
        Jedis jedis = null;
        boolean locked = false;
        String billId = request.getParameter("billId");
        String nameSourceTypeMapping = request.getParameter("nameSourceTypeMapping");
        Map mp = (Map)JSONObject.parseObject((String)nameSourceTypeMapping, Map.class);
        MaterialPlanEntity materialPlanEntity = (MaterialPlanEntity)((Object)super.selectById((Serializable)((Object)billId)));
        String key = "EJCBT202408000008::" + materialPlanEntity.getId().toString();
        try {
            jedis = this.jedisPool.getResource();
            locked = RedisTool.tryLock((Jedis)jedis, (String)key, (String)"MATERIAL_PLAN_SYNC", (int)600);
            if (!locked) {
                this.logger.error("\u5355\u636eid-{}\u7b7e\u5b57\u4fe1\u606f\u56de\u5199\u52a0\u9501\u5931\u8d25\uff01", (Object)materialPlanEntity.getId());
                this.releaseLock(jedis, false, key, "MATERIAL_PLAN_SYNC");
                String string = "\u5355\u636e\u7b7e\u5b57\u4fe1\u606f\u56de\u5199\u52a0\u9501\u5931\u8d25";
                return string;
            }
            Map attachIdsMap = FileUtil.getInstance().handleReqFile((MultipartHttpServletRequest)request, mp, BILL_TYPE, authority, materialPlanEntity.getId().toString());
            ArrayList attchIdsList = new ArrayList();
            for (List attachIds : attachIdsMap.values()) {
                if (!CollectionUtils.isNotEmpty((Collection)attachIds)) continue;
                attchIdsList.addAll(attachIds);
            }
            materialPlanEntity.setAttachIds(attchIdsList);
            materialPlanEntity.setSignStatus(2);
            super.saveOrUpdate((Object)materialPlanEntity, false);
        }
        catch (Exception e) {
            this.logger.error("\u5355\u636eid-{}\u7b7e\u5b57\u4fe1\u606f\u56de\u5199\u5f02\u5e38\uff0c", (Object)materialPlanEntity.getId(), (Object)e);
            msg = "\u5355\u636e\u7b7e\u5b57\u4fe1\u606f\u56de\u5199\u5931\u8d25\uff01";
        }
        finally {
            this.releaseLock(jedis, locked, key, "MATERIAL_PLAN_SYNC");
        }
        return msg;
    }
}

