/*
 * Decompiled with CFR 0.152.
 */
package com.ejianc.wzxt.plan.service.impl;

import com.baomidou.mybatisplus.core.conditions.Wrapper;
import com.baomidou.mybatisplus.core.conditions.query.LambdaQueryWrapper;
import com.baomidou.mybatisplus.core.toolkit.CollectionUtils;
import com.baomidou.mybatisplus.core.toolkit.Wrappers;
import com.ejianc.foundation.support.api.IBillTypeApi;
import com.ejianc.framework.core.response.CommonResponse;
import com.ejianc.framework.core.util.ComputeUtil;
import com.ejianc.framework.skeleton.billState.service.ICommonBusinessService;
import com.ejianc.framework.skeleton.template.BaseEntity;
import com.ejianc.wzxt.plan.bean.MasterPlanDetailEntity;
import com.ejianc.wzxt.plan.bean.MasterPlanEntity;
import com.ejianc.wzxt.plan.bean.MonthPlanDetailEntity;
import com.ejianc.wzxt.plan.bean.MonthPlanEntity;
import com.ejianc.wzxt.plan.service.IMasterPlanDetailService;
import com.ejianc.wzxt.plan.service.IMasterPlanService;
import com.ejianc.wzxt.plan.service.IMonthPlanDetailService;
import com.ejianc.wzxt.plan.service.IMonthPlanService;
import com.ejianc.wzxt.plan.vo.MonthPlanVO;
import java.math.BigDecimal;
import java.util.Collection;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;

@Service(value="monthPlan")
public class MonthPlanBpmServiceImpl
implements ICommonBusinessService {
    @Autowired
    private IBillTypeApi billTypeApi;
    @Autowired
    private IMonthPlanService monthPlanService;
    @Autowired
    private IMasterPlanService masterPlanService;
    @Autowired
    private IMasterPlanDetailService masterPlanDetailService;
    @Autowired
    private IMonthPlanDetailService monthPlanDetailService;

    public CommonResponse<String> beforeSubmitProcessor(Long billId, Integer state, String billTypeCode) {
        return CommonResponse.success();
    }

    public CommonResponse<String> afterSubmitProcessor(Long billId, Integer state, String billTypeCode) {
        return CommonResponse.success();
    }

    public CommonResponse<String> beforeHasBpmBack(Long billId, Integer state, String billTypeCode) {
        return CommonResponse.success();
    }

    public CommonResponse<String> afterHasBpmBack(Long billId, Integer state, String billTypeCode) {
        return CommonResponse.success();
    }

    public CommonResponse<String> beforeInApprovalBack(Long billId, Integer state, String billTypeCode, String sign) {
        return CommonResponse.success();
    }

    public CommonResponse<String> beforeApprovalProcessor(Long billId, Integer state, String billTypeCode) {
        return CommonResponse.success();
    }

    public CommonResponse<String> afterApprovalProcessor(Long billId, Integer state, String billTypeCode) {
        MonthPlanEntity monthPlanEntity = (MonthPlanEntity)((Object)this.monthPlanService.selectById(billId));
        LambdaQueryWrapper lambda = Wrappers.lambdaQuery();
        lambda.eq(MonthPlanEntity::getProjectId, (Object)monthPlanEntity.getProjectId());
        lambda.in(MonthPlanEntity::getBillState, new Object[]{1, 3});
        lambda.notIn(BaseEntity::getId, new Object[]{billId});
        List monthPlanEntities = this.monthPlanService.list((Wrapper)lambda);
        Map<Object, Object> orderNumMap = new HashMap();
        Map<Object, Object> selfCheckNumMap = new HashMap();
        if (CollectionUtils.isNotEmpty((Collection)monthPlanEntities)) {
            List ids = monthPlanEntities.stream().map(BaseEntity::getId).collect(Collectors.toList());
            LambdaQueryWrapper lambdaDetail = Wrappers.lambdaQuery();
            lambdaDetail.in(MonthPlanDetailEntity::getMaterialMonthPlanId, ids);
            List monthPlanDetailEntities = this.monthPlanDetailService.list((Wrapper)lambdaDetail);
            if (CollectionUtils.isNotEmpty((Collection)monthPlanDetailEntities)) {
                orderNumMap = monthPlanDetailEntities.stream().filter(s -> s.getOrderNum() != null).collect(Collectors.groupingBy(MonthPlanDetailEntity::getMaterialId, Collectors.collectingAndThen(Collectors.toList(), m -> m.stream().map(a -> a.getOrderNum()).reduce(BigDecimal.ZERO, BigDecimal::add))));
                selfCheckNumMap = monthPlanDetailEntities.stream().filter(s -> s.getSelfCheckNum() != null).collect(Collectors.groupingBy(MonthPlanDetailEntity::getMaterialId, Collectors.collectingAndThen(Collectors.toList(), m -> m.stream().map(a -> a.getSelfCheckNum()).reduce(BigDecimal.ZERO, BigDecimal::add))));
            }
        }
        Map<Object, Object> planMonthNumMap = new HashMap();
        List<MonthPlanDetailEntity> monthPlanDetailList = monthPlanEntity.getMonthPlanDetailList();
        if (CollectionUtils.isNotEmpty(monthPlanDetailList)) {
            planMonthNumMap = monthPlanDetailList.stream().filter(s -> s.getPlanMonthNum() != null).collect(Collectors.groupingBy(MonthPlanDetailEntity::getMaterialId, Collectors.collectingAndThen(Collectors.toList(), m -> m.stream().map(a -> a.getPlanMonthNum()).reduce(BigDecimal.ZERO, BigDecimal::add))));
        }
        LambdaQueryWrapper lambdaMaster = Wrappers.lambdaQuery();
        lambdaMaster.eq(MasterPlanEntity::getProjectId, (Object)monthPlanEntity.getProjectId());
        lambdaMaster.in(MasterPlanEntity::getBillState, new Object[]{1, 3});
        MasterPlanEntity masterPlanEntity = (MasterPlanEntity)((Object)this.masterPlanService.getOne((Wrapper)lambdaMaster));
        if (masterPlanEntity != null) {
            LambdaQueryWrapper lambdaMasterDetail = Wrappers.lambdaQuery();
            lambdaMasterDetail.in(MasterPlanDetailEntity::getMaterialMasterPlanId, new Object[]{masterPlanEntity.getId()});
            List masterPlanDetailEntities = this.masterPlanDetailService.list((Wrapper)lambdaMasterDetail);
            if (CollectionUtils.isNotEmpty((Collection)masterPlanDetailEntities)) {
                for (MasterPlanDetailEntity masterPlanDetailEntity : masterPlanDetailEntities) {
                    BigDecimal planMonthNum = BigDecimal.ZERO;
                    if (orderNumMap.containsKey(masterPlanDetailEntity.getMaterialId())) {
                        BigDecimal orderNum = (BigDecimal)orderNumMap.get(masterPlanDetailEntity.getMaterialId());
                        planMonthNum = ComputeUtil.safeAdd((BigDecimal)planMonthNum, (BigDecimal)orderNum);
                    }
                    if (orderNumMap.containsKey(masterPlanDetailEntity.getMaterialId())) {
                        BigDecimal selfCheckNum = (BigDecimal)selfCheckNumMap.get(masterPlanDetailEntity.getMaterialId());
                        planMonthNum = ComputeUtil.safeAdd((BigDecimal)planMonthNum, (BigDecimal)selfCheckNum);
                    }
                    if (planMonthNumMap.containsKey(masterPlanDetailEntity.getMaterialId())) {
                        BigDecimal planMonthNumNum = (BigDecimal)planMonthNumMap.get(masterPlanDetailEntity.getMaterialId());
                        planMonthNum = ComputeUtil.safeAdd((BigDecimal)planMonthNum, (BigDecimal)planMonthNumNum);
                    }
                    masterPlanDetailEntity.setPlanMonthNum(planMonthNum);
                }
                this.masterPlanDetailService.saveOrUpdateBatch(masterPlanDetailEntities);
            }
        }
        return CommonResponse.success();
    }

    public CommonResponse<String> beforeAbstainingProcessor(Long billId, Integer state, String billTypeCode) {
        MonthPlanEntity monthPlanEntity = (MonthPlanEntity)((Object)this.monthPlanService.selectById(billId));
        if (monthPlanEntity != null) {
            if (monthPlanEntity.getChangeState() == MonthPlanVO.PLAN_CHANGE_STATE_CHANGING) {
                return CommonResponse.error((String)"\u53d8\u66f4\u4e2d\u5355\u636e\u65e0\u6cd5\u64a4\u56de");
            }
            if (monthPlanEntity.getChangeState() == MonthPlanVO.PLAN_CHANGE_STATE_CHANGED) {
                return CommonResponse.error((String)"\u5df2\u53d8\u66f4\u5355\u636e\u65e0\u6cd5\u64a4\u56de");
            }
        }
        LambdaQueryWrapper lambda = Wrappers.lambdaQuery();
        lambda.eq(MonthPlanEntity::getProjectId, (Object)monthPlanEntity.getProjectId());
        List monthPlanEntities = this.monthPlanService.list((Wrapper)lambda);
        if (CollectionUtils.isNotEmpty((Collection)monthPlanEntities)) {
            return CommonResponse.error((String)"\u5df2\u6709\u6708\u8ba1\u5212\u6570\u636e,\u4e0d\u80fd\u64a4\u56de!");
        }
        return CommonResponse.success();
    }

    public CommonResponse<String> afterAbstainingProcessor(Long billId, Integer state, String billTypeCode) {
        return CommonResponse.success();
    }
}

