/*
 * Decompiled with CFR 0.152.
 */
package com.ejianc.wzxt.supplier.controller;

import com.alibaba.fastjson.JSONObject;
import com.ejianc.framework.core.kit.collection.ListUtil;
import com.ejianc.framework.core.response.CommonResponse;
import com.ejianc.framework.core.response.Parameter;
import com.ejianc.framework.core.response.QueryParam;
import com.ejianc.wzxt.supplier.bean.EvalMonthlyEntity;
import com.ejianc.wzxt.supplier.bean.EvalSeasonEntity;
import com.ejianc.wzxt.supplier.bean.EvalYearEntity;
import com.ejianc.wzxt.supplier.mapper.EvalYearMapper;
import com.ejianc.wzxt.supplier.service.IEvalMonthlyService;
import com.ejianc.wzxt.supplier.service.IEvalSeasonService;
import com.ejianc.wzxt.supplier.service.IEvalYearService;
import com.google.common.collect.Lists;
import com.google.common.collect.Maps;
import java.io.Serializable;
import java.math.BigDecimal;
import java.math.RoundingMode;
import java.util.ArrayList;
import java.util.List;
import java.util.concurrent.ConcurrentMap;
import org.apache.commons.lang3.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Controller;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestMethod;
import org.springframework.web.bind.annotation.RequestParam;
import org.springframework.web.bind.annotation.ResponseBody;

@Controller
@RequestMapping(value={"halfYear"})
public class HalfYearPromiseController
implements Serializable {
    private static final long serialVersionUID = 1L;
    private Logger logger = LoggerFactory.getLogger(this.getClass());
    @Autowired
    private EvalYearMapper evalYearMapper;
    @Autowired
    private IEvalYearService yearService;
    @Autowired
    private IEvalMonthlyService monthlyService;
    @Autowired
    private IEvalSeasonService seasonService;

    @RequestMapping(value={"/queryData"}, method={RequestMethod.GET})
    @ResponseBody
    public CommonResponse<List<JSONObject>> queryData(@RequestParam(required=false) String searchText, @RequestParam String year, @RequestParam(required=false) String halfYear) {
        CommonResponse response = new CommonResponse();
        if (StringUtils.isEmpty((CharSequence)year)) {
            return response;
        }
        String yearDate = year + "-01-01";
        String betweenStartDateStr = year + "-01-01";
        String betweenEndDateStr = year + "-06-30";
        String seasonInDateStr = "'\u4e00\u5b63\u5ea6','\u4e8c\u5b63\u5ea6'";
        if (StringUtils.isNotEmpty((CharSequence)halfYear) && halfYear.equals("\u4e0b")) {
            betweenStartDateStr = year + "-07-01";
            betweenEndDateStr = year + "-12-31";
            seasonInDateStr = "'\u4e09\u5b63\u5ea6','\u56db\u5b63\u5ea6'";
        }
        List<JSONObject> list = this.evalYearMapper.queryHalfYearPromiseList(searchText, yearDate, betweenStartDateStr, betweenEndDateStr, seasonInDateStr);
        ArrayList result = Lists.newArrayList();
        if (ListUtil.isNotEmpty(list)) {
            List contractList;
            ConcurrentMap supplierMap = Maps.newConcurrentMap();
            ConcurrentMap supplierInfoMap = Maps.newConcurrentMap();
            for (JSONObject jsonObject : list) {
                QueryParam queryParam;
                Long supplierId = jsonObject.getLong("supplierId");
                contractList = (List)supplierMap.get(supplierId);
                if (ListUtil.isEmpty((List)contractList)) {
                    contractList = Lists.newArrayList();
                    queryParam = new QueryParam();
                    queryParam.getParams().put("supplierId", Parameter.getEqInstance((Object)supplierId));
                    queryParam.getParams().put("period", Parameter.getEqInstance((Object)yearDate));
                    queryParam.getParams().put("billState", new Parameter("in", (Object)"1,3"));
                    List entityList = this.yearService.queryList(queryParam, false);
                    if (ListUtil.isEmpty((List)entityList)) {
                        supplierInfoMap.put(supplierId, new BigDecimal(0));
                    } else {
                        supplierInfoMap.put(supplierId, ((EvalYearEntity)((Object)entityList.get(0))).getScoreTotal());
                    }
                }
                if (StringUtils.isNotEmpty((CharSequence)jsonObject.getString("contractId"))) {
                    queryParam = new QueryParam();
                    queryParam.getParams().put("contractId", Parameter.getEqInstance((Object)jsonObject.getString("contractId")));
                    queryParam.getParams().put("period", new Parameter("between", (Object)(betweenStartDateStr + "," + betweenEndDateStr)));
                    queryParam.getParams().put("billState", new Parameter("in", (Object)"1,3"));
                    List monthlyEntities = this.monthlyService.queryList(queryParam, false);
                    if (ListUtil.isNotEmpty((List)monthlyEntities)) {
                        BigDecimal scoreTotal = new BigDecimal(0);
                        for (EvalMonthlyEntity monthlyEntity : monthlyEntities) {
                            scoreTotal = scoreTotal.add(monthlyEntity.getScoreTotal());
                        }
                        scoreTotal = scoreTotal.divide(new BigDecimal(monthlyEntities.size()), 2, RoundingMode.HALF_UP);
                        jsonObject.put("monthlyScoreAvg", (Object)scoreTotal);
                    } else {
                        jsonObject.put("monthlyScoreAvg", (Object)0);
                    }
                    queryParam.getParams().put("period", Parameter.getEqInstance((Object)yearDate));
                    seasonInDateStr = "\u4e00\u5b63\u5ea6,\u4e8c\u5b63\u5ea6";
                    if (StringUtils.isNotEmpty((CharSequence)halfYear) && halfYear.equals("\u4e0b")) {
                        seasonInDateStr = "\u4e09\u5b63\u5ea6,\u56db\u5b63\u5ea6";
                    }
                    queryParam.getParams().put("season", new Parameter("in", (Object)seasonInDateStr));
                    List seasonEntities = this.seasonService.queryList(queryParam, false);
                    if (ListUtil.isNotEmpty((List)seasonEntities)) {
                        BigDecimal scoreTotal = new BigDecimal(0);
                        for (EvalSeasonEntity seasonEntity : seasonEntities) {
                            scoreTotal = scoreTotal.add(seasonEntity.getScoreTotal());
                        }
                        scoreTotal = scoreTotal.divide(new BigDecimal(seasonEntities.size()), 2, RoundingMode.HALF_UP);
                        jsonObject.put("seasonScoreAvg", (Object)scoreTotal);
                    } else {
                        jsonObject.put("seasonScoreAvg", (Object)0);
                    }
                    jsonObject.put("zzScore", supplierInfoMap.get(supplierId));
                    BigDecimal halfYearScore = jsonObject.getBigDecimal("monthlyScoreAvg").multiply(new BigDecimal("0.6")).add(jsonObject.getBigDecimal("seasonScoreAvg").multiply(new BigDecimal("0.3"))).add(jsonObject.getBigDecimal("zzScore").multiply(new BigDecimal("0.1"))).setScale(2, RoundingMode.HALF_UP);
                    jsonObject.put("halfYearScore", (Object)halfYearScore);
                } else {
                    jsonObject.put("monthlyScoreAvg", (Object)0);
                    jsonObject.put("seasonScoreAvg", (Object)0);
                    jsonObject.put("zzScore", supplierInfoMap.get(supplierId));
                    BigDecimal halfYearScore = jsonObject.getBigDecimal("zzScore").multiply(new BigDecimal("0.1")).setScale(2, RoundingMode.HALF_UP);
                    jsonObject.put("halfYearScore", (Object)halfYearScore);
                }
                contractList.add(jsonObject);
                supplierMap.put(supplierId, contractList);
            }
            int rowNum = 1;
            for (Long supplierId : supplierMap.keySet()) {
                contractList = (List)supplierMap.get(supplierId);
                BigDecimal halfYearScoreTotal = new BigDecimal(0);
                for (JSONObject jsonObject : contractList) {
                    halfYearScoreTotal = halfYearScoreTotal.add(jsonObject.getBigDecimal("halfYearScore"));
                }
                halfYearScoreTotal = halfYearScoreTotal.divide(new BigDecimal(contractList.size()), 2, RoundingMode.HALF_UP);
                for (int i = 0; i < contractList.size(); ++i) {
                    JSONObject jsonObject;
                    jsonObject = (JSONObject)contractList.get(i);
                    jsonObject.put("halfYearScoreTotal", (Object)halfYearScoreTotal);
                    jsonObject.put("rowNum", (Object)rowNum);
                    if (i == 0) {
                        jsonObject.put("supplierRow", (Object)contractList.size());
                    } else {
                        jsonObject.put("supplierRow", (Object)0);
                    }
                    result.add(jsonObject);
                    ++rowNum;
                }
            }
        }
        return CommonResponse.success((String)"\u4fdd\u5b58\u6216\u4fee\u6539\u5355\u636e\u6210\u529f\uff01", (Object)result);
    }

    @RequestMapping(value={"/queryDataList"}, method={RequestMethod.POST})
    @ResponseBody
    public CommonResponse<List<JSONObject>> queryDataList(@RequestBody QueryParam queryParam) {
        if (queryParam.getParams().get("year") == null) {
            return CommonResponse.success((String)"\u67e5\u8be2\u6761\u4ef6\u4e3a\u7a7a\uff01", new ArrayList());
        }
        String year = ((Parameter)queryParam.getParams().get("year")).getValue().toString();
        String halfYear = queryParam.getParams().get("halfYear") == null ? null : ((Parameter)queryParam.getParams().get("halfYear")).getValue().toString();
        String searchText = queryParam.getSearchText() == null ? null : queryParam.getSearchText();
        return this.queryData(searchText, year, halfYear);
    }
}

