package com.ejianc.wzxt.check.service;

import com.ejianc.foundation.share.vo.CooperateVO;
import com.ejianc.foundation.support.vo.ParamsCheckVO;
import com.ejianc.framework.core.response.CommonResponse;
import com.ejianc.framework.skeleton.template.IBaseService;
import com.ejianc.wzxt.check.bean.CheckEntity;
import com.ejianc.wzxt.check.vo.CheckVO;
import com.ejianc.wzxt.op.vo.OpVO;

import javax.servlet.http.HttpServletRequest;
import java.math.BigDecimal;
import java.util.Date;
import java.util.List;
import java.util.Map;

/**
 * 消耗材-验收主表
 *
 * @author generator
 *
 */
public interface ICheckService extends IBaseService<CheckEntity> {

    CheckVO saveOrUpdates(CheckVO saveOrUpdateVO);

    void deletes(List<CheckVO> vos);

    boolean pushBillToSupCenter(String datInfo, Long supplierId, Long sourceId, String billTypeCode, CooperateVO cooperate,String url);

    String updateBillSupSignSyncInfo(HttpServletRequest request);

    ParamsCheckVO checkParams(CheckVO vo, ParamsCheckVO paramsCheckVO2);


    CheckVO queryDetailWeigh(CheckVO vo);

    /**
     * 根据项目id、验收日期查询消耗材、混凝土单据数量
     *
     * @param projectId 项目id
     * @param checkDate 验收日期
     * @return Map<String, Integer>
     */
    Map<String, Integer> countBillNum(Long projectId, Date checkDate);

    void writeBackPlan(CheckEntity checkEntity, boolean isCommit);

    void pushMaterial(CheckEntity checkEntity);

    OpVO pushOp(Long id);
}
