package com.ejianc.wzxt.check.service.impl;

import com.alibaba.fastjson.JSONObject;
import com.ejianc.foundation.material.api.IMaterialapproachApi;
import com.ejianc.foundation.material.vo.MaterialapproachVO;
import com.ejianc.foundation.share.api.IProSupplierApi;
import com.ejianc.foundation.support.api.IBillTypeApi;
import com.ejianc.framework.core.exception.BusinessException;
import com.ejianc.framework.core.kit.mapper.BeanMapper;
import com.ejianc.framework.core.response.CommonResponse;
import com.ejianc.framework.skeleton.billState.service.ICommonBusinessService;
import com.ejianc.wzxt.check.bean.CheckEntity;
import com.ejianc.wzxt.check.service.ICheckService;
import com.ejianc.wzxt.check.vo.SupplierPushCheckDetailVO;
import com.ejianc.wzxt.check.vo.SupplierPushCheckVO;
import com.ejianc.wzxt.delivery.service.IDeliveryService;
import com.ejianc.wzxt.enums.BillPushStatusEnum;
import com.ejianc.wzxt.enums.CheckTypeEnum;
import com.ejianc.wzxt.enums.SignStateEnum;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;
import org.springframework.web.bind.annotation.RequestMethod;

import java.util.HashMap;
import java.util.List;
import java.util.Map;

@Service("check")
public class CheckBpmServiceImpl implements ICommonBusinessService {

    @Autowired
    private IBillTypeApi billTypeApi;
    @Autowired
    private ICheckService checkService;
    @Autowired
    private IMaterialapproachApi materialapproachApi;
    private final String OPERATE = "ZJKJ_CHECK_SYNC";
    @Autowired
    private IProSupplierApi proSupplierApi;
    @Autowired
    private IDeliveryService deliveryService;
    private Logger logger = LoggerFactory.getLogger(this.getClass());
    private static final String BILL_TYPE = "EJCBT202407000006";//此处需要根据实际修改
    private final String PUSH_DELETE_URL = "/zjkj-supbusiness-web/openapi/check/deleteCheck";
    private final String PUSH_SAVE_URL = "/zjkj-supbusiness-web/openapi/check/saveCheck";

    /**
     * 提交前回调
     *
     * @param billId
     * @param state
     * @return
     */
    @Override
    public CommonResponse<String> beforeSubmitProcessor(Long billId, Integer state, String billTypeCode) {
        return CommonResponse.success();
    }


    /**
     * 提交完回调
     *
     * @param
     * @return
     */
    @Override
    public CommonResponse<String> afterSubmitProcessor(Long billId, Integer state, String billTypeCode) {


        //TODO
        return CommonResponse.success();
    }

    /**
     * 有审批流的撤回前回调
     *
     * @param billId
     * @param state
     * @return
     */
    @Override
    public CommonResponse<String> beforeHasBpmBack(Long billId, Integer state, String billTypeCode) {

        return CommonResponse.success();
    }

    /**
     * 有审批流的撤回后回调
     *
     * @param
     * @return
     */
    @Override
    public CommonResponse<String> afterHasBpmBack(Long billId, Integer state, String billTypeCode) {
        return CommonResponse.success();
    }

    ;

    /**
     * 审批节点审批中时节点审批前回调
     *
     * @param billId
     * @param state
     * @return
     */
    @Override
    public CommonResponse<String> beforeInApprovalBack(Long billId, Integer state, String billTypeCode, String sign) {
        return CommonResponse.success();
    }

    ;

    /**
     * 终审审核前回调
     *
     * @param billId
     * @param state
     * @return
     */
    @Override
    public CommonResponse<String> beforeApprovalProcessor(Long billId, Integer state, String billTypeCode) {
        //TODO
        return CommonResponse.success();
    }

    /**
     * 终审审核完回调
     *
     * @param
     * @return
     */
    @Override
    public CommonResponse<String> afterApprovalProcessor(Long billId, Integer state, String billTypeCode) {
        CheckEntity checkEntity = checkService.selectById(billId);
        checkEntity.setCheckState(1);
        if (!CheckTypeEnum.零星材料验收.getCode().equals(checkEntity.getCheckType())) {
            //推送供方处理
            SupplierPushCheckVO supplierPushCheckVO = BeanMapper.map(checkEntity, SupplierPushCheckVO.class);
            supplierPushCheckVO.setSourceId(checkEntity.getId());
            List<SupplierPushCheckDetailVO> checkDetailList = supplierPushCheckVO.getCheckDetailList();
            for (SupplierPushCheckDetailVO supplierPushCheckDetailVO : checkDetailList) {
                supplierPushCheckDetailVO.setSourceId(checkEntity.getId());
                supplierPushCheckDetailVO.setSourceDetailId(supplierPushCheckDetailVO.getId());
                supplierPushCheckDetailVO.setId(null);
            }
            //设置单据当前系统信息
            CommonResponse<String> ejcCloudSystemCode = proSupplierApi.getEjcCloudSystemCode();
            if (!ejcCloudSystemCode.isSuccess()) {
//			throw new BusinessException("获取当前系统编码失败" + ejcCloudSystemCode.getMsg());
                logger.error("获取当前系统编码失败" + ejcCloudSystemCode.getMsg());
            } else {
                //设置当前系统ID
                supplierPushCheckVO.setSystemId(ejcCloudSystemCode.getData());
                String dataInfo = JSONObject.toJSONString(supplierPushCheckVO);
                boolean b = checkService.pushBillToSupCenter(dataInfo, checkEntity.getSupplierId(),
                        checkEntity.getId(), BILL_TYPE, null, PUSH_SAVE_URL);
                if (!b) {
                    logger.error("推送供方失败！单据信息：{}", dataInfo);
                } else {
                    checkEntity.setBillPushFlag(BillPushStatusEnum.推送成功.getStatus());
                }
            }
        }
        checkService.updateById(checkEntity);

        checkService.pushMaterial(checkEntity);

        checkService.writeBackPlan(checkEntity, true);

        return CommonResponse.success();
    }

    /**
     * 弃审前事件回调
     *
     * @param billId
     * @param state
     * @return
     */
    @Override
    public CommonResponse<String> beforeAbstainingProcessor(Long billId, Integer state, String billTypeCode) {
        //是否被其他单据引用
        CommonResponse<String> res = billTypeApi.checkQuote(billTypeCode, billId);
        logger.info("平台返回查询被引用情况" + res.isSuccess() + "----" + res.getMsg());
        if (!res.isSuccess()) {
            return CommonResponse.error("当前单据已被下游业务引用，不能撤回！");
        }

        CheckEntity checkEntity = checkService.selectById(billId);
        if (checkEntity.getSignStatus() == SignStateEnum.已签字.getCode()) {
            return CommonResponse.error("供方已签字,无法撤回");
        }

        return CommonResponse.success();
    }

    /**
     * 弃审后事件回调
     *
     * @param billId
     * @param state
     * @return
     */
    @Override
    public CommonResponse<String> afterAbstainingProcessor(Long billId, Integer state, String billTypeCode) {
        CheckEntity checkEntity = checkService.selectById(billId);
        CommonResponse<MaterialapproachVO> response = materialapproachApi.queryByCheckId(billId);
        if (response.isSuccess() && null != response.getData() && 1 == response.getData().getUseFlag()) {
            throw new BusinessException("该单据对应商务系统中的【物资进场验证记录】已被引用，不允许撤回!");
        }
        if (BillPushStatusEnum.推送成功.getStatus().equals(checkEntity.getBillPushFlag())) {
            //推送供方
            //对单据进行加锁
            CommonResponse<String> ejcCloudSystemCode = proSupplierApi.getEjcCloudSystemCode();
            if (!ejcCloudSystemCode.isSuccess()) {
                throw new BusinessException("获取当前系统编码失败！");
            }
            Map<String, Object> map = new HashMap<>();
            map.put("sourceId", billId);
            map.put("systemId", ejcCloudSystemCode.getData());
            String dataInfo = JSONObject.toJSONString(map);
            Boolean updateSupplierStatus = deliveryService.updateSupplierStatus(billId, dataInfo, PUSH_DELETE_URL, RequestMethod.POST,
                    checkEntity.getSupplierId().toString(), OPERATE, BILL_TYPE);
            if (!updateSupplierStatus) {
                throw new BusinessException("单据推送失败！");
            }
            checkEntity.setBillPushFlag(BillPushStatusEnum.未成功推送.getStatus());
            checkService.saveOrUpdate(checkEntity, false);
        }

        materialapproachApi.delPush(billId);

        checkService.writeBackPlan(checkEntity, false);

        return CommonResponse.success();
    }

  /*  @Override
    public CommonResponse<JSONObject> getBpmVariable(Long billId, String billTypeCode) {
        CheckEntity checkEntity = checkService.selectById(billId);
        ParamsCheckVO paramsCheckVO = checkService.priceCheckParams(BeanMapper.map(checkEntity, CheckVO.class));
        JSONObject object = new JSONObject();
        if (null != paramsCheckVO && CollectionUtils.isNotEmpty(paramsCheckVO.getDataSource())) {
            object.put("priceFlag", "是");//是单价异常
        } else {
            object.put("priceFlag", "否");//否 单价异常
        }
        return CommonResponse.success(object);
    }*/

}
