package com.ejianc.wzxt.delivery.service.impl;

import com.alibaba.fastjson.JSONObject;
import com.ejianc.business.weigh.wagon.api.IWagonMaterialApi;
import com.ejianc.business.weigh.wagon.vo.WagonMaterialVO;
import com.ejianc.business.weigh.weighbill.api.IPushThirdDataApi;
import com.ejianc.business.weigh.weighbill.vo.WeighApplyThirdVO;
import com.ejianc.framework.core.kit.mapper.BeanMapper;
import com.ejianc.framework.core.response.CommonResponse;
import com.ejianc.framework.core.util.ComputeUtil;
import com.ejianc.framework.skeleton.template.BaseServiceImpl;
import com.ejianc.wzxt.delivery.bean.WeighApplyEntity;
import com.ejianc.wzxt.delivery.mapper.WeighApplyMapper;
import com.ejianc.wzxt.delivery.service.IWeighApplyService;
import com.ejianc.wzxt.delivery.vo.WeighApplyVO;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;

import java.math.BigDecimal;

/**
 * 过磅申请
 *
 * @author generator
 *
 */
@Service("weighApplyService")
public class WeighApplyServiceImpl extends BaseServiceImpl<WeighApplyMapper, WeighApplyEntity> implements IWeighApplyService {

    private final Logger logger = LoggerFactory.getLogger(getClass());

    @Autowired
    private IPushThirdDataApi pushThirdDataApi;
    @Autowired
    private IWagonMaterialApi wagonMaterialApi;

    @Override
    public WeighApplyVO saveOrUpdate(WeighApplyVO saveOrUpdateVO) {
        if (saveOrUpdateVO.getPcCarInfoFlag()) {
            CommonResponse<WagonMaterialVO> response = wagonMaterialApi.queryMaterialAutomaticWeigh(saveOrUpdateVO.getProjectId(), saveOrUpdateVO.getMaterialId());
            if (response.isSuccess() && null != response.getData()) {
                WagonMaterialVO materialVO = response.getData();
                saveOrUpdateVO.setMaterialAmount(ComputeUtil.safeDiv(ComputeUtil.safeMultiply(saveOrUpdateVO.getMaterialAmount(), materialVO.getScaleFactor()), BigDecimal.valueOf(100)));
            }
        }
        WeighApplyEntity entity = BeanMapper.map(saveOrUpdateVO, WeighApplyEntity.class);
        saveOrUpdate(entity, false);
        WeighApplyVO vo = BeanMapper.map(entity, WeighApplyVO.class);

        WeighApplyThirdVO thirdVO = BeanMapper.map(entity, WeighApplyThirdVO.class);
        logger.info("消耗材推送第三方数据参数----：{}", JSONObject.toJSONString(thirdVO));
        CommonResponse<String> thirdRes = pushThirdDataApi.pushApplyToThird(thirdVO);
        if (!thirdRes.isSuccess()) {
            logger.info("消耗材推送第三方数据----返回异常信息：{}", JSONObject.toJSONString(thirdRes.getMsg()));
        } else {
            logger.info("消耗材推送第三方数据----返回信息：{}", JSONObject.toJSONString(thirdRes.getMsg()));
            entity.setTicketId(thirdRes.getData());
        }
        super.updateById(entity);
        /** 推送订单，运单-------------结束 */
        return vo;
    }
}
