
package com.ejianc.wzxt.enums;

import java.util.EnumSet;
import java.util.HashMap;
import java.util.Map;
import java.util.function.Function;
import java.util.stream.Collectors;

public enum CheckResultEnum {
    GOOD_STATE(1, "合格"),
    WORSE_STATE(2, "不合格"),
    WAIT_STATE(3, "待验");

    private final Integer checkResultCode;
    private final String description;
    private static Map<Integer, CheckResultEnum> enumMap = new HashMap();

    private CheckResultEnum(Integer billStateCode, String description) {
        this.checkResultCode = billStateCode;
        this.description = description;
    }

    public Integer getCheckResultCode() {
        return checkResultCode;
    }

    public String getDescription() {
        return this.description;
    }

    public static CheckResultEnum getEnumByResultCode(Integer checkResultCode) {
        return (CheckResultEnum)enumMap.get(checkResultCode);
    }

    static {
        enumMap = (Map)EnumSet.allOf(CheckResultEnum.class).stream().collect(Collectors.toMap(CheckResultEnum::getCheckResultCode, Function.identity(), (k1, k2) -> {
            return k2;
        }));
    }
}
