package com.ejianc.wzxt.enums;

import java.util.EnumSet;
import java.util.HashMap;
import java.util.Map;
import java.util.function.Function;
import java.util.stream.Collectors;

public enum OutTypeEnum {
    物资处置(1, "物资处置"),
    送货出场(2, "送货出场"),
    其他(3, "其他");

    OutTypeEnum(Integer status, String statusName) {
        this.statusName = statusName;
        this.status = status;
    }

    private Integer status;
    private String statusName;
    private static Map<Integer, OutTypeEnum> enumMap = new HashMap();

    public String getStatusName() {
        return statusName;
    }

    public Integer getStatus() {
        return status;
    }


    public static OutTypeEnum getEnumByStatus(Integer status) {
        return (OutTypeEnum)enumMap.get(status);
    }

    static {
        enumMap = (Map) EnumSet.allOf(OutTypeEnum.class).stream().collect(Collectors.toMap(OutTypeEnum::getStatus, Function.identity(), (k1, k2) -> {
            return k2;
        }));
    }
}
