package com.ejianc.wzxt.op.service.impl;

import com.alibaba.fastjson.JSONObject;
import com.ejianc.foundation.file.api.IAttachmentApi;
import com.ejianc.foundation.support.api.IBillCodeApi;
import com.ejianc.foundation.support.vo.BillCodeParam;
import com.ejianc.framework.auth.session.SessionManager;
import com.ejianc.framework.auth.session.UserContext;
import com.ejianc.framework.core.context.InvocationInfoProxy;
import com.ejianc.framework.core.exception.BusinessException;
import com.ejianc.framework.core.kit.mapper.BeanMapper;
import com.ejianc.framework.core.response.BillStateEnum;
import com.ejianc.framework.core.response.CommonResponse;
import com.ejianc.framework.skeleton.template.BaseServiceImpl;
import com.ejianc.support.idworker.util.IdWorker;
import com.ejianc.wzxt.op.bean.OpEntity;
import com.ejianc.wzxt.op.mapper.OpMapper;
import com.ejianc.wzxt.op.service.IOpService;
import com.ejianc.wzxt.op.vo.OpDetailVO;
import com.ejianc.wzxt.op.vo.OpVO;
import org.apache.commons.lang3.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;

import java.util.ArrayList;
import java.util.List;
import java.util.stream.Collectors;

/**
 * 出门证主表
 *
 * @author generator
 *
 */
@Service("opService")
public class OpServiceImpl extends BaseServiceImpl<OpMapper, OpEntity> implements IOpService{

    private Logger logger = LoggerFactory.getLogger(this.getClass());

    @Autowired
    private IBillCodeApi billCodeApi;
    @Autowired
    private SessionManager sessionManager;
    @Autowired
    private IAttachmentApi attachmentApi;

    private static final String BILL_CODE = "ZJKJ-OP";

    @Override
    public OpVO push(OpVO opVO) {
        logger.error("apply push is " + JSONObject.toJSONString(opVO));
//        if (StringUtils.isBlank(opVO.getLinkUrlPc())) {
//            throw new BusinessException("PC联查页面不能为空");
//        }
//        if (StringUtils.isBlank(opVO.getLinkUrlMobile())) {
//            throw new BusinessException("移动端联查页面不能为空");
//        }
//        if (StringUtils.isBlank(opVO.getSourceId())) {
//            throw new BusinessException("来源单据主键不能为空");
//        }
//        if (StringUtils.isBlank(opVO.getSourceType())) {
//            throw new BusinessException("来源单据类型不能为空");
//        }
//        if (StringUtils.isBlank(opVO.getSourceType())) {
//            throw new BusinessException("来源单据类型名称不能为空");
//        }
        OpEntity entity = BeanMapper.map(opVO, OpEntity.class);
        entity.setId(IdWorker.getId());
        entity.setCarNumber(StringUtils.trimToNull(entity.getCarNumber()));

        CommonResponse<String> billCode = billCodeApi.getCodeBatchByRuleCode(BILL_CODE, InvocationInfoProxy.getTenantid());
        if(billCode.isSuccess()) {
            entity.setBillCode(billCode.getData());
        }else{
            throw new BusinessException("网络异常,编码生成失败,请稍后再试");
        }
        UserContext context = sessionManager.getUserContext();
        entity.setBillState(BillStateEnum.UNCOMMITED_STATE.getBillStateCode());
        entity.setApplyUser(context.getUserName());
        entity.setEmployeeId(context.getEmployeeId());
        entity.setEmployeeName(context.getEmployeeName());

        //复制图片
        if (StringUtils.isNotBlank(opVO.getSourceBussType())) {
            if(opVO.getSourceId().indexOf("@") > 0){
                for(String sourceId : opVO.getSourceId().split("@")){
                    attachmentApi.copyFilesFromSourceBillToTargetBill(sourceId,
                            opVO.getSourceType(), opVO.getSourceBussType(),
                            String.valueOf(entity.getId()), "EJCBT202408000010", "siteImg");
                }
            }else {
                attachmentApi.copyFilesFromSourceBillToTargetBill(opVO.getSourceId(),
                        opVO.getSourceType(), opVO.getSourceBussType(),
                        String.valueOf(entity.getId()), "EJCBT202408000010", "siteImg");
            }
        }

        saveOrUpdate(entity, false);
        return BeanMapper.map(entity, OpVO.class);
    }

    @Override
    public OpVO saveOrUpdate(OpVO saveOrUpdateVO) {
        OpEntity entity = BeanMapper.map(saveOrUpdateVO, OpEntity.class);
        if(entity.getId() == null || entity.getId() == 0){
            BillCodeParam billCodeParam = BillCodeParam.build(BILL_CODE,InvocationInfoProxy.getTenantid(),saveOrUpdateVO);
            CommonResponse<String> billCode = billCodeApi.generateBillCode(billCodeParam);
            if(billCode.isSuccess()) {
                entity.setBillCode(billCode.getData());//此处需要根据实际修改 删除本行或者上一行
            }else{
                throw new BusinessException("网络异常， 编码生成失败， 请稍后再试");
            }
        }
        List<String> nameList = saveOrUpdateVO.getDetailList().stream().map(OpDetailVO::getName).collect(Collectors.toList());
        entity.setMaterialName(StringUtils.join(nameList, ","));
        saveOrUpdate(entity, false);
        OpVO vo = BeanMapper.map(entity, OpVO.class);
        return vo;
    }
}
