package com.ejianc.wzxt.plan.service.impl;

import com.alibaba.fastjson.JSONObject;
import com.baomidou.mybatisplus.core.conditions.query.LambdaQueryWrapper;
import com.baomidou.mybatisplus.core.toolkit.Wrappers;
import com.ejianc.foundation.costmanage.api.CostanalysisApi;
import com.ejianc.foundation.costmanage.vo.ResponsepartdetailApiVO;
import com.ejianc.foundation.share.utils.TreeNodeBUtil;
import com.ejianc.foundation.support.api.IBillCodeApi;
import com.ejianc.foundation.support.api.IParamConfigApi;
import com.ejianc.foundation.support.vo.BillCodeParam;
import com.ejianc.foundation.support.vo.BillParamVO;
import com.ejianc.foundation.support.vo.ParamsCheckDsVO;
import com.ejianc.foundation.support.vo.ParamsCheckVO;
import com.ejianc.framework.core.context.InvocationInfoProxy;
import com.ejianc.framework.core.exception.BusinessException;
import com.ejianc.framework.core.kit.mapper.BeanMapper;
import com.ejianc.framework.core.response.BillStateEnum;
import com.ejianc.framework.core.response.CommonResponse;
import com.ejianc.framework.core.response.Parameter;
import com.ejianc.framework.core.response.QueryParam;
import com.ejianc.framework.core.util.ComputeUtil;
import com.ejianc.framework.core.util.ResultAsTree;
import com.ejianc.support.idworker.util.IdWorker;
import com.ejianc.wzxt.check.vo.CheckDetailVO;
import com.ejianc.wzxt.check.vo.CheckVO;
import com.ejianc.wzxt.enums.CheckTypeEnum;
import com.ejianc.wzxt.order.bean.OrderDetailEntity;
import com.ejianc.wzxt.plan.bean.MasterPlanDetailEntity;
import com.ejianc.wzxt.plan.enums.ChangeTypeEnum;
import com.ejianc.wzxt.plan.service.IMasterPlanChangeService;
import com.ejianc.wzxt.plan.service.IMasterPlanDetailService;
import com.ejianc.wzxt.plan.vo.MasterPlanContrastVO;
import com.ejianc.wzxt.plan.vo.MasterPlanDetailVO;
import com.ejianc.wzxt.plan.vo.MasterPlanVO;
import org.apache.commons.collections.CollectionUtils;
import org.apache.commons.lang3.StringUtils;
import org.elasticsearch.common.inject.spi.HasDependencies;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;
import com.ejianc.framework.skeleton.template.BaseServiceImpl;

import com.ejianc.wzxt.plan.mapper.MasterPlanMapper;
import com.ejianc.wzxt.plan.bean.MasterPlanEntity;
import com.ejianc.wzxt.plan.service.IMasterPlanService;

import java.math.BigDecimal;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.function.Function;
import java.util.stream.Collectors;

/**
 * 材料总控计划-主表
 * 
 * @author generator
 * 
 */
@Service("masterPlanService")
public class MasterPlanServiceImpl extends BaseServiceImpl<MasterPlanMapper, MasterPlanEntity> implements IMasterPlanService{
    private static final String BILL_CODE = "ZJKJ_MASTER_PLAN";
    @Autowired
    private IBillCodeApi billCodeApi;
    @Autowired
    private IMasterPlanDetailService masterPlanDetailService;
    @Autowired
    private IMasterPlanChangeService masterPlanChangeService;

    private static final String RESPONSE_CHECK_CODE = "P-p76bQ90296";//数量控制

    private Logger logger = LoggerFactory.getLogger(this.getClass());




    @Autowired
    private IParamConfigApi paramConfigApi;
    @Autowired
    private MasterPlanMapper masterPlanMapper;
    @Autowired
    private CostanalysisApi costanalysisApi;


    @Override
    public MasterPlanVO saveOrUpdate(MasterPlanVO saveOrUpdateVO) {

        MasterPlanEntity entity = BeanMapper.map(saveOrUpdateVO, MasterPlanEntity.class);
        if(entity.getId() == null || entity.getId() == 0){
            BillCodeParam billCodeParam = BillCodeParam.build(BILL_CODE,InvocationInfoProxy.getTenantid(),saveOrUpdateVO);
            CommonResponse<String> billCode = billCodeApi.generateBillCode(billCodeParam);
            if(billCode.isSuccess()) {
                entity.setPlanCode(billCode.getData());
            }else{
                throw new BusinessException("网络异常， 编码生成失败， 请稍后再试");
            }
        }

        if(null == saveOrUpdateVO.getId()) {
            entity.setId(IdWorker.getId());
            //设置为未变更
            entity.setChangeState(0);
            //设置为自由态
            entity.setBillState(BillStateEnum.UNCOMMITED_STATE.getBillStateCode());
            //变更版本号
            entity.setChangeVersion(1);
            //设置编制人
//            saveEntity.setCreateUserName(userContext.getUserName());
        }
        List<MasterPlanDetailEntity> detailEntities = entity.getMasterPlanDetailList();
        if (CollectionUtils.isNotEmpty(detailEntities)) {
            for (MasterPlanDetailEntity masterPlanDetailEntity : detailEntities) {
                masterPlanDetailEntity.setChangeType(ChangeTypeEnum.未变更.getCode());
            }
        }

        super.saveOrUpdate(entity, false);
        MasterPlanVO vo = BeanMapper.map(entity, MasterPlanVO.class);
        return vo;
    }

    @Override
    public MasterPlanVO queryDetail(Long id) {

        MasterPlanEntity masterPlanEntity = super.selectById(id);
        MasterPlanVO masterPlanVO =  BeanMapper.map(masterPlanEntity, MasterPlanVO.class);
        QueryParam queryParam = new QueryParam();
        queryParam.getParams().put("materialMasterPlanId", new Parameter(QueryParam.EQ, id));
//        queryParam.getOrderMap().put("treeIndex", "asc");
        List<MasterPlanDetailEntity> detailEntityListDb = masterPlanDetailService.queryList(queryParam, false);
        List<MasterPlanDetailEntity> detailEntityList = new ArrayList<>();
        if(CollectionUtils.isNotEmpty(detailEntityListDb)) {
            detailEntityListDb.forEach(entity ->{
                if(null == entity.getChangeType() || ChangeTypeEnum.中止项.getCode() != entity.getChangeType()){
                    detailEntityList.add(entity);
                }
            });
        }

        if(CollectionUtils.isNotEmpty(detailEntityList)) {
            for(MasterPlanDetailEntity cdEntity : detailEntityList){
                cdEntity.setRowState("edit");
            }
            List<MasterPlanDetailVO> resultMapList = BeanMapper.mapList(detailEntityList, MasterPlanDetailVO.class);
            masterPlanVO.setMasterPlanDetailList(resultMapList);

        } else {
            masterPlanVO.setMasterPlanDetailList(BeanMapper.mapList(detailEntityList, MasterPlanDetailVO.class));
        }

        if(null != masterPlanEntity.getChangeVersion() && masterPlanEntity.getChangeVersion() > 0){
            masterPlanVO.setMasterPlanChangeHisList(masterPlanChangeService.queryDetailRecord(masterPlanEntity.getId()));
        }
        return masterPlanVO;

    }

    @Override
    public List<MasterPlanContrastVO> getContrastInfo(Long materialMasterPlanId, Long oldMaterialMasterPlanId) {
        return  masterPlanMapper.getContrastInfo(materialMasterPlanId,oldMaterialMasterPlanId);
    }
    private List<ParamsCheckVO> responseCtrlNum(MasterPlanVO masterPlanVO) {
        // 三种控制方式：不控制，提醒，无法保存 (默认为提醒)
        String[] paramsArray = {"none", "warn", "alert"};
        List<ParamsCheckVO> paramsCheckVOList = new ArrayList<>();
        List<MasterPlanDetailVO> masterPlanDetailList = masterPlanVO.getMasterPlanDetailList();
        Map<Long, BigDecimal> numMasterPlanMap = new HashMap<>();
        if (CollectionUtils.isNotEmpty(masterPlanDetailList)){
            numMasterPlanMap = masterPlanDetailList.stream().filter(s -> s.getRowState() == null || !s.getRowState().equals("del")).collect(Collectors.groupingBy(MasterPlanDetailVO::getMaterialCategoryId,
                    Collectors.collectingAndThen(Collectors.toList(), m -> m.stream().map(a -> a.getPlanTotalNum()).reduce(BigDecimal.ZERO, BigDecimal::add))));
        }

        CommonResponse<List<ResponsepartdetailApiVO>> queryResponsibilitycost = costanalysisApi.queryResponseByProjectId(masterPlanVO.getProjectId());
        if (!queryResponsibilitycost.isSuccess()){
            throw new BusinessException("根据项目查询责任成本失败");
        }
        List<ResponsepartdetailApiVO> queryResponsibilitycostData = queryResponsibilitycost.getData();
        Map<Long, ResponsepartdetailApiVO> responsepartdetailApiVOMap = queryResponsibilitycostData.stream().collect(Collectors.toMap(ResponsepartdetailApiVO::getMaterialTypeId, Function.identity(), (k1, k2) -> k1));

        CommonResponse<List<BillParamVO>> billParamByCode = paramConfigApi.getBillParamByCodeAndOrgId(RESPONSE_CHECK_CODE, masterPlanVO.getParentOrgId());
        if (billParamByCode.isSuccess() && null != billParamByCode.getData()) {

            List<BillParamVO> data = billParamByCode.getData();
            logger.info("总控计划量大于责任成本量控制：" + JSONObject.toJSONString(data));
            if (CollectionUtils.isNotEmpty(data)) {
                for (MasterPlanDetailVO detailVO : masterPlanVO.getMasterPlanDetailList()) {

                    BigDecimal responseNum = responsepartdetailApiVOMap.containsKey(detailVO.getMaterialCategoryId()) ? responsepartdetailApiVOMap.get(detailVO.getMaterialCategoryId()).getQuantityOfWorkZ() : BigDecimal.ZERO;
                    BigDecimal masterPlanNum = numMasterPlanMap.containsKey(detailVO.getMaterialCategoryId()) ? numMasterPlanMap.get(detailVO.getMaterialCategoryId()) : BigDecimal.ZERO;
                    for (BillParamVO datum : data) {
                        ParamsCheckVO paramsCheckVO = new ParamsCheckVO();
                        List<ParamsCheckDsVO> checkDsVOS = new ArrayList<>();
                        BigDecimal roleValue = datum.getRoleValue();//参数值
                        paramsCheckVO.setWarnType(paramsArray[datum.getControlType()]);
                        BigDecimal compareNum = ComputeUtil.safeMultiply(responseNum, ComputeUtil.safeDiv(roleValue, BigDecimal.valueOf(100)));
                        if (ComputeUtil.isGreaterThan(masterPlanNum, compareNum)) {
                            ParamsCheckDsVO paramsCheckDsVO = new ParamsCheckDsVO();
                            paramsCheckDsVO.setOrgName(datum.getOrgName());
                            paramsCheckDsVO.setWarnItem("总控计划量大于责任成本量");
                            paramsCheckDsVO.setWarnName("总控计划量大于责任成本量");
                            StringBuffer stringBuffer = new StringBuffer();
//                            当前总计划 清单中【材料名称】【规格型号】的总计划量，已超责任成本量，请调整责任成本后再进行保存。

                            stringBuffer.append("当前总计划 清单中【").append(detailVO.getMaterialName()).append("】【").append(detailVO.getSpec()).append("】所属分类的总计划量").append(ComputeUtil.nullToZero(masterPlanNum).setScale(3, BigDecimal.ROUND_HALF_UP))
                                    .append("，责任成本量:").append(ComputeUtil.nullToZero(compareNum).setScale(3, BigDecimal.ROUND_HALF_UP))
                                    .append("。超出量：").append(ComputeUtil.safeSub(masterPlanNum, compareNum).setScale(3, BigDecimal.ROUND_HALF_UP));
                            paramsCheckDsVO.setContent(stringBuffer.toString());
                            checkDsVOS.add(paramsCheckDsVO);
                        }
                        paramsCheckVO.setDataSource(checkDsVOS);
                        paramsCheckVOList.add(paramsCheckVO);
                    }
                }
            }

        } else {
            logger.info(billParamByCode.getMsg());
            throw new BusinessException("获取控制参数失败");
        }
        return paramsCheckVOList;
    }

    @Override
    public ParamsCheckVO checkParams(MasterPlanVO vo, ParamsCheckVO paramsCheckVO2) {


        List<ParamsCheckVO> paramsCheckVOS = new ArrayList<>();
        ParamsCheckVO paramsCheckVO = new ParamsCheckVO();
        paramsCheckVO.setWarnType("none");

        paramsCheckVOS.addAll(responseCtrlNum(vo));

        /*预警参数添加域*/
        Map<String, List<ParamsCheckDsVO>> map = new HashMap<>();
        String[] paramsArray = {"alert", "warn", "none"};
        if (CollectionUtils.isNotEmpty(paramsCheckVOS)) {
            for (ParamsCheckVO checkVO : paramsCheckVOS) {
                String warnType = checkVO.getWarnType();
                if (map.containsKey(warnType)) {
                    List<ParamsCheckDsVO> checkDsVOS = map.get(warnType);
                    checkDsVOS.addAll(checkVO.getDataSource());
                    map.put(warnType, checkDsVOS);
                } else {
                    map.put(warnType, checkVO.getDataSource());
                }
            }
        }
        for (String s : paramsArray) {
            if (map.containsKey(s)) {
                paramsCheckVO.setWarnType(s);
                paramsCheckVO.setDataSource(map.get(s));
                if (CollectionUtils.isEmpty(paramsCheckVO.getDataSource())) {
                    paramsCheckVO.setWarnType("none");
                } else {
                    return paramsCheckVO;
                }
            }
        }
        return paramsCheckVO;
    }

}
