package com.ejianc.wzxt.plan.service.impl;

import com.alibaba.fastjson.JSONObject;
import com.ejianc.foundation.share.api.IProSupplierApi;
import com.ejianc.foundation.support.api.IBillTypeApi;
import com.ejianc.framework.core.exception.BusinessException;
import com.ejianc.framework.core.response.CommonResponse;
import com.ejianc.framework.skeleton.billState.service.ICommonBusinessService;
import com.ejianc.wzxt.plan.bean.MaterialPlanEntity;
import com.ejianc.wzxt.plan.service.IMasterPlanService;
import com.ejianc.wzxt.plan.service.IMaterialPlanService;
import com.ejianc.wzxt.plan.service.IMonthPlanService;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;
import org.springframework.web.bind.annotation.RequestMethod;

import java.util.HashMap;
import java.util.Map;

@Service("materialPlan") 
public class MaterialPlanBpmServiceImpl implements ICommonBusinessService {

    @Autowired
    private IBillTypeApi billTypeApi;
	@Autowired
	private IMasterPlanService service;
	@Autowired
	private IMonthPlanService monthPlanService;

	private Logger logger = LoggerFactory.getLogger(this.getClass());

	@Autowired
	private IMaterialPlanService materialPlanService;

	private final String PUSH_DELETE_URL = "/zjkj-supbusiness-web/openapi/materialPlan/delSupPLan";
	private final String OPERATE = "ZJKJ_MATERIAL_PLAN_SYNC";

	private static final String BILL_TYPE = "EJCBT202407000006";//此处需要根据实际修改

	@Autowired
	private IProSupplierApi proSupplierApi;


	/**
	 * 提交前回调
	 * 
	 * @param billId
	 * @param state
	 * @return
	 */
	@Override
	public CommonResponse<String> beforeSubmitProcessor(Long billId, Integer state, String billTypeCode) {
		//TODO
		return CommonResponse.success();
	};

	/**
	 * 提交完回调
	 *
	 * @param
	 * @return
	 */
	@Override
	public CommonResponse<String> afterSubmitProcessor(Long billId, Integer state, String billTypeCode){
		//TODO
		return CommonResponse.success();
	}

	/**
	 * 有审批流的撤回前回调
	 *
	 * @param billId
	 * @param state
	 * @return
	 */
	@Override
	public CommonResponse<String> beforeHasBpmBack(Long billId, Integer state, String billTypeCode) {

		return CommonResponse.success();
	};

	/**
	 * 有审批流的撤回后回调
	 *
	 * @param
	 * @return
	 */
	@Override
	public CommonResponse<String> afterHasBpmBack(Long billId, Integer state, String billTypeCode){
		return CommonResponse.success();
	};

	/**
	 * 审批节点审批中时节点审批前回调
	 *
	 * @param billId
	 * @param state
	 * @return
	 */
	@Override
	public CommonResponse<String> beforeInApprovalBack(Long billId, Integer state, String billTypeCode, String sign) {
		return CommonResponse.success();
	};

	/**
	 * 终审审核前回调
	 * 
	 * @param billId
	 * @param state
	 * @return
	 */
	@Override
	public CommonResponse<String> beforeApprovalProcessor(Long billId, Integer state, String billTypeCode) {
		//

		return CommonResponse.success();
	}

	/**
	 * 终审审核完回调
	 * 
	 * @param
	 * @return
	 */
	@Override
	public CommonResponse<String> afterApprovalProcessor(Long billId, Integer state, String billTypeCode) {
		//TODO
		MaterialPlanEntity materialPlanEntity = materialPlanService.selectById(billId);
		//推送供方平台
		materialPlanService.pushBillToSupCenter(materialPlanEntity,billTypeCode);


		return CommonResponse.success();
	}

	/**
	 * 弃审前事件回调
	 * 
	 * @param billId
	 * @param state
	 * @return
	 */
	@Override
	public CommonResponse<String> beforeAbstainingProcessor(Long billId, Integer state, String billTypeCode) {

		MaterialPlanEntity materialPlanEntity = materialPlanService.selectById(billId);
		if (materialPlanEntity.getSignStatus() == 2){
			return CommonResponse.error("已签字,不允许撤回!");
		}


		return CommonResponse.success();
	}

	/**
	 * 弃审后事件回调
	 * 
	 * @param billId
	 * @param state
	 * @return
	 */
	@Override
	public CommonResponse<String> afterAbstainingProcessor(Long billId, Integer state, String billTypeCode) {
		//推送供方, 删除供方计划
		MaterialPlanEntity materialPlanEntity = materialPlanService.selectById(billId);
		//推送供方
		//对单据进行加锁
		CommonResponse<String> ejcCloudSystemCode = proSupplierApi.getEjcCloudSystemCode();
		if (!ejcCloudSystemCode.isSuccess()) {
			throw new BusinessException("获取当前系统编码失败！");
		}
		Map<String, Object> map = new HashMap<>();
		map.put("sourceId", billId);
		map.put("systemId", ejcCloudSystemCode.getData());
		String dataInfo = JSONObject.toJSONString(map);
		Boolean updateSupplierStatus = materialPlanService.delSupPLan(billId, dataInfo, PUSH_DELETE_URL, RequestMethod.POST,
				materialPlanEntity.getSupplierId().toString(), OPERATE, BILL_TYPE);
		if (!updateSupplierStatus) {
			throw new BusinessException("单据推送失败！");
		}
//		materialPlanEntity.setBillPushFlag(BillPushStatusEnum.未成功推送.getStatus());
//		checkService.saveOrUpdate(materialPlanEntity, false);
		return CommonResponse.success();
	}

}
