package com.ejianc.wzxt.plan.service.impl;

import com.alibaba.fastjson.JSONObject;
import com.baomidou.mybatisplus.core.conditions.query.LambdaQueryWrapper;
import com.baomidou.mybatisplus.core.conditions.query.QueryWrapper;
import com.baomidou.mybatisplus.core.toolkit.Wrappers;
import com.ejianc.foundation.orgcenter.api.IOrgApi;
import com.ejianc.foundation.support.api.IBillCodeApi;
import com.ejianc.foundation.support.api.IBillTypeApi;
import com.ejianc.foundation.support.api.IParamConfigApi;
import com.ejianc.foundation.support.vo.BillCodeParam;
import com.ejianc.foundation.support.vo.BillParamVO;
import com.ejianc.foundation.support.vo.ParamsCheckDsVO;
import com.ejianc.foundation.support.vo.ParamsCheckVO;
import com.ejianc.framework.auth.session.SessionManager;
import com.ejianc.framework.auth.session.UserContext;
import com.ejianc.framework.core.context.InvocationInfoProxy;
import com.ejianc.framework.core.exception.BusinessException;
import com.ejianc.framework.core.kit.mapper.BeanMapper;
import com.ejianc.framework.core.response.BillStateEnum;
import com.ejianc.framework.core.response.CommonResponse;
import com.ejianc.framework.core.util.ComputeUtil;
import com.ejianc.framework.skeleton.template.BaseVO;
import com.ejianc.support.idworker.util.IdWorker;
import com.ejianc.wzxt.plan.bean.*;
import com.ejianc.wzxt.plan.mapper.MonthPlanChangeHisMapper;
import com.ejianc.wzxt.plan.service.IMasterPlanService;
import com.ejianc.wzxt.plan.service.IMonthPlanService;
import com.ejianc.wzxt.plan.vo.*;
import org.apache.commons.collections.CollectionUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;
import com.ejianc.framework.skeleton.template.BaseServiceImpl;

import com.ejianc.wzxt.plan.mapper.MonthPlanChangeMapper;
import com.ejianc.wzxt.plan.bean.MonthPlanChangeEntity;
import com.ejianc.wzxt.plan.service.IMonthPlanChangeService;
import org.springframework.transaction.annotation.Transactional;

import java.math.BigDecimal;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.function.Function;
import java.util.stream.Collectors;

/**
 * 材料月计划变更-主表
 * 
 * @author generator
 * 
 */
@Service("monthPlanChangeService")
public class MonthPlanChangeServiceImpl extends BaseServiceImpl<MonthPlanChangeMapper, MonthPlanChangeEntity> implements IMonthPlanChangeService{
    @Autowired
    private IMonthPlanChangeService service;
    @Autowired
    private IBillTypeApi billTypeApi;
    @Autowired
    private IBillCodeApi billCodeApi;
    @Autowired
    private MonthPlanChangeMapper planChangeMapper;
    @Autowired
    private MonthPlanChangeHisMapper monthPlanChangeHisMapper;

    private static final String MASTER_CHECK_CODE = "P-40x8720297";//数量控制
    @Autowired
    private IMasterPlanService masterPlanService;


    private Logger logger = LoggerFactory.getLogger(this.getClass());

    @Autowired
    private IParamConfigApi paramConfigApi;


    @Autowired
    private IMonthPlanService monthPlanService;
    @Autowired
    private IOrgApi iOrgApi;

    private static final String BILL_CODE = "MONTHCHANGEPLAN";//此处需要根据实际修改
    @Autowired
    private SessionManager sessionManager;
    @Override
    public MonthPlanChangeVO saveOrUpdate(MonthPlanChangeVO planVo) {
        //校验项目是否存在未完成的变更计划单存在
        MonthPlanChangeEntity planChangeEntity = service.getUnFinishedChange(planVo.getSourcePlanId());

        if (null != planChangeEntity && (null == planVo.getId() || !planChangeEntity.getId().equals(planVo.getId()))) {
            throw new BusinessException("保存失败，该项目存在未完成的材料总计划变更单！");
        }
        MonthPlanEntity monthPlan = monthPlanService.getById(planVo.getSourcePlanId());
        UserContext userContext = sessionManager.getUserContext();
        MonthPlanChangeEntity saveEntity = null;
        if (null == planVo.getId()) {
            saveEntity = BeanMapper.map(planVo, MonthPlanChangeEntity.class);
            saveEntity.setId(IdWorker.getId());
            //设置为自由态
            saveEntity.setBillState(BillStateEnum.UNCOMMITED_STATE.getBillStateCode());
            //变更版本号
            saveEntity.setChangeVersion(monthPlan.getChangeVersion() + 1);
            saveEntity.setCommitUserName(userContext.getUserName());
            //设置变更人
            saveEntity.setChangeUserName(userContext.getUserName());

//            saveEntity.setPlanCode(monthPlan.getPlanCode());
            saveEntity.setProjectName(monthPlan.getProjectName());
            saveEntity.setOrgName(monthPlan.getOrgName());
            saveEntity.setOrgId(monthPlan.getOrgId());
            saveEntity.setCreateUserName(userContext.getUserName());

        }
        else {
            saveEntity = service.getById(planVo.getId());
            saveEntity.setProjectId(planVo.getProjectId());
            saveEntity.setProjectName(planVo.getProjectName());
            saveEntity.setRemark(planVo.getRemark());
//            saveEntity.setPlanCode(planVo.getPlanCode());
//            saveEntity.setTotalPlanAmt(planVo.getTotalPlanAmt());
            saveEntity.setModifyUserName(userContext.getUserName());
            saveEntity.setMonthPlanDetailList(BeanMapper.mapList(planVo.getMonthPlanDetailList(), MonthPlanChangeDetailEntity.class));
        }

        //保存前清空主键和父主键，重新生成
        List<MonthPlanChangeDetailEntity> beforeDetails = saveEntity.getMonthPlanDetailList();
        if (CollectionUtils.isNotEmpty(beforeDetails) && null == saveEntity.getId()) {
            for (MonthPlanChangeDetailEntity cdEntity : beforeDetails) {
                cdEntity.setId(null);
            }
        }


//        MonthPlanChangeEntity entity = BeanMapper.map(planVo, MonthPlanChangeEntity.class);
        if(planVo.getId() == null || planVo.getId() == 0){
            BillCodeParam billCodeParam = BillCodeParam.build(BILL_CODE,InvocationInfoProxy.getTenantid(),planVo);
            CommonResponse<String> billCode = billCodeApi.generateBillCode(billCodeParam);
            if(billCode.isSuccess()) {
                saveEntity.setPlanCode(billCode.getData());
            }else{
                throw new BusinessException("网络异常， 编码生成失败， 请稍后再试");
            }
        }

        service.saveOrUpdate(saveEntity, false);
        MonthPlanEntity planEntity = monthPlanService.selectById(saveEntity.getSourcePlanId());
        if (1 != planEntity.getChangeState()) {
            planEntity.setChangeState(1);
            planEntity.setCurChangingPlanId(saveEntity.getId());
            monthPlanService.saveOrUpdate(planEntity, false);
        }

        MonthPlanChangeVO vo = BeanMapper.map(saveEntity, MonthPlanChangeVO.class);
        return vo;
    }


    @Override
    public MonthPlanChangeEntity getUnFinishedChange(Long sourcePlanId) {
        QueryWrapper<MonthPlanChangeEntity> query = new QueryWrapper<>();
        query.eq("source_plan_id", sourcePlanId);
        List<Integer> billStates = new ArrayList<>();
        billStates.add(BillStateEnum.UNCOMMITED_STATE.getBillStateCode());
        billStates.add(BillStateEnum.APPROVING_HAS_STATE.getBillStateCode());
        billStates.add(BillStateEnum.UNAPPROVED.getBillStateCode());
        billStates.add(BillStateEnum.APPROVING_UNEXAM_STATE.getBillStateCode());
        query.in("bill_state", billStates);
        return planChangeMapper.selectOne(query);
    }

    @Override
    @Transactional(rollbackFor = Exception.class)
    public void deleteChangePlan(List<Long> changeIds) {
        List<MonthPlanChangeEntity> changeList = planChangeMapper.selectBatchIds(changeIds);
        List<Long> planIds = changeList.stream().map(MonthPlanChangeEntity::getSourcePlanId).collect(Collectors.toList());

        QueryWrapper<MonthPlanEntity> planQuery = new QueryWrapper<>();
        planQuery.in("id", planIds);
        List<MonthPlanEntity> planList = monthPlanService.list(planQuery);

        //查询已有的变更历史记录
        QueryWrapper<MonthPlanChangeHisEntity> query = new QueryWrapper<>();
        query.select("ifnull(count(1), 0) as hisNum, source_plan_id as planId");
        query.in("source_plan_id", planIds);
        query.eq("dr", BaseVO.DR_UNDELETE);
        query.groupBy("source_plan_id");

        List<Map<String, Object>> queryResult = monthPlanChangeHisMapper.selectMaps(query);
        Map<Long, Integer> hisCountNumMap = new HashMap<>();
        queryResult.stream().forEach(m -> {
            hisCountNumMap.put(Long.valueOf(m.get("planId").toString()), Integer.valueOf(m.get("hisNum").toString()));
        });

        for (MonthPlanEntity plan : planList) {
            plan.setChangeState((null != hisCountNumMap.get(plan.getId()) && hisCountNumMap.get(plan.getId()) > 0) ? 2 : 0); //未变更
            plan.setCurChangingPlanId(null);
        }

        monthPlanService.saveOrUpdateBatch(planList, planList.size());

        super.removeByIds(changeList.stream().map(MonthPlanChangeEntity::getId).collect(Collectors.toList()), false);
    }


    @Override
    public List<MonthPlanChangeHisVO> queryDetailRecord(Long id) {
        LambdaQueryWrapper<MonthPlanChangeEntity> lambda = Wrappers.<MonthPlanChangeEntity>lambdaQuery();
        lambda.eq(MonthPlanChangeEntity::getSourcePlanId, id);
        lambda.in(MonthPlanChangeEntity::getBillState, BillStateEnum.PASSED_STATE.getBillStateCode(), BillStateEnum.COMMITED_STATE.getBillStateCode());
        List<MonthPlanChangeEntity> entities = super.list(lambda);
        List<MonthPlanChangeHisVO> recordVOList = BeanMapper.mapList(entities, MonthPlanChangeHisVO.class);
        recordVOList.forEach(recordVO -> {
                    if (recordVO.getChangeVersion() < 10) {
                        recordVO.setHistoryCode(recordVO.getPlanCode() + "-0" + recordVO.getChangeVersion());
                    }else {
                        recordVO.setHistoryCode(recordVO.getPlanCode() + "-" + recordVO.getChangeVersion());
                    }
                    recordVO.setChangeCode(recordVO.getPlanCode());
                }
        );
        return recordVOList;
    }

    @Override
    public ParamsCheckVO checkParams(MonthPlanChangeVO vo, ParamsCheckVO paramsCheckVO2) {

        List<ParamsCheckVO> paramsCheckVOS = new ArrayList<>();
        ParamsCheckVO paramsCheckVO = new ParamsCheckVO();
        paramsCheckVO.setWarnType("none");

        paramsCheckVOS.addAll(masterCtrlNum(vo));

        /*预警参数添加域*/
        Map<String, List<ParamsCheckDsVO>> map = new HashMap<>();
        String[] paramsArray = {"alert", "warn", "none"};
        if (CollectionUtils.isNotEmpty(paramsCheckVOS)) {
            for (ParamsCheckVO checkVO : paramsCheckVOS) {
                String warnType = checkVO.getWarnType();
                if (map.containsKey(warnType)) {
                    List<ParamsCheckDsVO> checkDsVOS = map.get(warnType);
                    checkDsVOS.addAll(checkVO.getDataSource());
                    map.put(warnType, checkDsVOS);
                } else {
                    map.put(warnType, checkVO.getDataSource());
                }
            }
        }
        for (String s : paramsArray) {
            if (map.containsKey(s)) {
                paramsCheckVO.setWarnType(s);
                paramsCheckVO.setDataSource(map.get(s));
                if (CollectionUtils.isEmpty(paramsCheckVO.getDataSource())) {
                    paramsCheckVO.setWarnType("none");
                } else {
                    return paramsCheckVO;
                }
            }
        }
        return paramsCheckVO;
    }

    private List<ParamsCheckVO> masterCtrlNum(MonthPlanChangeVO masterPlanVO) {
        // 三种控制方式：不控制，提醒，无法保存 (默认为提醒)
        String[] paramsArray = {"none", "warn", "alert"};
        List<ParamsCheckVO> paramsCheckVOList = new ArrayList<>();
        LambdaQueryWrapper<MasterPlanEntity> queryWrapper = Wrappers.lambdaQuery();
        queryWrapper.eq(MasterPlanEntity::getProjectId, masterPlanVO.getProjectId());
        queryWrapper.in(MasterPlanEntity::getBillState, BillStateEnum.PASSED_STATE.getBillStateCode(), BillStateEnum.COMMITED_STATE.getBillStateCode());
        queryWrapper.last("limit 1");
        MasterPlanEntity masterPlanEntity = masterPlanService.getOne(queryWrapper, false);
        if(null != masterPlanEntity){
            MasterPlanEntity planEntity = masterPlanService.selectById(masterPlanEntity.getId());
            Map<Long, MasterPlanDetailEntity> map = planEntity.getMasterPlanDetailList().stream().collect(Collectors.toMap(MasterPlanDetailEntity::getMaterialId, Function.identity(), (k1, k2) -> k1));
            CommonResponse<List<BillParamVO>> billParamByCode = paramConfigApi.getBillParamByCodeAndOrgId(MASTER_CHECK_CODE, masterPlanVO.getParentOrgId());
            if (billParamByCode.isSuccess() && null != billParamByCode.getData()) {
                List<BillParamVO> data = billParamByCode.getData();
                logger.info("清单量大于总控计划剩余量控制：" + JSONObject.toJSONString(data));
                if (CollectionUtils.isNotEmpty(data)) {
                    for (MonthPlanChangeDetailVO detailVO : masterPlanVO.getMonthPlanDetailList()) {
                        BigDecimal planTotalNum = map.containsKey(detailVO.getMaterialId()) ? map.get(detailVO.getMaterialId()).getPlanTotalNum() : BigDecimal.ZERO;
                        BigDecimal planMonthNum = map.containsKey(detailVO.getMaterialId()) ? map.get(detailVO.getMaterialId()).getPlanMonthNum() : BigDecimal.ZERO;
                        BigDecimal bigDecimal = ComputeUtil.safeSub(planMonthNum, detailVO.getPlanMonthOriginalNum());
                        for (BillParamVO datum : data) {
                            ParamsCheckVO paramsCheckVO = new ParamsCheckVO();
                            List<ParamsCheckDsVO> checkDsVOS = new ArrayList<>();
                            BigDecimal roleValue = datum.getRoleValue();//参数值
                            paramsCheckVO.setWarnType(paramsArray[datum.getControlType()]);
                            BigDecimal compareNum = ComputeUtil.safeSub(ComputeUtil.safeMultiply(planTotalNum, ComputeUtil.safeDiv(roleValue, BigDecimal.valueOf(100))),bigDecimal);
                            if (ComputeUtil.isGreaterThan(detailVO.getPlanMonthNum(), compareNum)) {
                                ParamsCheckDsVO paramsCheckDsVO = new ParamsCheckDsVO();
                                paramsCheckDsVO.setOrgName(datum.getOrgName());
                                paramsCheckDsVO.setWarnItem("清单量超过总控计划剩余量");
                                paramsCheckDsVO.setWarnName("清单量大于总控计划剩余量");
                                StringBuffer stringBuffer = new StringBuffer();
                                stringBuffer.append("清单编码[").append(detailVO.getMaterialCode()).append("]的月计划量:").append(detailVO.getPlanMonthNum().setScale(3, BigDecimal.ROUND_HALF_UP))
                                        .append("，总控计划剩余量:").append(compareNum.setScale(3, BigDecimal.ROUND_HALF_UP))
                                        .append("。超出量：").append(ComputeUtil.safeSub(detailVO.getPlanMonthNum(), compareNum).setScale(3, BigDecimal.ROUND_HALF_UP));
                                paramsCheckDsVO.setContent(stringBuffer.toString());
                                checkDsVOS.add(paramsCheckDsVO);
                            }
                            paramsCheckVO.setDataSource(checkDsVOS);
                            paramsCheckVOList.add(paramsCheckVO);
                        }
                    }
                }

            } else {
                logger.info(billParamByCode.getMsg());
                throw new BusinessException("获取控制参数失败");
            }
        }
        return paramsCheckVOList;
    }

}
