package com.ejianc.wzxt.supplier.controller;

import java.io.Serializable;

import com.ejianc.foundation.orgcenter.vo.OrgVO;
import com.ejianc.foundation.support.vo.BillCodeParam;
import com.ejianc.foundation.support.api.IBillCodeApi;
import com.ejianc.foundation.support.api.IBillTypeApi;
import com.ejianc.framework.core.exception.BusinessException;
import com.ejianc.framework.core.kit.time.DateFormatUtil;
import com.ejianc.framework.core.util.ExcelExport;
import com.ejianc.wzxt.supplier.bean.EvalYearScoreEntity;
import com.ejianc.wzxt.supplier.service.IEvalYearScoreService;
import com.ejianc.wzxt.supplier.vo.EvalYearScoreVO;
import org.apache.commons.lang3.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

import java.text.DateFormat;
import java.text.SimpleDateFormat;
import java.util.*;
import java.util.stream.Collectors;
import com.alibaba.fastjson.JSONObject;
import org.springframework.stereotype.Controller;
import org.springframework.web.bind.annotation.*;
import javax.servlet.http.HttpServletResponse;

import com.ejianc.foundation.orgcenter.api.IOrgApi;
import com.ejianc.framework.core.response.CommonResponse;
import org.springframework.beans.factory.annotation.Autowired;
import com.ejianc.framework.core.context.InvocationInfoProxy;
import com.ejianc.framework.core.kit.mapper.BeanMapper;
import com.ejianc.framework.core.kit.collection.ListUtil;

import com.baomidou.mybatisplus.core.metadata.IPage;
import com.baomidou.mybatisplus.extension.plugins.pagination.Page;
import com.ejianc.framework.core.response.Parameter;
import com.ejianc.framework.core.response.QueryParam;

import com.ejianc.wzxt.supplier.bean.EvalYearEntity;
import com.ejianc.wzxt.supplier.service.IEvalYearService;
import com.ejianc.wzxt.supplier.vo.EvalYearVO;

/**
 * 供应商资质评价
 *
 * @author generator
 *
 */
@Controller
@RequestMapping("evalYear")
public class EvalYearController implements Serializable {
	private static final long serialVersionUID = 1L;

    private Logger logger = LoggerFactory.getLogger(this.getClass());

    @Autowired
    private IBillTypeApi billTypeApi;
    @Autowired
    private IBillCodeApi billCodeApi;
    @Autowired
    private IOrgApi iOrgApi;

    private static final String BILL_CODE = "zjkj-wzxt-supplier-year-eval001";//此处需要根据实际修改
    private static final DateFormat sdf = new SimpleDateFormat("yyyy");

    @Autowired
    private IEvalYearService service;
    @Autowired
    private IEvalYearScoreService scoreService;

    /**
     * @Description saveOrUpdate 新增或者修改
     */
    @RequestMapping(value = "/saveOrUpdate", method = RequestMethod.POST)
    @ResponseBody
    public CommonResponse<EvalYearVO> saveOrUpdate(@RequestBody EvalYearVO saveOrUpdateVO) {
        QueryParam queryParam = new QueryParam();
        queryParam.getParams().put("id", new Parameter(QueryParam.NE, saveOrUpdateVO.getId()));
        queryParam.getParams().put("period", new Parameter(QueryParam.EQ, saveOrUpdateVO.getPeriod()));
        queryParam.getParams().put("supplierId", new Parameter(QueryParam.EQ, saveOrUpdateVO.getSupplierId()));
        List<EvalYearEntity> list = service.queryList(queryParam,false);
        if(ListUtil.isNotEmpty(list)){
            return CommonResponse.error("供应商【"+saveOrUpdateVO.getSupplierName() +"】已存在【"+sdf.format(list.get(0).getPeriod())+"年】的资质评价记录，单据编码是【"+list.get(0).getCode()+"】！");
        }
    	EvalYearEntity entity = BeanMapper.map(saveOrUpdateVO, EvalYearEntity.class);
    	if(entity.getId() == null || entity.getId() == 0){
            BillCodeParam billCodeParam = BillCodeParam.build(BILL_CODE,InvocationInfoProxy.getTenantid(),saveOrUpdateVO);
            CommonResponse<String> billCode = billCodeApi.generateBillCode(billCodeParam);
            if(billCode.isSuccess()) {
                entity.setCode(billCode.getData());//此处需要根据实际修改 删除本行或者下一行
            }else{
                throw new BusinessException("网络异常， 编码生成失败， 请稍后再试");
            }
        }
    	service.saveOrUpdate(entity, false);
    	EvalYearVO vo = BeanMapper.map(entity, EvalYearVO.class);
        queryParam = new QueryParam();
        queryParam.getParams().put("pid", new Parameter(QueryParam.EQ, entity.getId()));
        queryParam.getOrderMap().put("rowNum",QueryParam.ASC);
        List<EvalYearScoreEntity> evalYearScoreList = scoreService.queryList(queryParam,false);
        vo.setEvalYearScoreList(BeanMapper.mapList(evalYearScoreList, EvalYearScoreVO.class));
    	return CommonResponse.success("保存或修改单据成功！",vo);
    }

    /**
     * @Description queryDetail 查询详情
     * @param id
     */
    @RequestMapping(value = "/queryDetail", method = RequestMethod.GET)
    @ResponseBody
    public CommonResponse<EvalYearVO> queryDetail(Long id) {
    	EvalYearEntity entity = service.selectById(id);
    	EvalYearVO vo = BeanMapper.map(entity, EvalYearVO.class);
        QueryParam queryParam = new QueryParam();
        queryParam.getParams().put("pid", new Parameter(QueryParam.EQ, entity.getId()));
        queryParam.getOrderMap().put("rowNum",QueryParam.ASC);
        List<EvalYearScoreEntity> evalYearScoreList = scoreService.queryList(queryParam,false);
        vo.setEvalYearScoreList(BeanMapper.mapList(evalYearScoreList, EvalYearScoreVO.class));
        return CommonResponse.success("查询详情数据成功！",vo);
    }

    /**
     * @Description delete 批量删除单据
     * @Param [ids]
     */
    @RequestMapping(value = "/delete", method = RequestMethod.POST)
    @ResponseBody
    public CommonResponse<String> delete(@RequestBody List<EvalYearVO> vos) {
        if(ListUtil.isNotEmpty(vos)){
            for (EvalYearVO vo : vos) {
                // 参数是单据类型编码字符串 根据需求是否打开下面代码
                /* CommonResponse<String> resp = billTypeApi.checkQuote("billTypeCode", vo.getId());
                if(!resp.isSuccess()){
                    return CommonResponse.error("删除失败！"+resp.getMsg());
                }*/
            }
        }
        service.removeByIds(vos.stream().map(EvalYearVO::getId).collect(Collectors.toList()),true);
        return CommonResponse.success("删除成功！");
    }

    /**
     * @Description queryList 查询列表
     * @param param
     * @Return com.ejianc.framework.core.response.CommonResponse<java.lang.String>
     */
    @RequestMapping(value = "/queryList", method = RequestMethod.POST)
    @ResponseBody
    public CommonResponse<IPage<EvalYearVO>> queryList(@RequestBody QueryParam param) {

        /** 模糊搜索配置字段示例 */
        List<String> fuzzyFields = param.getFuzzyFields();
        fuzzyFields.add("supplierName");
        /** 租户隔离 */
        param.getParams().put("tenantId", new Parameter(QueryParam.EQ, InvocationInfoProxy.getTenantid()));

        IPage<EvalYearEntity> page = service.queryPage(param,false);
        IPage<EvalYearVO> pageData = new Page<>(page.getCurrent(), page.getSize(), page.getTotal());
  		pageData.setRecords(BeanMapper.mapList(page.getRecords(), EvalYearVO.class));

        return CommonResponse.success("查询列表数据成功！",pageData);
    }

    /**
     * 获取RPC数据
     * resp 返回值
     * isMustSuc 是否必须成功
     * errMsg 失败提示
     */
    private Object getRespData(CommonResponse<?> resp, boolean isMustSuc, String errMsg) {
        if(isMustSuc && !resp.isSuccess()) {
            throw new BusinessException(StringUtils.isNoneBlank(errMsg) ? errMsg : "调用Rpc服务失败");
        }
        return resp.getData();
    }


    /**
     * @Description 导出
     * @param param
     * @Return void
     */
    @RequestMapping(value = "/excelExport", method = RequestMethod.POST)
    @ResponseBody
    public void excelExport(@RequestBody QueryParam param, HttpServletResponse response) {
        /** 模糊搜索配置字段示例 */
        List<String> fuzzyFields = param.getFuzzyFields();
        param.getParams().put("tenant_id",new Parameter(QueryParam.EQ,InvocationInfoProxy.getTenantid()));
        param.setPageIndex(1);
        fuzzyFields.add("supplierName");
        param.setPageSize(-1);
        List<EvalYearEntity> list = service.queryList(param);
        //todo:字段翻译等等
        Map<String, Object> beans = new HashMap<>();
        SimpleDateFormat timeFormat = new SimpleDateFormat(DateFormatUtil.PATTERN_DEFAULT_ON_SECOND);
        beans.put("dateFormat",timeFormat);
        SimpleDateFormat yearFormat = new SimpleDateFormat("yyyy");
        beans.put("yearFormat",yearFormat);
        beans.put("records", list);
        ExcelExport.getInstance().exportWithTrans("EvalYear-export.xlsx", beans, response);
    }

    /**
     * @Description 参照
     * @Return void
     */
    @RequestMapping(value = "/refEvalYearData", method = RequestMethod.GET)
    @ResponseBody
    public CommonResponse<IPage<EvalYearVO>> refEvalYearData(@RequestParam Integer pageNumber, @RequestParam Integer pageSize,
                                                                        String condition,
                                                                        String searchObject,
                                                                        String searchText) {
        QueryParam param = new QueryParam();
        param.setPageSize(pageSize);
        param.setPageIndex(pageNumber);
        param.setSearchText(searchText);
        param.setSearchObject(searchObject);
        /** 租户隔离 */
        param.getParams().put("tenantId", new Parameter(QueryParam.EQ, InvocationInfoProxy.getTenantid()));
        if(StringUtils.isNotEmpty(condition)){
            /** 处理condition */
            JSONObject _con = JSONObject.parseObject(condition);
        }

        IPage<EvalYearEntity> page = service.queryPage(param,false);
        IPage<EvalYearVO> pageData = new Page<>(page.getCurrent(), page.getSize(), page.getTotal());
        pageData.setRecords(BeanMapper.mapList(page.getRecords(), EvalYearVO.class));

        return CommonResponse.success("查询参照数据成功！",pageData);
     }
}
