package com.ejianc.wzxt.check.controller;

import com.alibaba.fastjson.JSONObject;
import com.baomidou.mybatisplus.core.metadata.IPage;
import com.baomidou.mybatisplus.extension.plugins.pagination.Page;
import com.ejianc.foundation.orgcenter.api.IOrgApi;
import com.ejianc.foundation.orgcenter.vo.OrgVO;
import com.ejianc.foundation.share.api.IProSupplierApi;
import com.ejianc.foundation.share.api.IShareCooperateApi;
import com.ejianc.foundation.share.vo.CooperateVO;
import com.ejianc.foundation.support.api.IBillCodeApi;
import com.ejianc.foundation.support.api.IBillTypeApi;
import com.ejianc.foundation.support.api.IParamConfigApi;
import com.ejianc.foundation.support.vo.BillParamVO;
import com.ejianc.foundation.support.vo.ParamRegisterSetVO;
import com.ejianc.foundation.support.vo.ParamsCheckVO;
import com.ejianc.framework.auth.session.SessionManager;
import com.ejianc.framework.core.context.InvocationInfoProxy;
import com.ejianc.framework.core.exception.BusinessException;
import com.ejianc.framework.core.kit.mapper.BeanMapper;
import com.ejianc.framework.core.response.BillStateEnum;
import com.ejianc.framework.core.response.CommonResponse;
import com.ejianc.framework.core.response.Parameter;
import com.ejianc.framework.core.response.QueryParam;
import com.ejianc.framework.core.util.ExcelExport;
import com.ejianc.framework.skeleton.billState.service.ICommonBusinessService;
import com.ejianc.wzxt.check.bean.CheckEntity;
import com.ejianc.wzxt.check.service.ICheckService;
import com.ejianc.wzxt.check.service.impl.CheckBpmServiceImpl;
import com.ejianc.wzxt.check.vo.CheckVO;
import com.ejianc.wzxt.check.vo.SendMsgVO;
import com.ejianc.wzxt.check.vo.SupplierPushCheckDetailVO;
import com.ejianc.wzxt.check.vo.SupplierPushCheckVO;
import com.ejianc.wzxt.enums.BillPushStatusEnum;
import com.ejianc.wzxt.enums.CheckTypeEnum;
import com.ejianc.wzxt.op.vo.OpVO;
import io.swagger.annotations.ApiOperation;
import io.swagger.annotations.ApiParam;
import org.apache.commons.collections.CollectionUtils;
import org.apache.commons.lang3.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Controller;
import org.springframework.web.bind.annotation.*;

import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;

/**
 * 消耗材-验收主表
 *
 * @author generator
 */
@Controller
@RequestMapping("check")
public class CheckController implements Serializable {
    private static final long serialVersionUID = 1L;
    @Autowired
    private IShareCooperateApi shareCooperateApi;
    private Logger logger = LoggerFactory.getLogger(this.getClass());

    @Autowired
    private IBillTypeApi billTypeApi;
    @Autowired
    private IBillCodeApi billCodeApi;
    @Autowired
    private IOrgApi iOrgApi;

    private static final String BILL_CODE = "ZJKJ-CHECK-CODE";//此处需要根据实际修改
    private static final String BILL_TYPE = "EJCBT202407000006";//此处需要根据实际修改
    /**
     * 单据分享移动端前端路由地址
     */
    private final String mobileBillShareFrontUrl = "/zjkj-supbusiness-mobile/#/check/card";
    @Autowired
    private ICheckService service;
    @Autowired
    private CheckBpmServiceImpl checkBpmService;
    @Autowired
    private IProSupplierApi proSupplierApi;
    private static final String PUSH_SAVE_URL = "/zjkj-supbusiness-web/openapi/check/saveCheck";

    @Autowired
    ICommonBusinessService check;


    @ApiOperation("新增或者修改")
    @RequestMapping(value = "/saveOrUpdate", method = RequestMethod.POST)
    @ResponseBody
    public CommonResponse<CheckVO> saveOrUpdate(@ApiParam(name = "saveOrUpdateVO", required = true) @RequestBody CheckVO saveOrUpdateVO) {
        CheckVO vo = service.saveOrUpdates(saveOrUpdateVO);
        return CommonResponse.success("保存或修改单据成功！", vo);
    }

    @ApiOperation("查询详情")
    @RequestMapping(value = "/queryDetail", method = RequestMethod.GET)
    @ResponseBody
    public CommonResponse<CheckVO> queryDetail(@RequestParam Long id) {
        CheckEntity entity = service.selectById(id);
        CheckVO vo = BeanMapper.map(entity, CheckVO.class);
        return CommonResponse.success("查询详情数据成功！", vo);
    }

    @ApiOperation("获取协同链接")
    @RequestMapping(value = "/getBillShareLink", method = RequestMethod.GET)
    @ResponseBody
    public CommonResponse<JSONObject> getBillShareLink(@RequestParam Long id) {
        CheckEntity entity = service.selectById(id);
        //校验供应商
        CommonResponse<Boolean> supplierResp = proSupplierApi.whetherSupplierCoo(entity.getSupplierId());
        if (!supplierResp.isSuccess()) {
            logger.error("根据供应商主键-{}查询失败，{}", entity.getSupplierId(), supplierResp.getMsg());
            return CommonResponse.error("获取供应商信息失败！");
        }
        Boolean flag = supplierResp.getData();
        if (!flag) {
            return CommonResponse.error("该供应商未开通协同权限，无法协同验收。 请先到供应商库—生成协同账号再进行订单操作。");
        }

        // 没有推送成功，则需要重新推送数据
        if (BillPushStatusEnum.未成功推送.getStatus().equals(entity.getBillPushFlag())) {
            //查询该单据是否支持协同分享，则向供方协同服务推送该单据
            CommonResponse<CooperateVO> cooperateResp = shareCooperateApi.queryCooperateBybillTypeCode(BILL_TYPE);
            if (!cooperateResp.isSuccess()) {
                logger.error("根据单据类型-{}查询其协同配置信息失败, 不进行单据推送操作，{}", BILL_TYPE, cooperateResp.getMsg());
                return CommonResponse.error("单据推送供方失败，生成分享连接失败！");
            } else {
                //未曾成功推送单据，则先向供方推送单据
                //推送供方处理
                SupplierPushCheckVO supplierPushCheckVO = BeanMapper.map(entity, SupplierPushCheckVO.class);
                supplierPushCheckVO.setSourceId(entity.getId());
                List<SupplierPushCheckDetailVO> checkDetailList = supplierPushCheckVO.getCheckDetailList();
                for (SupplierPushCheckDetailVO supplierPushCheckDetailVO : checkDetailList) {
                    supplierPushCheckDetailVO.setSourceId(entity.getId());
                    supplierPushCheckDetailVO.setSourceDetailId(supplierPushCheckDetailVO.getId());
                    supplierPushCheckDetailVO.setId(null);
                }
                //设置单据当前系统信息
                CommonResponse<String> ejcCloudSystemCode = proSupplierApi.getEjcCloudSystemCode();
                if (!ejcCloudSystemCode.isSuccess()) {
                    return CommonResponse.error("获取当前系统编码失败" + ejcCloudSystemCode.getMsg());
                }
                //设置当前系统ID
                supplierPushCheckVO.setSystemId(ejcCloudSystemCode.getData());
                String dataInfo = JSONObject.toJSONString(supplierPushCheckVO);
                boolean pushResult = service
                        .pushBillToSupCenter(dataInfo, entity.getSupplierId(), entity.getId(), BILL_TYPE, cooperateResp
                                .getData(), PUSH_SAVE_URL);
                if (!pushResult) {
                    logger.error("单据-{}推送给供应商supplierId-{}失败！", id, entity.getSupplierId());
                    return CommonResponse.error("单据推送供方失败，生成分享连接失败！");
                } else {
                    entity.setBillPushFlag(BillPushStatusEnum.推送成功.getStatus());
                    service.saveOrUpdate(entity, false);
                }
            }
        }
        return shareCooperateApi
                .getShareLink(id, BILL_TYPE, entity.getSupplierId().toString(), mobileBillShareFrontUrl, null);
    }

    /**
     * 供方签字确认信息回写
     *
     * @param request
     * @return
     */
    @PostMapping(value = "/supSignSync")
    @ResponseBody
    public CommonResponse<String> supSignSync(HttpServletRequest request) {
        String msg = service.updateBillSupSignSyncInfo(request);
        if (StringUtils.isNotBlank(msg)) {
            return CommonResponse.error(msg);
        }
        return CommonResponse.success("签字状态回写成功！");
    }

    @ApiOperation("批量删除单据")
    @RequestMapping(value = "/delete", method = RequestMethod.POST)
    @ResponseBody
    public CommonResponse<String> delete(@RequestBody List<CheckVO> vos) {
        service.deletes(vos);
        return CommonResponse.success("删除成功！");
    }


    @ApiOperation("批量删除单据")
    @RequestMapping(value = "/deletssse", method = RequestMethod.GET)
    @ResponseBody
    public CommonResponse<String> deletesss(@RequestParam Long billId) {
        checkBpmService.afterApprovalProcessor(billId, null, "BILL_TYPE");
//        concreteCheckBpmService.afterApprovalProcessor(billId,null,"BT220224000000004");
        return null;
    }
//    @ApiOperation("批量删除单据")
//    @RequestMapping(value = "/deletesss1", method = RequestMethod.GET)
//    @ResponseBody
//    public CommonResponse<String> deletesss1(@RequestParam Long billId) {
////        checkBpmService.afterAbstainingProcessor(billId,null,null);
//        concreteCheckBpmService.afterAbstainingProcessor(billId,null,null);
//        return null;
//    }


    @ApiOperation("查询列表")
    @RequestMapping(value = "/queryList", method = RequestMethod.POST)
    @ResponseBody
    public CommonResponse<IPage<CheckVO>> queryList(@RequestBody QueryParam param) {
        /** 模糊搜索配置字段示例 */
        List<String> fuzzyFields = param.getFuzzyFields();
        fuzzyFields.add("projectName");
        fuzzyFields.add("contractName");
        fuzzyFields.add("checkerName");
        fuzzyFields.add("checkDate");
        fuzzyFields.add("supplierName");
        fuzzyFields.add("billCode");
        fuzzyFields.add("storeName");
        fuzzyFields.add("licensePlate");
        /** 租户隔离 */
        param.getParams().put("tenantId", new Parameter(QueryParam.EQ, InvocationInfoProxy.getTenantid()));


        if (param.getParams().containsKey("hasContract")) {
            //1 有合同 2 无合同
            String hasContract = param.getParams().get("hasContract").getValue().toString();
            if (hasContract.equals("1")) {
                param.getParams().put("contractId1", new Parameter(QueryParam.SQL, "contract_id is not null"));
            }
            if (hasContract.equals("2")) {
                param.getParams().put("contractId1", new Parameter(QueryParam.SQL, "contract_id is  null"));
            }
            param.getParams().remove("hasContract");

        }

        List<OrgVO> orgVOList = null;
        if (!param.getParams().containsKey("orgId")) {//PC端查询
            orgVOList = (List<OrgVO>) getRespData(iOrgApi.findChildrenByParentId(InvocationInfoProxy.getOrgId()), true, "查询失败，获取当前本下组织信息失败。");
            //普通组织 id
            List<Long> commonOrgIds = new ArrayList<>();
            //项目部 id
            List<Long> departmentIds = new ArrayList<>();
            orgVOList.stream().forEach(org -> {
                if (5 == org.getOrgType()) {
                    //项目部
                    departmentIds.add(org.getId());
                } else {
                    //普通组织
                    commonOrgIds.add(org.getId());
                }
            });
            if (CollectionUtils.isNotEmpty(commonOrgIds)) {
                /** 要求主表有orgId字段，保存单据所属组织 */
                param.getParams().put("parentOrgId", new Parameter(QueryParam.IN, commonOrgIds));
            } else if (CollectionUtils.isNotEmpty(departmentIds)) {
                /** 要求主表有projectDepartmentId字段，保存单据所属项目部 */
                param.getParams().put("orgId", new Parameter(QueryParam.IN, departmentIds));
            }
            /** 数据隔离 本下 没有组织orgId的删除上面代码-------------结束！！！ */
        }
        IPage<CheckEntity> page = service.queryPage(param, false);
        IPage<CheckVO> pageData = new Page<>(page.getCurrent(), page.getSize(), page.getTotal());
        pageData.setRecords(BeanMapper.mapList(page.getRecords(), CheckVO.class));

        return CommonResponse.success("查询列表数据成功！", pageData);
    }

    /**
     * 获取RPC数据
     * resp 返回值
     * isMustSuc 是否必须成功
     * errMsg 失败提示
     */
    private Object getRespData(CommonResponse<?> resp, boolean isMustSuc, String errMsg) {
        if (isMustSuc && !resp.isSuccess()) {
            throw new BusinessException(StringUtils.isNoneBlank(errMsg) ? errMsg : "调用Rpc服务失败");
        }
        return resp.getData();
    }


    @ApiOperation("导出")
    @RequestMapping(value = "/excelExport", method = RequestMethod.POST)
    @ResponseBody
    public void excelExport(@RequestBody QueryParam param, HttpServletResponse response) {
        /** 模糊搜索配置字段示例 */
        List<String> fuzzyFields = param.getFuzzyFields();
        fuzzyFields.add("projectName");
        fuzzyFields.add("contractName");
        fuzzyFields.add("checkerName");
        fuzzyFields.add("checkDate");
        fuzzyFields.add("supplierName");
        fuzzyFields.add("billCode");
        fuzzyFields.add("storeName");
        fuzzyFields.add("licensePlate");
        param.getParams().put("tenant_id", new Parameter(QueryParam.EQ, InvocationInfoProxy.getTenantid()));

        List<OrgVO> orgVOList = null;
        if (!param.getParams().containsKey("orgId")) {//PC端查询
            orgVOList = (List<OrgVO>) getRespData(iOrgApi.findChildrenByParentId(InvocationInfoProxy.getOrgId()), true, "查询失败，获取当前本下组织信息失败。");
            //普通组织 id
            List<Long> commonOrgIds = new ArrayList<>();
            //项目部 id
            List<Long> departmentIds = new ArrayList<>();
            orgVOList.stream().forEach(org -> {
                if (5 == org.getOrgType()) {
                    //项目部
                    departmentIds.add(org.getId());
                } else {
                    //普通组织
                    commonOrgIds.add(org.getId());
                }
            });
            if (CollectionUtils.isNotEmpty(commonOrgIds)) {
                /** 要求主表有orgId字段，保存单据所属组织 */
                param.getParams().put("parentOrgId", new Parameter(QueryParam.IN, commonOrgIds));
            } else if (CollectionUtils.isNotEmpty(departmentIds)) {
                /** 要求主表有projectDepartmentId字段，保存单据所属项目部 */
                param.getParams().put("orgId", new Parameter(QueryParam.IN, departmentIds));
            }
            /** 数据隔离 本下 没有组织orgId的删除上面代码-------------结束！！！ */
        }
        param.setPageIndex(1);
        param.setPageSize(-1);

        List<CheckEntity> list = service.queryList(param);
        List<CheckVO> listVo = new ArrayList<>();
        if (CollectionUtils.isNotEmpty(list)) {
            listVo = BeanMapper.mapList(list, CheckVO.class);
            listVo.forEach(vo -> {
                vo.setBillStateName(BillStateEnum.getEnumByStateCode(vo.getBillState()).getDescription());
                //验收来源，0-自制验收,1-发货验收
                vo.setCheckTypeName(CheckTypeEnum.getEnumByStatus(vo.getCheckType()).getName());
                //是否补录，0-否，1-是
                vo.setRecordFlagName( null == vo.getRecordFlag() || vo.getRecordFlag() == 0 ? "否" : "是");
                // 签字状态：0-未签字,1-已签字
                vo.setSignStatusName(null == vo.getSignStatus() || vo.getSignStatus() == 0 ? "未签字" : "已签字");
            });

        }
        //todo:字段翻译等等
        Map<String, Object> beans = new HashMap<>();
        beans.put("records", listVo);
        ExcelExport.getInstance().export("checkExport.xlsx", beans, response);
    }


    @ApiOperation("参照")
    @RequestMapping(value = "/refCheckData", method = RequestMethod.GET)
    @ResponseBody
    public CommonResponse<IPage<CheckVO>> refCheckData(@RequestParam Integer pageNumber, @RequestParam Integer pageSize,
                                                       String condition,
                                                       String searchObject,
                                                       String searchText) {
        QueryParam param = new QueryParam();
        param.setPageSize(pageSize);
        param.setPageIndex(pageNumber);
        param.setSearchText(searchText);
        param.setSearchObject(searchObject);
        /** 租户隔离 */
        param.getParams().put("tenantId", new Parameter(QueryParam.EQ, InvocationInfoProxy.getTenantid()));
        if (StringUtils.isNotEmpty(condition)) {
            /** 处理condition */
            JSONObject _con = JSONObject.parseObject(condition);
        }

        IPage<CheckEntity> page = service.queryPage(param, false);
        IPage<CheckVO> pageData = new Page<>(page.getCurrent(), page.getSize(), page.getTotal());
        pageData.setRecords(BeanMapper.mapList(page.getRecords(), CheckVO.class));

        return CommonResponse.success("查询参照数据成功！", pageData);
    }

    /**
     * 单据管控-
     *
     * @return
     */
    @RequestMapping(value = "/checkParams", method = RequestMethod.POST)
    @ResponseBody
    public CommonResponse<ParamsCheckVO> checkParams(@RequestBody CheckVO checkVO) {
        ParamsCheckVO paramsCheckVO = service.checkParams(checkVO, null);
        return CommonResponse.success("参数校验成功！", paramsCheckVO);
    }

    /**
     * 磅单验收
     *
     * @return
     */
    @RequestMapping(value = "/queryDetailWeigh", method = RequestMethod.POST)
    @ResponseBody
    public CommonResponse<CheckVO> queryDetailWeigh(@RequestBody CheckVO vo) {
        CheckVO checkVO = service.queryDetailWeigh(vo);
        return CommonResponse.success("参数校验成功！", checkVO);
    }


    /**
     * @return
     * @Description 甲供材对账单获取材料验收单参照
     * @Return void
     */
    @RequestMapping(value = "/refCheckToAccountData", method = RequestMethod.GET)
    @ResponseBody
    public CommonResponse<IPage<CheckVO>> refCheckToAccountData(@RequestParam Integer pageNumber, @RequestParam Integer pageSize,
                                                                String condition,
                                                                String searchObject,
                                                                String searchText) {
        QueryParam queryParam = new QueryParam();
        queryParam.setPageSize(pageSize);
        queryParam.setPageIndex(pageNumber);
        queryParam.setSearchText(searchText);
        queryParam.setSearchObject(searchObject);
        queryParam.getParams().put("tenantId", new Parameter(QueryParam.EQ, InvocationInfoProxy.getTenantid()));
        List<String> fuzzyFields = queryParam.getFuzzyFields();
        fuzzyFields.add("salaryBillCode");
        if (null == condition || StringUtils.isBlank(condition)) {
            return CommonResponse.error("查询失败，当前传入condition为空！");
        }
        JSONObject _con = JSONObject.parseObject(condition);

        String projectId = _con.getString("projectId");
        if (StringUtils.isBlank(projectId)) {
            return CommonResponse.error("查询失败，缺少参数项目id-projectId！");
        }
        String attrFlag = _con.getString("attrFlag");

        queryParam.getParams().put("project_id", new Parameter(QueryParam.EQ, projectId));
        if (StringUtils.isNotBlank(attrFlag)) {
            queryParam.getParams().put("attr_flag", new Parameter(QueryParam.EQ, attrFlag));
        }
        queryParam.getParams().put("contractId", new Parameter(QueryParam.EQ, null));
        List<Integer> billStateList = new ArrayList<>();
        billStateList.add(BillStateEnum.COMMITED_STATE.getBillStateCode());
        billStateList.add(BillStateEnum.PASSED_STATE.getBillStateCode());
        queryParam.getParams().put("bill_state", new Parameter(QueryParam.IN, billStateList));

        IPage<CheckEntity> page = service.queryPage(queryParam);
        IPage<CheckVO> pageData = new Page<>(page.getCurrent(), page.getSize(), page.getTotal());
        pageData.setRecords(BeanMapper.mapList(page.getRecords(), CheckVO.class));

        return CommonResponse.success("查询参照数据成功！", pageData);
    }

    /**
     * @Description 生成出门证
     */
    @RequestMapping(value = "/pushOp", method = RequestMethod.GET)
    @ResponseBody
    public CommonResponse<OpVO> pushOp(@RequestParam Long id) {
        return CommonResponse.success("生成出门证成功,请及时去出门证列表查看!", service.pushOp(id));
    }


    /**
     * @Description 发消息
     */
    @RequestMapping(value = "/sendMsg", method = RequestMethod.POST)
    @ResponseBody
    public CommonResponse<String> sendMsg(@RequestBody SendMsgVO sendMsgVO) {
        return service.sendMsg(sendMsgVO);
    }
}
