package com.ejianc.wzxt.delivery.bean;

import com.baomidou.mybatisplus.annotation.TableField;
import com.baomidou.mybatisplus.annotation.TableName;
import com.ejianc.framework.skeleton.template.BaseEntity;
import com.ejianc.framework.skeleton.template.annotation.SubEntity;
import com.fasterxml.jackson.annotation.JsonFormat;

import java.util.ArrayList;
import java.util.Date;
import java.util.List;
/**
 * 消耗材-发货单
 *
 * @author generator
 *
 */
 @TableName("ejc_wzxt_delivery")
public class DeliveryEntity extends BaseEntity {
    private static final long serialVersionUID = 1L;

    @TableField(value="source_id")
    private Long sourceId; // 来源发货单主键
    @TableField(value="order_id")
    private Long orderId; // 订单主键
    @TableField(value="order_bill_code")
    private String orderBillCode; // 订单单据编号
    @TableField(value="bill_code")
    private String billCode; // 单据编号
    @TableField(value="contract_id")
    private Long contractId; // 合同主键
    @TableField(value="contract_name")
    private String contractName; // 合同名称
    @TableField(value="contract_code")
    private String contractCode; // 合同编码
    @TableField(value="project_id")
    private Long projectId; // 项目
    @TableField(value="project_name")
    private String projectName; // 项目名称
    @TableField(value="project_code")
    private String projectCode; // 项目编码
    @TableField(value="supplier_id")
    private Long supplierId; // 供应商主键
    @TableField(value="supplier_name")
    private String supplierName; // 供应商名称
    @TableField(value="employee_id")
    private Long employeeId; // 经办人
    @TableField(value="employee_name")
    private String employeeName; // 经办人名称
    @TableField(value="deliver_name")
    private String deliverName; // 送货人名称
    @TableField(value="deliver_phone")
    private String deliverPhone; // 送货人联系电话
    @JsonFormat(
            shape = JsonFormat.Shape.STRING,
            pattern = "yyyy-MM-dd",
            timezone = "GMT+8"
    )
    @TableField(value="deliver_date")
    private Date deliverDate; // 送货日期
    @JsonFormat(
            shape = JsonFormat.Shape.STRING,
            pattern = "yyyy-MM-dd",
            timezone = "GMT+8"
    )
    @TableField(value="arrive_date")
    private Date arriveDate; // 预计到货日期
    @TableField(value="license_plate")
    private String licensePlate; // 车牌号
    @TableField(value="department_id")
    private Long departmentId; // 经办部门
    @TableField(value="department_name")
    private String departmentName; // 经办部门名称
    @TableField(value="close_flag")
    private Integer closeFlag; // 是否关闭，0-否，1-是
    @TableField(value="check_status")
    private Integer checkStatus; // 验收状态，0-待接收,1-部分接收,2-已验收
    @TableField(value="org_id")
    private Long orgId; // 组织
    @TableField(value="org_name")
    private String orgName; // 组织名称
    @TableField(value="memo")
    private String memo; // 备注
    @TableField(value="material_name")
    private String materialName; // 发货内容
    @TableField(value="construction")
    private String construction; // 使用部位
    @TableField(value="parent_org_name")
    private String parentOrgName; // 父级组织名称
    @TableField(value="parent_org_id")
    private Long parentOrgId; // 父级组织
    @TableField(value="bill_state")
    private Integer billState; // 单据状态（审批必须字段）
    @TableField(value="is_push_third")
    private String isPushThird; // 推送第三方是否成功 sucPushed   unSucPush
    @TableField(value="automatic_weigh")
    private Integer automaticWeigh; // 自动称重设置（0：自动称重，1非自动称重）
    @TableField(value="un_suc_reason")
    private String unSucReason; // 推送第三方失败原因
    @TableField(value="platform_type")
    private String platformType; // 磅点类型
    @TableField(value="platform_code")
    private String platformCode; // 磅点编号
    @TableField(value="delivery_type")
    private Integer deliveryType; // 发货单类型 1-自制，2-供方推送（订单）
    @TableField(exist = false)
    private String checkStatusName; // 验收状态，0-待接收,1-部分接收,2-已验收

    @TableField(exist=false)
    @SubEntity(serviceName="deliveryDetailService",pidName = "deliveryId")//此处有pid="xxx"，默认值pid="pid"
    private List<DeliveryDetailEntity> deliveryDetailList = new ArrayList<>(); // 材料订单子表

    public String getUnSucReason() {
        return unSucReason;
    }

    public void setUnSucReason(String unSucReason) {
        this.unSucReason = unSucReason;
    }

    public Integer getAutomaticWeigh() {
        return automaticWeigh;
    }

    public void setAutomaticWeigh(Integer automaticWeigh) {
        this.automaticWeigh = automaticWeigh;
    }

    public String getIsPushThird() {
        return isPushThird;
    }

    public void setIsPushThird(String isPushThird) {
        this.isPushThird = isPushThird;
    }

    public Long getSourceId() {
        return sourceId;
    }

    public void setSourceId(Long sourceId) {
        this.sourceId = sourceId;
    }
    public Long getOrderId() {
        return orderId;
    }

    public void setOrderId(Long orderId) {
        this.orderId = orderId;
    }
    public String getOrderBillCode() {
        return orderBillCode;
    }

    public void setOrderBillCode(String orderBillCode) {
        this.orderBillCode = orderBillCode;
    }

    public String getBillCode() {
        return billCode;
    }

    public void setBillCode(String billCode) {
        this.billCode = billCode;
    }
    public Long getContractId() {
        return contractId;
    }

    public void setContractId(Long contractId) {
        this.contractId = contractId;
    }
    public String getContractName() {
        return contractName;
    }

    public void setContractName(String contractName) {
        this.contractName = contractName;
    }
    public String getContractCode() {
        return contractCode;
    }

    public void setContractCode(String contractCode) {
        this.contractCode = contractCode;
    }
    public Long getProjectId() {
        return projectId;
    }

    public void setProjectId(Long projectId) {
        this.projectId = projectId;
    }
    public String getProjectName() {
        return projectName;
    }

    public void setProjectName(String projectName) {
        this.projectName = projectName;
    }
    public String getProjectCode() {
        return projectCode;
    }

    public void setProjectCode(String projectCode) {
        this.projectCode = projectCode;
    }
    public Long getSupplierId() {
        return supplierId;
    }

    public void setSupplierId(Long supplierId) {
        this.supplierId = supplierId;
    }
    public String getSupplierName() {
        return supplierName;
    }

    public void setSupplierName(String supplierName) {
        this.supplierName = supplierName;
    }
    public Long getEmployeeId() {
        return employeeId;
    }

    public void setEmployeeId(Long employeeId) {
        this.employeeId = employeeId;
    }
    public String getEmployeeName() {
        return employeeName;
    }

    public void setEmployeeName(String employeeName) {
        this.employeeName = employeeName;
    }
    public String getDeliverName() {
        return deliverName;
    }

    public void setDeliverName(String deliverName) {
        this.deliverName = deliverName;
    }
    public String getDeliverPhone() {
        return deliverPhone;
    }

    public void setDeliverPhone(String deliverPhone) {
        this.deliverPhone = deliverPhone;
    }
    public Date getArriveDate() {
        return arriveDate;
    }

    public void setArriveDate(Date arriveDate) {
        this.arriveDate = arriveDate;
    }
    public String getLicensePlate() {
        return licensePlate;
    }

    public void setLicensePlate(String licensePlate) {
        this.licensePlate = licensePlate;
    }
    public Long getDepartmentId() {
        return departmentId;
    }

    public void setDepartmentId(Long departmentId) {
        this.departmentId = departmentId;
    }
    public String getDepartmentName() {
        return departmentName;
    }

    public void setDepartmentName(String departmentName) {
        this.departmentName = departmentName;
    }
    public Integer getCloseFlag() {
        return closeFlag;
    }

    public void setCloseFlag(Integer closeFlag) {
        this.closeFlag = closeFlag;
    }
    public Integer getCheckStatus() {
        return checkStatus;
    }

    public void setCheckStatus(Integer checkStatus) {
        this.checkStatus = checkStatus;
    }
    public Long getOrgId() {
        return orgId;
    }

    public void setOrgId(Long orgId) {
        this.orgId = orgId;
    }
    public String getOrgName() {
        return orgName;
    }

    public void setOrgName(String orgName) {
        this.orgName = orgName;
    }

    public String getMemo() {
        return memo;
    }

    public void setMemo(String memo) {
        this.memo = memo;
    }
    public String getConstruction() {
        return construction;
    }

    public void setConstruction(String construction) {
        this.construction = construction;
    }
    public String getParentOrgName() {
        return parentOrgName;
    }

    public void setParentOrgName(String parentOrgName) {
        this.parentOrgName = parentOrgName;
    }
    public Long getParentOrgId() {
        return parentOrgId;
    }

    public void setParentOrgId(Long parentOrgId) {
        this.parentOrgId = parentOrgId;
    }
    public Integer getBillState() {
        return billState;
    }

    public void setBillState(Integer billState) {
        this.billState = billState;
    }

    public Date getDeliverDate() {
        return deliverDate;
    }

    public void setDeliverDate(Date deliverDate) {
        this.deliverDate = deliverDate;
    }

    public String getMaterialName() {
        return materialName;
    }

    public void setMaterialName(String materialName) {
        this.materialName = materialName;
    }

    public String getPlatformType() {
        return platformType;
    }

    public void setPlatformType(String platformType) {
        this.platformType = platformType;
    }

    public String getPlatformCode() {
        return platformCode;
    }

    public void setPlatformCode(String platformCode) {
        this.platformCode = platformCode;
    }

    public Integer getDeliveryType() {
        return deliveryType;
    }

    public void setDeliveryType(Integer deliveryType) {
        this.deliveryType = deliveryType;
    }

    public String getCheckStatusName() {
        return checkStatusName;
    }

    public void setCheckStatusName(String checkStatusName) {
        this.checkStatusName = checkStatusName;
    }

    public List<DeliveryDetailEntity> getDeliveryDetailList() {
        return deliveryDetailList;
    }

    public void setDeliveryDetailList(List<DeliveryDetailEntity> deliveryDetailList) {
        this.deliveryDetailList = deliveryDetailList;
    }
}
