package com.ejianc.wzxt.delivery.service.impl;

import com.alibaba.fastjson.JSONObject;
import com.ejianc.business.weigh.weighbill.api.IPushThirdDataApi;
import com.ejianc.business.weigh.weighbill.vo.DeliveryDetailThirdVO;
import com.ejianc.business.weigh.weighbill.vo.DeliveryThirdVO;
import com.ejianc.foundation.support.api.IBillTypeApi;
import com.ejianc.framework.core.kit.mapper.BeanMapper;
import com.ejianc.framework.core.response.CommonResponse;
import com.ejianc.framework.skeleton.billState.service.ICommonBusinessService;
import com.ejianc.wzxt.delivery.bean.DeliveryDetailEntity;
import com.ejianc.wzxt.delivery.bean.DeliveryEntity;
import com.ejianc.wzxt.delivery.service.IDeliveryService;
import org.apache.commons.collections.CollectionUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;

import java.util.List;

@Service("delivery")
public class DeliveryBpmServiceImpl implements ICommonBusinessService {

    @Autowired
    private IBillTypeApi billTypeApi;

	@Autowired
	private IDeliveryService service;
	private final Logger logger = LoggerFactory.getLogger(getClass());
	@Autowired
	private IPushThirdDataApi pushThirdDataApi;



	/**
	 * 提交前回调
	 *
	 * @param billId
	 * @param state
	 * @return
	 */
	@Override
	public CommonResponse<String> beforeSubmitProcessor(Long billId, Integer state, String billTypeCode) {
		//TODO
		return CommonResponse.success();
	};

	/**
	 * 提交完回调
	 *
	 * @param
	 * @return
	 */
	@Override
	public CommonResponse<String> afterSubmitProcessor(Long billId, Integer state, String billTypeCode){
		//TODO
		return CommonResponse.success();
	}

	/**
	 * 有审批流的撤回前回调
	 *
	 * @param billId
	 * @param state
	 * @return
	 */
	@Override
	public CommonResponse<String> beforeHasBpmBack(Long billId, Integer state, String billTypeCode) {

		return CommonResponse.success();
	};

	/**
	 * 有审批流的撤回后回调
	 *
	 * @param
	 * @return
	 */
	@Override
	public CommonResponse<String> afterHasBpmBack(Long billId, Integer state, String billTypeCode){
		return CommonResponse.success();
	};

	/**
	 * 审批节点审批中时节点审批前回调
	 *
	 * @param billId
	 * @param state
	 * @return
	 */
	@Override
	public CommonResponse<String> beforeInApprovalBack(Long billId, Integer state, String billTypeCode, String sign) {
		return CommonResponse.success();
	};

	/**
	 * 终审审核前回调
	 *
	 * @param billId
	 * @param state
	 * @return
	 */
	@Override
	public CommonResponse<String> beforeApprovalProcessor(Long billId, Integer state, String billTypeCode) {
		//TODO
		return CommonResponse.success();
	}

	/**
	 * 终审审核完回调
	 *
	 * @param
	 * @return
	 */
	@Override
	public CommonResponse<String> afterApprovalProcessor(Long billId, Integer state, String billTypeCode) {
		//TODO
		DeliveryEntity entity = service.selectById(billId);
		if(null!=entity.getAutomaticWeigh()&&0==entity.getAutomaticWeigh()){
			//智能称重 才推送第三方
			/** 推送订单，运单-------------开始 */
			//1,获取订单经办人 送货地址     获取合同甲方
			DeliveryThirdVO thirdVO = BeanMapper.map(entity, DeliveryThirdVO.class);
			thirdVO.setOrderAddress("/");
			thirdVO.setDeliverType("CL");
			List<DeliveryDetailEntity> detailList = entity.getDeliveryDetailList();
			if(CollectionUtils.isNotEmpty(detailList)){
				thirdVO.setDetailList(BeanMapper.mapList(detailList, DeliveryDetailThirdVO.class));
			}
			logger.info("消耗材推送第三方数据参数----：{}", JSONObject.toJSONString(thirdVO));
			CommonResponse<String>  thirdRes = pushThirdDataApi.pushThirdData(thirdVO);
			if(thirdRes.isSuccess()){
				logger.info("消耗材推送第三方数据----返回信息：{}", JSONObject.toJSONString(thirdRes.getMsg()));
				entity.setIsPushThird("sucPushed");
			}else{
				entity.setUnSucReason(thirdRes.getMsg());
			}
			service.updateById(entity);
		}
		return CommonResponse.success();
	}

	/**
	 * 弃审前事件回调
	 *
	 * @param billId
	 * @param state
	 * @return
	 */
	@Override
	public CommonResponse<String> beforeAbstainingProcessor(Long billId, Integer state, String billTypeCode) {
		//TODO
		return CommonResponse.error("发货单暂时不支持撤回！");
	}

	/**
	 * 弃审后事件回调
	 *
	 * @param billId
	 * @param state
	 * @return
	 */
	@Override
	public CommonResponse<String> afterAbstainingProcessor(Long billId, Integer state, String billTypeCode) {
		//TODO
		// 参数是单据类型编码字符串 根据需求是否打开下面代码
        /**CommonResponse<String> resp = billTypeApi.checkQuote(billTypeCode, billId);
        if(!resp.isSuccess()){
            return CommonResponse.error("无法撤回！"+resp.getMsg());
        }*/
		return CommonResponse.success();
	}

}
