package com.ejianc.wzxt.op.bean;

import java.util.Date;
import java.math.*;
import java.util.List;
import java.util.ArrayList;
import java.io.Serializable;

import com.baomidou.mybatisplus.annotation.TableField;
import com.baomidou.mybatisplus.annotation.TableName;
import com.ejianc.framework.skeleton.template.BaseEntity;
import com.ejianc.framework.skeleton.template.annotation.SubEntity;

import com.ejianc.wzxt.op.bean.OpDetailEntity;
import com.fasterxml.jackson.annotation.JsonFormat;

/**
 * 出门证主表
 *
 * @author generator
 *
 */
 @TableName("ejc_wzxt_op")
public class OpEntity extends BaseEntity {
    private static final long serialVersionUID = 1L;

    @TableField(value="bill_state")
    private Integer billState; // 单据状态（审批必须字段）
    @TableField(value="bill_code")
    private String billCode; // 单据编号
    @TableField(value="org_id")
    private Long orgId; // 组织主键
    @TableField(value="org_name")
    private String orgName; // 组织名称
    @TableField(value="parent_org_id")
    private Long parentOrgId; // 上级组织id
    @TableField(value="parent_org_name")
    private String parentOrgName; // 父级组织名称
    @TableField(value="project_id")
    private Long projectId; // 项目主键
    @TableField(value="project_code")
    private String projectCode; // 项目编码
    @TableField(value="project_name")
    private String projectName; // 项目名称
    @TableField(value="op_status")
    private Integer opStatus; // 出门状态1-生效中 2-已过期
    @TableField(value="material_name")
    private String materialName; // 出场物资
    @TableField(value="apply_dept")
    private String applyDept; // 申请单位
    @TableField(value="car_number")
    private String carNumber; // 车牌号
    @TableField(value="out_date")
    private Date outDate; // 出场日期
    @TableField(value="effective_date")
    private Date effectiveDate; // 生效日期
    @TableField(value="share_num")
    private Integer shareNum; // 分享次数
    @TableField(value="last_share_time")
    private Date lastShareTime; // 最后分享时间
    @TableField(value="apply_user")
    private String applyUser; // 申请人
    @TableField(value="tel")
    private String tel; // 电话
    @TableField(value="out_type")
    private Integer outType; // 出场类型1-物资处置、2-验收出场、3-其他
    @TableField(value="source_id")
    private String sourceId; // 来源id
    @TableField(value="source_bill_code")
    private String sourceBillCode; // 来源单据编码
    @TableField(value="link_url_pc")
    private String linkUrlPc; // pc联查url
    @TableField(value="link_url_mobile")
    private String linkUrlMobile; // 移动联查url
    @TableField(value="memo")
    private String memo; // 备注
    @TableField(value="employee_id")
    private Long employeeId; // 经办人
    @TableField(value="employee_name")
    private String employeeName; // 经办人名称
    @TableField(value="department_id")
    private Long departmentId; // 经办部门Id
    @TableField(value="department_name")
    private String departmentName; // 经办部门名称

    @TableField(value="source_type")
    private String sourceType; // 来源类型
    @TableField(value="source_type_name")
    private String sourceTypeName; // 来源类型名称
    @TableField(value="share_url")
    private String shareUrl; //
    @JsonFormat(pattern = "yyyy-MM-dd HH:mm:ss",timezone = "GMT+8")
    @TableField(value="end_time")
    private Date endTime;//过期时间
    @TableField(value="imgs")
    private String imgs; //图片url集合

    @TableField(exist=false)
    @SubEntity(serviceName="opDetailService", pidName = "opId")//此处有pid="xxx"，默认值pid="pid"
    private List<OpDetailEntity> detailList = new ArrayList<>(); // 出门证子表


    public Integer getBillState() {
        return billState;
    }

    public void setBillState(Integer billState) {
        this.billState = billState;
    }
    public String getBillCode() {
        return billCode;
    }

    public void setBillCode(String billCode) {
        this.billCode = billCode;
    }
    public Long getOrgId() {
        return orgId;
    }

    public void setOrgId(Long orgId) {
        this.orgId = orgId;
    }
    public String getOrgName() {
        return orgName;
    }

    public void setOrgName(String orgName) {
        this.orgName = orgName;
    }
    public Long getParentOrgId() {
        return parentOrgId;
    }

    public void setParentOrgId(Long parentOrgId) {
        this.parentOrgId = parentOrgId;
    }
    public Long getProjectId() {
        return projectId;
    }

    public void setProjectId(Long projectId) {
        this.projectId = projectId;
    }
    public String getProjectName() {
        return projectName;
    }

    public void setProjectName(String projectName) {
        this.projectName = projectName;
    }
    public Integer getOpStatus() {
        return opStatus;
    }

    public void setOpStatus(Integer opStatus) {
        this.opStatus = opStatus;
    }
    public String getMaterialName() {
        return materialName;
    }

    public void setMaterialName(String materialName) {
        this.materialName = materialName;
    }
    public String getApplyDept() {
        return applyDept;
    }

    public void setApplyDept(String applyDept) {
        this.applyDept = applyDept;
    }
    public String getCarNumber() {
        return carNumber;
    }

    public void setCarNumber(String carNumber) {
        this.carNumber = carNumber;
    }
    public Date getOutDate() {
        return outDate;
    }

    public void setOutDate(Date outDate) {
        this.outDate = outDate;
    }
    public Date getEffectiveDate() {
        return effectiveDate;
    }

    public void setEffectiveDate(Date effectiveDate) {
        this.effectiveDate = effectiveDate;
    }
    public Integer getShareNum() {
        return shareNum;
    }

    public void setShareNum(Integer shareNum) {
        this.shareNum = shareNum;
    }
    public Date getLastShareTime() {
        return lastShareTime;
    }

    public void setLastShareTime(Date lastShareTime) {
        this.lastShareTime = lastShareTime;
    }
    public String getApplyUser() {
        return applyUser;
    }

    public void setApplyUser(String applyUser) {
        this.applyUser = applyUser;
    }
    public String getTel() {
        return tel;
    }

    public void setTel(String tel) {
        this.tel = tel;
    }
    public Integer getOutType() {
        return outType;
    }

    public void setOutType(Integer outType) {
        this.outType = outType;
    }
    public String getSourceId() {
        return sourceId;
    }

    public void setSourceId(String sourceId) {
        this.sourceId = sourceId;
    }
    public String getSourceBillCode() {
        return sourceBillCode;
    }

    public void setSourceBillCode(String sourceBillCode) {
        this.sourceBillCode = sourceBillCode;
    }
    public String getLinkUrlPc() {
        return linkUrlPc;
    }

    public void setLinkUrlPc(String linkUrlPc) {
        this.linkUrlPc = linkUrlPc;
    }
    public String getLinkUrlMobile() {
        return linkUrlMobile;
    }

    public void setLinkUrlMobile(String linkUrlMobile) {
        this.linkUrlMobile = linkUrlMobile;
    }
    public String getMemo() {
        return memo;
    }

    public void setMemo(String memo) {
        this.memo = memo;
    }



    public Long getEmployeeId() {
        return employeeId;
    }

    public void setEmployeeId(Long employeeId) {
        this.employeeId = employeeId;
    }

    public String getEmployeeName() {
        return employeeName;
    }

    public void setEmployeeName(String employeeName) {
        this.employeeName = employeeName;
    }

    public Long getDepartmentId() {
        return departmentId;
    }

    public void setDepartmentId(Long departmentId) {
        this.departmentId = departmentId;
    }

    public String getDepartmentName() {
        return departmentName;
    }

    public void setDepartmentName(String departmentName) {
        this.departmentName = departmentName;
    }

    public String getSourceType() {
        return sourceType;
    }

    public void setSourceType(String sourceType) {
        this.sourceType = sourceType;
    }

    public String getSourceTypeName() {
        return sourceTypeName;
    }

    public void setSourceTypeName(String sourceTypeName) {
        this.sourceTypeName = sourceTypeName;
    }

    public String getShareUrl() {
        return shareUrl;
    }

    public void setShareUrl(String shareUrl) {
        this.shareUrl = shareUrl;
    }

    public String getParentOrgName() {
        return parentOrgName;
    }

    public void setParentOrgName(String parentOrgName) {
        this.parentOrgName = parentOrgName;
    }

    public String getProjectCode() {
        return projectCode;
    }

    public void setProjectCode(String projectCode) {
        this.projectCode = projectCode;
    }

    public Date getEndTime() {
        return endTime;
    }

    public void setEndTime(Date endTime) {
        this.endTime = endTime;
    }

    public String getImgs() {
        return imgs;
    }

    public void setImgs(String imgs) {
        this.imgs = imgs;
    }

    public List<OpDetailEntity> getDetailList() {
        return detailList;
    }

    public void setDetailList(List<OpDetailEntity> detailList) {
        this.detailList = detailList;
    }
}
