package com.ejianc.wzxt.plan.service.impl;

import com.alibaba.fastjson.JSONObject;
import com.baomidou.mybatisplus.core.conditions.query.LambdaQueryWrapper;
import com.baomidou.mybatisplus.core.conditions.query.QueryWrapper;
import com.baomidou.mybatisplus.core.toolkit.Wrappers;
import com.ejianc.foundation.costmanage.api.CostanalysisApi;
import com.ejianc.foundation.costmanage.vo.ResponsepartdetailApiVO;
import com.ejianc.foundation.orgcenter.api.IOrgApi;
import com.ejianc.foundation.support.api.IBillCodeApi;
import com.ejianc.foundation.support.api.IBillTypeApi;
import com.ejianc.foundation.support.api.IParamConfigApi;
import com.ejianc.foundation.support.vo.BillCodeParam;
import com.ejianc.foundation.support.vo.BillParamVO;
import com.ejianc.foundation.support.vo.ParamsCheckDsVO;
import com.ejianc.foundation.support.vo.ParamsCheckVO;
import com.ejianc.framework.auth.session.SessionManager;
import com.ejianc.framework.auth.session.UserContext;
import com.ejianc.framework.core.context.InvocationInfoProxy;
import com.ejianc.framework.core.exception.BusinessException;
import com.ejianc.framework.core.kit.mapper.BeanMapper;
import com.ejianc.framework.core.response.BillStateEnum;
import com.ejianc.framework.core.response.CommonResponse;
import com.ejianc.framework.core.util.ComputeUtil;
import com.ejianc.framework.skeleton.template.BaseVO;
import com.ejianc.support.idworker.util.IdWorker;
import com.ejianc.wzxt.plan.bean.*;
import com.ejianc.wzxt.plan.mapper.MasterPlanChangeHisMapper;
import com.ejianc.wzxt.plan.service.IMasterPlanService;
import com.ejianc.wzxt.plan.vo.*;
import org.apache.commons.collections.CollectionUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;
import com.ejianc.framework.skeleton.template.BaseServiceImpl;

import com.ejianc.wzxt.plan.mapper.MasterPlanChangeMapper;
import com.ejianc.wzxt.plan.service.IMasterPlanChangeService;
import org.springframework.transaction.annotation.Transactional;

import java.math.BigDecimal;
import java.util.*;
import java.util.function.Function;
import java.util.stream.Collectors;

/**
 * 材料总控计划变更-主表
 * 
 * @author generator
 * 
 */
@Service("masterPlanChangeService")
public class MasterPlanChangeServiceImpl extends BaseServiceImpl<MasterPlanChangeMapper, MasterPlanChangeEntity> implements IMasterPlanChangeService{
    @Autowired
    private IMasterPlanChangeService service;
    @Autowired
    private IBillTypeApi billTypeApi;
    @Autowired
    private IBillCodeApi billCodeApi;
    @Autowired
    private MasterPlanChangeMapper planChangeMapper;
    @Autowired
    private MasterPlanChangeHisMapper masterPlanChangeHisMapper;

    private static final String RESPONSE_CHECK_CODE = "P-p76bQ90296";//数量控制

    private Logger logger = LoggerFactory.getLogger(this.getClass());


    @Autowired
    private CostanalysisApi costanalysisApi;



    @Autowired
    private IMasterPlanService masterPlanService;
    @Autowired
    private IParamConfigApi paramConfigApi;



    @Autowired
    private IOrgApi iOrgApi;

    private static final String BILL_CODE = "ZJKJ_MASTER_PLAN_CHANGE";//此处需要根据实际修改
    @Autowired
    private SessionManager sessionManager;
    @Override
    public MasterPlanChangeVO saveOrUpdate(MasterPlanChangeVO planVo) {
        //校验项目是否存在未完成的变更计划单存在
        MasterPlanChangeEntity planChangeEntity = service.getUnFinishedChange(planVo.getSourcePlanId());

        if (null != planChangeEntity && (null == planVo.getId() || !planChangeEntity.getId().equals(planVo.getId()))) {
            throw new BusinessException("保存失败，该项目存在未完成的材料总计划变更单！");
        }
        MasterPlanEntity masterPlan = masterPlanService.getById(planVo.getSourcePlanId());
        UserContext userContext = sessionManager.getUserContext();
        MasterPlanChangeEntity saveEntity = null;
        if (null == planVo.getId()) {
            saveEntity = BeanMapper.map(planVo, MasterPlanChangeEntity.class);
            saveEntity.setId(IdWorker.getId());
            //设置为自由态
            saveEntity.setBillState(BillStateEnum.UNCOMMITED_STATE.getBillStateCode());
            //变更版本号
            saveEntity.setChangeVersion(masterPlan.getChangeVersion() + 1);
            saveEntity.setCommitUserName(userContext.getUserName());
            //设置变更人
            saveEntity.setChangeUserName(userContext.getUserName());

//            saveEntity.setPlanCode(masterPlan.getPlanCode());
            saveEntity.setProjectName(masterPlan.getProjectName());
            saveEntity.setOrgName(masterPlan.getOrgName());
            saveEntity.setOrgId(masterPlan.getOrgId());
            saveEntity.setCreateUserName(userContext.getUserName());
            saveEntity.setCreateTime(new Date());
        }
        else {
            saveEntity = service.getById(planVo.getId());
            saveEntity.setProjectId(planVo.getProjectId());
            saveEntity.setProjectName(planVo.getProjectName());
            saveEntity.setRemark(planVo.getRemark());
//            saveEntity.setPlanCode(planVo.getPlanCode());
//            saveEntity.setTotalPlanAmt(planVo.getTotalPlanAmt());
            saveEntity.setModifyUserName(userContext.getUserName());
            saveEntity.setMasterPlanDetailList(BeanMapper.mapList(planVo.getMasterPlanDetailList(), MasterPlanDetailChangeEntity.class));
        }

        //保存前清空主键和父主键，重新生成
        List<MasterPlanDetailChangeEntity> beforeDetails = saveEntity.getMasterPlanDetailList();
        if (CollectionUtils.isNotEmpty(beforeDetails) && null == saveEntity.getId()) {
            for (MasterPlanDetailChangeEntity cdEntity : beforeDetails) {
                cdEntity.setId(null);
            }
        }


//        MasterPlanChangeEntity entity = BeanMapper.map(planVo, MasterPlanChangeEntity.class);
        if(planVo.getId() == null || planVo.getId() == 0){
            BillCodeParam billCodeParam = BillCodeParam.build(BILL_CODE,InvocationInfoProxy.getTenantid(),planVo);
            CommonResponse<String> billCode = billCodeApi.generateBillCode(billCodeParam);
            if(billCode.isSuccess()) {
                saveEntity.setPlanCode(billCode.getData());
            }else{
                throw new BusinessException("网络异常， 编码生成失败， 请稍后再试");
            }
        }

        service.saveOrUpdate(saveEntity, false);
        MasterPlanEntity planEntity = masterPlanService.selectById(saveEntity.getSourcePlanId());
        if (1 != planEntity.getChangeState()) {
            planEntity.setChangeState(1);
            planEntity.setCurChangingPlanId(saveEntity.getId());
            masterPlanService.saveOrUpdate(planEntity, false);
        }

        MasterPlanChangeVO vo = BeanMapper.map(saveEntity, MasterPlanChangeVO.class);
        return vo;
    }


    @Override
    public MasterPlanChangeEntity getUnFinishedChange(Long sourcePlanId) {
        QueryWrapper<MasterPlanChangeEntity> query = new QueryWrapper<>();
        query.eq("source_plan_id", sourcePlanId);
        List<Integer> billStates = new ArrayList<>();
        billStates.add(BillStateEnum.UNCOMMITED_STATE.getBillStateCode());
        billStates.add(BillStateEnum.APPROVING_HAS_STATE.getBillStateCode());
        billStates.add(BillStateEnum.UNAPPROVED.getBillStateCode());
        billStates.add(BillStateEnum.APPROVING_UNEXAM_STATE.getBillStateCode());
        query.in("bill_state", billStates);
        return planChangeMapper.selectOne(query);
    }

    @Override
    @Transactional(rollbackFor = Exception.class)
    public void deleteChangePlan(List<Long> changeIds) {
        List<MasterPlanChangeEntity> changeList = planChangeMapper.selectBatchIds(changeIds);
        List<Long> planIds = changeList.stream().map(MasterPlanChangeEntity::getSourcePlanId).collect(Collectors.toList());

        QueryWrapper<MasterPlanEntity> planQuery = new QueryWrapper<>();
        planQuery.in("id", planIds);
        List<MasterPlanEntity> planList = masterPlanService.list(planQuery);

        //查询已有的变更历史记录
        QueryWrapper<MasterPlanChangeHisEntity> query = new QueryWrapper<>();
        query.select("ifnull(count(1), 0) as hisNum, source_plan_id as planId");
        query.in("source_plan_id", planIds);
        query.eq("dr", BaseVO.DR_UNDELETE);
        query.groupBy("source_plan_id");

        List<Map<String, Object>> queryResult = masterPlanChangeHisMapper.selectMaps(query);
        Map<Long, Integer> hisCountNumMap = new HashMap<>();
        queryResult.stream().forEach(m -> {
            hisCountNumMap.put(Long.valueOf(m.get("planId").toString()), Integer.valueOf(m.get("hisNum").toString()));
        });

        for (MasterPlanEntity plan : planList) {
            plan.setChangeState((null != hisCountNumMap.get(plan.getId()) && hisCountNumMap.get(plan.getId()) > 0) ? 2 : 0); //未变更
            plan.setCurChangingPlanId(null);
        }

        masterPlanService.saveOrUpdateBatch(planList, planList.size());

        super.removeByIds(changeList.stream().map(MasterPlanChangeEntity::getId).collect(Collectors.toList()), false);
    }


    @Override
    public List<MasterPlanChangeHisVO> queryDetailRecord(Long id) {
        LambdaQueryWrapper<MasterPlanChangeEntity> lambda = Wrappers.<MasterPlanChangeEntity>lambdaQuery();
        lambda.eq(MasterPlanChangeEntity::getSourcePlanId, id);
        lambda.in(MasterPlanChangeEntity::getBillState, BillStateEnum.PASSED_STATE.getBillStateCode(), BillStateEnum.COMMITED_STATE.getBillStateCode());
        lambda.orderByDesc(MasterPlanChangeEntity::getCreateTime);
        List<MasterPlanChangeEntity> entities = super.list(lambda);
        List<MasterPlanChangeHisVO> recordVOList = BeanMapper.mapList(entities, MasterPlanChangeHisVO.class);
        recordVOList.forEach(recordVO -> {
            if (recordVO.getChangeVersion() < 10) {
                recordVO.setHistoryCode(recordVO.getPlanCode() + "-0" + recordVO.getChangeVersion());
            }else {
                recordVO.setHistoryCode(recordVO.getPlanCode() + "-" + recordVO.getChangeVersion());
            }
            recordVO.setChangeCode(recordVO.getPlanCode());
                }
        );
        return recordVOList;
    }
    private List<ParamsCheckVO> responseCtrlNum(MasterPlanChangeVO masterPlanVO) {
        // 三种控制方式：不控制，提醒，无法保存 (默认为提醒)
        String[] paramsArray = {"none", "warn", "alert"};
        List<ParamsCheckVO> paramsCheckVOList = new ArrayList<>();
        List<MasterPlanDetailChangeVO> masterPlanDetailList = masterPlanVO.getMasterPlanDetailList();
        Map<Long, BigDecimal> numMasterPlanMap = new HashMap<>();
        if (CollectionUtils.isNotEmpty(masterPlanDetailList)){
            numMasterPlanMap = masterPlanDetailList.stream().filter(s -> s.getRowState() == null || !s.getRowState().equals("del")).collect(Collectors.groupingBy(MasterPlanDetailChangeVO::getMaterialCategoryId,
                    Collectors.collectingAndThen(Collectors.toList(), m -> m.stream().map(a -> a.getPlanTotalNum()).reduce(BigDecimal.ZERO, BigDecimal::add))));
        }

        CommonResponse<List<ResponsepartdetailApiVO>> queryResponsibilitycost = costanalysisApi.queryResponseByProjectId(masterPlanVO.getProjectId());
        if (!queryResponsibilitycost.isSuccess()){
            throw new BusinessException("根据项目查询责任成本失败");
        }
        List<ResponsepartdetailApiVO> queryResponsibilitycostData = queryResponsibilitycost.getData();
        Map<Long, ResponsepartdetailApiVO> responsepartdetailApiVOMap = queryResponsibilitycostData.stream().collect(Collectors.toMap(ResponsepartdetailApiVO::getMaterialTypeId, Function.identity(), (k1, k2) -> k1));

        CommonResponse<List<BillParamVO>> billParamByCode = paramConfigApi.getBillParamByCodeAndOrgId(RESPONSE_CHECK_CODE, masterPlanVO.getParentOrgId());
        if (billParamByCode.isSuccess() && null != billParamByCode.getData()) {

            List<BillParamVO> data = billParamByCode.getData();
            logger.info("总控计划量大于责任成本量控制：" + JSONObject.toJSONString(data));
            if (CollectionUtils.isNotEmpty(data)) {
                for (MasterPlanDetailChangeVO detailVO : masterPlanVO.getMasterPlanDetailList()) {

                    BigDecimal responseNum = responsepartdetailApiVOMap.containsKey(detailVO.getMaterialCategoryId()) ? responsepartdetailApiVOMap.get(detailVO.getMaterialCategoryId()).getQuantityOfWorkZ() : BigDecimal.ZERO;
                    BigDecimal masterPlanNum = numMasterPlanMap.containsKey(detailVO.getMaterialCategoryId()) ? numMasterPlanMap.get(detailVO.getMaterialCategoryId()) : BigDecimal.ZERO;
                    for (BillParamVO datum : data) {
                        ParamsCheckVO paramsCheckVO = new ParamsCheckVO();
                        List<ParamsCheckDsVO> checkDsVOS = new ArrayList<>();
                        BigDecimal roleValue = datum.getRoleValue();//参数值
                        paramsCheckVO.setWarnType(paramsArray[datum.getControlType()]);
                        BigDecimal compareNum = ComputeUtil.safeMultiply(responseNum, ComputeUtil.safeDiv(roleValue, BigDecimal.valueOf(100)));
                        if (ComputeUtil.isGreaterThan(masterPlanNum, compareNum)) {
                            ParamsCheckDsVO paramsCheckDsVO = new ParamsCheckDsVO();
                            paramsCheckDsVO.setOrgName(datum.getOrgName());
                            paramsCheckDsVO.setWarnItem("总控计划量大于责任成本量");
                            paramsCheckDsVO.setWarnName("总控计划量大于责任成本量");
                            StringBuffer stringBuffer = new StringBuffer();
//                            当前总计划 清单中【材料名称】【规格型号】的总计划量，已超责任成本量，请调整责任成本后再进行保存。

                            stringBuffer.append("当前总计划变更 清单中【").append(detailVO.getMaterialName()).append("】【").append(detailVO.getSpec()).append("】所属分类的总计划量").append(ComputeUtil.nullToZero(masterPlanNum).setScale(3, BigDecimal.ROUND_HALF_UP))
                                    .append("，责任成本量:").append(ComputeUtil.nullToZero(compareNum).setScale(3, BigDecimal.ROUND_HALF_UP))
                                    .append("。超出量：").append(ComputeUtil.safeSub(masterPlanNum, compareNum).setScale(3, BigDecimal.ROUND_HALF_UP));
                            paramsCheckDsVO.setContent(stringBuffer.toString());
                            checkDsVOS.add(paramsCheckDsVO);
                        }
                        paramsCheckVO.setDataSource(checkDsVOS);
                        paramsCheckVOList.add(paramsCheckVO);
                    }
                }
            }

        } else {
            logger.info(billParamByCode.getMsg());
            throw new BusinessException("获取控制参数失败");
        }
        return paramsCheckVOList;
    }
    @Override
    public ParamsCheckVO checkParams(MasterPlanChangeVO vo, ParamsCheckVO paramsCheckVO2) {


        List<ParamsCheckVO> paramsCheckVOS = new ArrayList<>();
        ParamsCheckVO paramsCheckVO = new ParamsCheckVO();
        paramsCheckVO.setWarnType("none");

        paramsCheckVOS.addAll(responseCtrlNum(vo));

        /*预警参数添加域*/
        Map<String, List<ParamsCheckDsVO>> map = new HashMap<>();
        String[] paramsArray = {"none", "warn", "alert"};
        if (CollectionUtils.isNotEmpty(paramsCheckVOS)) {
            for (ParamsCheckVO checkVO : paramsCheckVOS) {
                String warnType = checkVO.getWarnType();
                if (map.containsKey(warnType)) {
                    List<ParamsCheckDsVO> checkDsVOS = map.get(warnType);
                    checkDsVOS.addAll(checkVO.getDataSource());
                    map.put(warnType, checkDsVOS);
                } else {
                    map.put(warnType, checkVO.getDataSource());
                }
            }
        }
        for (String s : paramsArray) {
            if (map.containsKey(s)) {
                paramsCheckVO.setWarnType(s);
                paramsCheckVO.setDataSource(map.get(s));
                if (CollectionUtils.isEmpty(paramsCheckVO.getDataSource())) {
                    paramsCheckVO.setWarnType("none");
                } else {
                    return paramsCheckVO;
                }
            }
        }
        return paramsCheckVO;
    }


}
