package com.ejianc.wzxt.plan.service.impl;

import com.alibaba.fastjson.JSONObject;
import com.ejianc.foundation.file.api.IAttachmentApi;
import com.ejianc.foundation.file.vo.AttachmentVO;
import com.ejianc.foundation.message.api.IPushMessageApi;
import com.ejianc.foundation.outcontract.api.IOutcontractApi;
import com.ejianc.foundation.share.api.IProSupplierApi;
import com.ejianc.foundation.share.utils.FileUtil;
import com.ejianc.framework.cache.utils.RedisTool;
import com.ejianc.framework.core.exception.BusinessException;
import com.ejianc.framework.core.kit.mapper.BeanMapper;
import com.ejianc.framework.core.response.CommonResponse;
import com.ejianc.framework.skeleton.dataPush.ISystemDataPushService;
import com.ejianc.wzxt.check.bean.CheckEntity;
import com.ejianc.wzxt.order.vo.SupOrderDetailVO;
import com.ejianc.wzxt.order.vo.SupOrderVO;
import com.ejianc.wzxt.plan.vo.SupMaterialPlanDetailVO;
import com.ejianc.wzxt.plan.vo.SupMaterialPlanVO;
import com.ejianc.wzxt.utils.CommonUtils;
import org.apache.commons.collections.CollectionUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.beans.factory.annotation.Value;
import org.springframework.stereotype.Service;
import com.ejianc.framework.skeleton.template.BaseServiceImpl;

import com.ejianc.wzxt.plan.mapper.MaterialPlanMapper;
import com.ejianc.wzxt.plan.bean.MaterialPlanEntity;
import com.ejianc.wzxt.plan.service.IMaterialPlanService;
import org.springframework.web.bind.annotation.RequestMethod;
import org.springframework.web.multipart.MultipartHttpServletRequest;
import redis.clients.jedis.Jedis;
import redis.clients.jedis.JedisPool;

import javax.servlet.http.HttpServletRequest;
import java.io.InputStream;
import java.util.*;

/**
 * 领料计划-主表
 * 
 * @author generator
 * 
 */
@Service("materialPlanService")
public class MaterialPlanServiceImpl extends BaseServiceImpl<MaterialPlanMapper, MaterialPlanEntity> implements IMaterialPlanService{
    @Autowired
    private JedisPool jedisPool;

    @Autowired
    private IAttachmentApi attachmentApi;

    private Logger logger = LoggerFactory.getLogger(this.getClass());


    @Autowired
    private IOutcontractApi outcontractApi;

    @Autowired
    private ISystemDataPushService systemDataPushService;

    @Value("${common.env.base-host}")
    private String baseHost;

    @Value("${refer.base-host:null}")
    private String BASE_HOST_FRONTEND;
    @Autowired
    private IProSupplierApi proSupplierApi;

    private static final String BILL_TYPE = "EJCBT202408000008";//此处需要根据实际修改



    @Autowired
    private IPushMessageApi pushMessageApi;

    private final String OPERATE = "MATERIAL_PLAN_SYNC";

    private final String PUSH_BILL_SERVER_URL = "/zjkj-supbusiness-web/openapi/materialPlan/saveOrUpdate";

    //    private static final String CHECK_NUM_CODE = "P-Is9ntQ0298";


    @Override
    public boolean pushBillToSupCenter(MaterialPlanEntity materialPlanEntity, String billTypeCode) {
        boolean locked = false, syncFlag = false;
        Jedis jedis = jedisPool.getResource();
        String key = billTypeCode + "::" + materialPlanEntity.getId().toString();

        //设置单据当前系统信息
        CommonResponse<String> ejcCloudSystemCode = proSupplierApi.getEjcCloudSystemCode();
        if (!ejcCloudSystemCode.isSuccess()) {
            logger.error("推送领料计划单据-{}失败，获取当前系统编码失败,{}", materialPlanEntity.getId(), ejcCloudSystemCode.getMsg());
            return false;
        }
        //设置当前系统ID
        materialPlanEntity.setSystemId(ejcCloudSystemCode.getData());
        materialPlanEntity.setSourceId(materialPlanEntity.getId());


        try {
            //对单据进行加锁
            locked = RedisTool.tryLock(jedis, key, OPERATE, 600);

            if (!locked) {
                logger.error("单据推送失败，单据锁获取失败！");
                releaseLock(jedis, false, key, OPERATE);
                return false;
            }

            Map<String, String> paramMap = new HashMap<>();
            SupMaterialPlanVO supMaterialPlanVO = BeanMapper.map(materialPlanEntity, SupMaterialPlanVO.class);
            List<SupMaterialPlanDetailVO> supMaterialPlanDetailVOS = BeanMapper.mapList(materialPlanEntity.getMaterialPlanDetailList(), SupMaterialPlanDetailVO.class);
            supMaterialPlanVO.setMaterialPlanDetailList(supMaterialPlanDetailVOS);
            supMaterialPlanVO.setId(null);
            paramMap.put("plan", JSONObject.toJSONString(supMaterialPlanVO));

            //查询单据附件信息并下载
            CommonResponse<List<AttachmentVO>> fileResp = attachmentApi.queryListBySourceId(materialPlanEntity.getId(), "EJCBT202408000008", "materialPlanFile", null);
            if (fileResp.isSuccess()) {
                Map<String, Map<String, InputStream>> files = new HashMap<>();
                List<AttachmentVO> fileList = fileResp.getData();
                List<Long> fileIds = new ArrayList<>();
                //从附件信息列表获取到： 1、附件名对应附件业务类型Map,2、获取到附件Id列表
                for (AttachmentVO attach : fileList) {
                    fileIds.add(attach.getId());
                }
                //当前单据携带有附件信息
                if (org.apache.commons.collections.CollectionUtils.isNotEmpty(fileList)) {
                    Map<String, InputStream> fileMap = FileUtil.getInstance().batchDownFileFlow(fileIds, true);
                    fileMap.keySet().stream().forEach(fileKey -> {
                        Map<String, InputStream> file = new HashMap<>(1);
                        file.put(fileKey, fileMap.get(fileKey));
                        files.put("file", file);
                    });
                }
                logger.info("向供应商-{}推送领料计划单据参数-{}", materialPlanEntity.getSupplierId(), JSONObject.toJSONString(paramMap));

                //推送单据到指定的供方
                CommonResponse<String> syncReqResp = systemDataPushService.exchangeDataAndFilesWithEachLinkSystem(PUSH_BILL_SERVER_URL,
                        paramMap,
                        materialPlanEntity.getSupplierId().toString(),
                        files);
                syncFlag = CommonUtils.checkCommonResponse(syncReqResp, logger);
//                if (syncReqResp.isSuccess()) {
//                    JSONObject jsonObject = JSONObject.parseObject(syncReqResp.getData());
//                    // 如果返回的结果包含code
//                    if(StringUtils.isNotEmpty(syncReqResp.getData())&& jsonObject.containsKey("code")){
//                        CommonResponse<String> billPushResp = JSONObject.parseObject(syncReqResp.getData(), CommonResponse.class);
//                        if (billPushResp.isSuccess()) {
//                            syncFlag = true;
//                        } else {
//                            logger.error("供方id-{}处理推送订单单据id-{}失败, {}", materialPlanEntity.getSupplierId(), materialPlanEntity.getId(), billPushResp.getMsg());
//                            throw new BusinessException(billPushResp.getMsg());
//                        }
//                    }else {
//                        throw new BusinessException();
//                    }
//
//                } else {
//                    logger.error("发送请求推送订单单据id-{}给供方id-{}失败, {}", materialPlanEntity.getId(), materialPlanEntity.getSupplierId(), syncReqResp.getMsg());
//                    throw new BusinessException(syncReqResp.getMsg());
//                }
            } else {
                logger.error("获取订单单据id-{}对应附件信息失败, {}", materialPlanEntity.getId(), fileResp.getMsg());
                throw new BusinessException(fileResp.getMsg());
            }

        } catch (Exception e) {
            logger.error("推送订单单据id-{}给供方id-{} 异常，", materialPlanEntity.getId(), materialPlanEntity.getSupplierId(), e);
            throw new BusinessException("推送供方异常!");
        } finally {
            //释放单据锁
            releaseLock(jedis, locked, key, OPERATE);
        }

        return syncFlag;
    }

    public void releaseLock(Jedis jedis, boolean locked, String key, String OPERATE) {
        try {
            if (locked) {
                RedisTool.releaseLock(jedis, key, OPERATE);
            }
        } finally {
            if (null != jedis) {
                jedis.close();
            }
        }
    }

    @Override
    public Boolean delSupPLan(Long billId, String dataInfo, String url, RequestMethod method, String supplierId, String operate, String billTypeCode) {
        //推送供方
        //对单据进行加锁
        Boolean locked = false;
        Boolean syncFlag = false;
        String key = billTypeCode + "::" + billId.toString();
        Jedis jedis = jedisPool.getResource();
        try {
            locked = RedisTool.tryLock(jedis, key, operate, 600);
            if (!locked) {
                releaseLock(jedis, false, key, operate);
                logger.error("单据{}推送失败，单据锁获取失败-{}！", billId, locked);
                return false;
            }
            CommonResponse<String> syncReqResp = systemDataPushService.exchangeDataWithEachLinkSystem(url, method, dataInfo, supplierId);
            if (syncReqResp.isSuccess()) {
                CommonResponse<String> billPushResp = JSONObject.parseObject(syncReqResp.getData(), CommonResponse.class);
                if (billPushResp.isSuccess()) {
                    syncFlag = true;
                } else {
                    logger.error("供方id-{}处理推送单据id-{}失败, {}", supplierId, billId, billPushResp.getMsg());
                }
            } else {
                logger.error("供方id-{}处理推送单据id-{}失败, {}", supplierId, billId, syncReqResp.getMsg());

            }
        } catch (Exception e) {
            logger.error("推送发货单单据id-{}给供方id-{} 异常，", billId, supplierId, e);
        } finally {
            //释放单据锁
            releaseLock(jedis, locked, key, operate);
        }
        return syncFlag;
    }



    @Override
    public String updateBillSupSignSyncInfo(HttpServletRequest request) {
        String authority = request.getHeader("authority");
        String msg = null;

        Jedis jedis = null;
        boolean locked = false;

        String billId = request.getParameter("billId");
        String supOperatorName = request.getParameter("supOperatorName");
        String supOperatorPhone = request.getParameter("supOperatorPhone");
        String supOperatorUserCode = request.getParameter("supOperatorUserCode");
        Date supOperateTime = new Date(Long.parseLong(request.getParameter("supOperateTime")));
        String nameSourceTypeMapping = request.getParameter("nameSourceTypeMapping");
        Map<String, String> mp = JSONObject.parseObject(nameSourceTypeMapping, Map.class);

        MaterialPlanEntity materialPlanEntity = super.selectById(billId);
        //设置供方签字信息
        materialPlanEntity.setSupOperateTime(supOperateTime);
        materialPlanEntity.setSupOperatorName(supOperatorName);
        materialPlanEntity.setSupOperatorPhone(supOperatorPhone);
        materialPlanEntity.setSupOperatorUserCode(supOperatorUserCode);

        String key = BILL_TYPE + "::" + materialPlanEntity.getId().toString();

        try {
            jedis = jedisPool.getResource();
            //对单据进行加锁
            locked = RedisTool.tryLock(jedis, key, OPERATE, 600);

            if (!locked) {
                logger.error("单据id-{}签字信息回写加锁失败！", materialPlanEntity.getId());
                releaseLock(jedis, false, key, OPERATE);
                return "单据签字信息回写加锁失败";
            }

            //保存单据中附件并获取到上传后附件的Id
            Map<String, List<Long>> attachIdsMap = FileUtil.getInstance().handleReqFile((MultipartHttpServletRequest) request,
                    mp, BILL_TYPE, authority, materialPlanEntity.getId().toString());

            List<Long> attchIdsList = new ArrayList<>();
            for (List<Long> attachIds : attachIdsMap.values()) {
                if (CollectionUtils.isNotEmpty(attachIds)) {
                    attchIdsList.addAll(attachIds);
                }
            }
            //将附件关联在单据中
            materialPlanEntity.setAttachIds(attchIdsList);
            //将单据设置为乙方已签字状态 签字状态：1-未签字、2-待乙方签字、3-待甲方签字、4-已签字
            // 乙方已签字状态即待甲方签字
            materialPlanEntity.setSignStatus(2);
            //更新单据
            super.saveOrUpdate(materialPlanEntity, false);

//            //向单据制单人和经办人推送该消息
//            String msgSendResult = sendMsg(materialPlanEntity, "供方已签字提醒", "结算单据[" + settleEntity.getBillCode() + "]供方已签字完成");
//            if (null != msgSendResult) {
//                logger.error("向用户-{}发送单据id-{}签字提醒失败，原因：{}", StringUtils.join(settleEntity.getCreateUserId(), settleEntity.getEmployeeId()),
//                        settleEntity.getId(), msgSendResult);
//            }

        } catch (Exception e) {
            logger.error("单据id-{}签字信息回写异常，", materialPlanEntity.getId(), e);
            msg = "单据签字信息回写失败！";
        } finally {
            releaseLock(jedis, locked, key, OPERATE);
        }

        return msg;
    }


}
