package com.ejianc.wzxt.set.service.impl;

import com.baomidou.mybatisplus.core.conditions.query.LambdaQueryWrapper;
import com.baomidou.mybatisplus.core.toolkit.Wrappers;
import com.ejianc.foundation.orgcenter.api.IOrgApi;
import com.ejianc.foundation.orgcenter.vo.OrgVO;
import com.ejianc.framework.core.response.CommonResponse;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;
import com.ejianc.framework.skeleton.template.BaseServiceImpl;

import com.ejianc.wzxt.set.mapper.SmallSetMapper;
import com.ejianc.wzxt.set.bean.SmallSetEntity;
import com.ejianc.wzxt.set.service.ISmallSetService;

import java.util.Arrays;

/**
 * 零星材料验收设置表
 *
 * @author generator
 *
 */
@Service("smallSetService")
public class SmallSetServiceImpl extends BaseServiceImpl<SmallSetMapper, SmallSetEntity> implements ISmallSetService{

    @Autowired
    private IOrgApi iOrgApi;

    @Override
    public Boolean querySetByProj(Long projectDepartmentId) {
        CommonResponse<OrgVO> response = iOrgApi.getOneById(projectDepartmentId);
        if (response.isSuccess() && null != response.getData()) {
            String[] strings = response.getData().getInnerCode().split("\\|");
            LambdaQueryWrapper<SmallSetEntity> queryWrapper = Wrappers.lambdaQuery();
            queryWrapper.in(SmallSetEntity::getOrgId, Arrays.asList(strings));
            return count(queryWrapper) > 0;
        }
        return false;
    }
}
