package com.ejianc.wzxt.delivery.controller;

import com.alibaba.fastjson.JSONObject;
import com.baomidou.mybatisplus.core.metadata.IPage;
import com.baomidou.mybatisplus.extension.plugins.pagination.Page;
import com.ejianc.business.weigh.wagon.api.IWagonMaterialApi;
import com.ejianc.business.weigh.wagon.vo.WagonMaterialVO;
import com.ejianc.business.weigh.weighbill.api.IWeighbillApi;
import com.ejianc.business.weigh.weighbill.vo.WeighbillVO;
import com.ejianc.foundation.orgcenter.api.IOrgApi;
import com.ejianc.foundation.orgcenter.vo.OrgVO;
import com.ejianc.foundation.outcontract.api.IOutcontractApi;
import com.ejianc.foundation.share.api.IShareMaterialApi;
import com.ejianc.foundation.support.api.IBillCodeApi;
import com.ejianc.foundation.support.api.IBillTypeApi;
import com.ejianc.foundation.support.vo.BillCodeParam;
import com.ejianc.framework.auth.session.SessionManager;
import com.ejianc.framework.auth.session.UserContext;
import com.ejianc.framework.core.context.InvocationInfoProxy;
import com.ejianc.framework.core.exception.BusinessException;
import com.ejianc.framework.core.kit.collection.ListUtil;
import com.ejianc.framework.core.kit.mapper.BeanMapper;
import com.ejianc.framework.core.response.CommonResponse;
import com.ejianc.framework.core.response.Parameter;
import com.ejianc.framework.core.response.QueryParam;
import com.ejianc.framework.core.util.ExcelExport;
import com.ejianc.wzxt.check.vo.CheckVO;
import com.ejianc.wzxt.delivery.bean.DeliveryEntity;
import com.ejianc.wzxt.delivery.service.IDeliveryService;
import com.ejianc.wzxt.delivery.vo.DeliverySaveVO;
import com.ejianc.wzxt.delivery.vo.DeliveryVO;
import com.ejianc.wzxt.enums.CheckStateEnum;
import io.swagger.annotations.Api;
import io.swagger.annotations.ApiOperation;
import io.swagger.annotations.ApiParam;
import org.apache.commons.collections.CollectionUtils;
import org.apache.commons.lang3.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Controller;
import org.springframework.web.bind.annotation.*;

import javax.servlet.http.HttpServletResponse;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.function.Function;
import java.util.stream.Collectors;

/**
 * 消耗材-发货单
 *
 * @author generator
 */
@Controller
@RequestMapping("delivery")
@Api(value = "消耗材-发货单", tags = {"消耗材-发货单"})
public class DeliveryController implements Serializable {
    private static final long serialVersionUID = 1L;

    private Logger logger = LoggerFactory.getLogger(this.getClass());

    @Autowired
    private IBillCodeApi billCodeApi;

    @Autowired
    private IWeighbillApi weighbillApi;
    @Autowired
    private IOrgApi iOrgApi;

    private static final String BILL_CODE = "ZJKJ-DELIVERY-CODE";//此处需要根据实际修改

    @Autowired
    private IDeliveryService service;

    @Autowired
    private SessionManager sessionManager;

    @ApiOperation("新增或者修改")
    @RequestMapping(value = "/saveOrUpdate", method = RequestMethod.POST)
    @ResponseBody
    public CommonResponse<DeliverySaveVO> saveOrUpdate(@ApiParam(name = "saveOrUpdateVO", required = true) @RequestBody DeliverySaveVO saveOrUpdateVO) {
        DeliveryEntity entity = BeanMapper.map(saveOrUpdateVO, DeliveryEntity.class);
        if (entity.getId() == null || entity.getId() == 0) {
            BillCodeParam billCodeParam = BillCodeParam.build(BILL_CODE, InvocationInfoProxy.getTenantid(), saveOrUpdateVO);
            CommonResponse<String> billCode = billCodeApi.generateBillCode(billCodeParam);
            if (billCode.isSuccess()) {
                entity.setBillCode(billCode.getData());//此处需要根据实际修改 删除本行或者上一行
            } else {
                throw new BusinessException("网络异常， 编码生成失败， 请稍后再试");
            }
        }
        service.saveOrUpdate(entity, false);
        DeliverySaveVO vo = BeanMapper.map(entity, DeliverySaveVO.class);
        return CommonResponse.success("保存或修改单据成功！", vo);
    }

    @ApiOperation("供方推送发货单接口")
    @RequestMapping(value = "/supplierPushDelivery", method = RequestMethod.POST)
    @ResponseBody
    public CommonResponse<DeliveryVO> supplierPushDelivery(@RequestBody DeliveryVO saveOrUpdateVO) {
        logger.info("供方推送的数据:" + saveOrUpdateVO.toString());
        DeliveryVO vo = service.saveOrUpdates(saveOrUpdateVO);
        return CommonResponse.success("保存或修改单据成功！", vo);
    }


    @ApiOperation("重新推送第三方失败数据接口")
    @RequestMapping(value = "/PushThirdData", method = RequestMethod.GET)
    @ResponseBody
    public CommonResponse<DeliveryVO> savePushThirdData(@RequestParam Long id) {
        DeliveryVO vo = service.savePushThirdData(id);
        return CommonResponse.success(vo);
    }

    @ApiOperation("查询详情")
    @RequestMapping(value = "/queryDetail", method = RequestMethod.GET)
    @ResponseBody
    public CommonResponse<DeliverySaveVO> queryDetail(@RequestParam Long id) {
        DeliveryEntity entity = service.selectById(id);
        DeliverySaveVO vo = BeanMapper.map(entity, DeliverySaveVO.class);
        return CommonResponse.success("查询详情数据成功！", vo);
    }

    @ApiOperation("查询详情(验收用)")
    @RequestMapping(value = "/queryDetailToCheck", method = RequestMethod.GET)
    @ResponseBody
    public CommonResponse<CheckVO> queryDetailToCheck(@RequestParam Long id) {
        CheckVO vo = service.queryDetailToCheck(id);
        return CommonResponse.success("查询详情数据成功！", vo);
    }

    @ApiOperation("发货单关闭接口")
    @RequestMapping(value = "/closeDelivery", method = RequestMethod.GET)
    @ResponseBody
    public CommonResponse<DeliveryVO> closeDelivery(@RequestParam Long id) {
        DeliveryVO vo = service.closeDelivery(id);
        return CommonResponse.success("发货单关闭成功！", vo);
    }


    @ApiOperation("批量删除单据")
    @RequestMapping(value = "/delete", method = RequestMethod.POST)
    @ResponseBody
    public CommonResponse<String> delete(@RequestBody List<DeliverySaveVO> vos) {
        if (ListUtil.isNotEmpty(vos)) {
            for (DeliverySaveVO vo : vos) {
                // 参数是单据类型编码字符串 根据需求是否打开下面代码
                /* CommonResponse<String> resp = billTypeApi.checkQuote("billTypeCode", vo.getId());
                if(!resp.isSuccess()){
                    return CommonResponse.error("删除失败！"+resp.getMsg());
                }*/
            }
        }
        service.removeByIds(vos.stream().map(DeliverySaveVO::getId).collect(Collectors.toList()), true);
        return CommonResponse.success("删除成功！");
    }


    @ApiOperation("查询列表")
    @RequestMapping(value = "/queryList", method = RequestMethod.POST)
    @ResponseBody
    public CommonResponse<IPage<DeliveryVO>> queryList(@RequestBody QueryParam param) {
        /** 模糊搜索配置字段示例 */
        List<String> fuzzyFields = param.getFuzzyFields();
        fuzzyFields.add("billCode");
        fuzzyFields.add("projectName");
        fuzzyFields.add("contractName");
        fuzzyFields.add("supplierName");
        /** 租户隔离 */
        param.getParams().put("tenantId", new Parameter(QueryParam.EQ, InvocationInfoProxy.getTenantid()));

        Parameter parameter = param.getParams().get("checkStatus");
        if (null == parameter) {
            List<Integer> checkStatusList = new ArrayList<>();
            checkStatusList.add(0);
            checkStatusList.add(1);
            param.getParams().put("checkStatus", new Parameter(QueryParam.IN, checkStatusList));
        }
//        param.getParams().put("closeFlag", new Parameter(QueryParam.EQ,0));

        /** 数据隔离 本下 没有组织orgId的删除下面代码-------------开始 */
        UserContext userContextCache = sessionManager.getUserContext();
        //当前应用有权限的根orgId，以逗号分割，可据此查询其本下数据，需判空
        String authOrgIds = userContextCache.getAuthOrgIds();
        List<OrgVO> orgVOList = null;
        if (!param.getParams().containsKey("orgId")) {//PC端查询
            orgVOList = (List<OrgVO>) getRespData(iOrgApi.findChildrenByParentId(InvocationInfoProxy.getOrgId()), true, "查询失败，获取当前本下组织信息失败。");
            //普通组织 id
            List<Long> commonOrgIds = new ArrayList<>();
            //项目部 id
            List<Long> departmentIds = new ArrayList<>();
            orgVOList.stream().forEach(org -> {
                if (5 == org.getOrgType()) {
                    //项目部
                    departmentIds.add(org.getId());
                } else {
                    //普通组织
                    commonOrgIds.add(org.getId());
                }
            });
            if (CollectionUtils.isNotEmpty(commonOrgIds)) {
                /** 要求主表有orgId字段，保存单据所属组织 */
                param.getParams().put("parentOrgId", new Parameter(QueryParam.IN, commonOrgIds));
            } else if (CollectionUtils.isNotEmpty(departmentIds)) {
                /** 要求主表有projectDepartmentId字段，保存单据所属项目部 */
                param.getParams().put("orgId", new Parameter(QueryParam.IN, departmentIds));
            }
            /** 数据隔离 本下 没有组织orgId的删除上面代码-------------结束！！！ */
        }
        /** 数据隔离 本下 没有组织orgId的删除上面代码-------------结束！！！ */

        IPage<DeliveryEntity> page = service.queryPage(param, false);
        IPage<DeliveryVO> pageData = new Page<>(page.getCurrent(), page.getSize(), page.getTotal());
        List<DeliveryVO> deliveryVOS = BeanMapper.mapList(page.getRecords(), DeliveryVO.class);
        List<Long> collect = deliveryVOS.stream().map(DeliveryVO::getId).collect(Collectors.toList());
        Map<Long, WeighbillVO> weighbillVOMap = new HashMap<>();
        if (CollectionUtils.isNotEmpty(collect)) {
            CommonResponse<List<WeighbillVO>> listCommonResponse = weighbillApi.queryWeighBydeliveryId(collect);
            if (listCommonResponse.isSuccess()) {
                List<WeighbillVO> data = listCommonResponse.getData();
                logger.info("查询磅单数量结果：{}", JSONObject.toJSONString(data));
                if (CollectionUtils.isNotEmpty(data)) {
                    weighbillVOMap = data.stream().collect(Collectors.toMap(WeighbillVO::getDeliveryId, Function.identity()));
                }
                for (DeliveryVO deliveryVO : deliveryVOS) {
                    WeighbillVO weighbillVOS = weighbillVOMap.get(deliveryVO.getId());
                    if (null != weighbillVOS) {
                        deliveryVO.setCheckWeighNum(weighbillVOS.getWeightCheckNum());
                        deliveryVO.setWeighNum(weighbillVOS.getWeightNum());
                    } else {
                        deliveryVO.setCheckWeighNum(0);
                        deliveryVO.setWeighNum(0);
                    }
                }
            }
        }
        pageData.setRecords(deliveryVOS);
        return CommonResponse.success("查询列表数据成功！", pageData);
    }

    /**
     * 获取RPC数据
     * resp 返回值
     * isMustSuc 是否必须成功
     * errMsg 失败提示
     */
    private Object getRespData(CommonResponse<?> resp, boolean isMustSuc, String errMsg) {
        if (isMustSuc && !resp.isSuccess()) {
            throw new BusinessException(StringUtils.isNoneBlank(errMsg) ? errMsg : "调用Rpc服务失败");
        }
        return resp.getData();
    }


    @ApiOperation("导出")
    @RequestMapping(value = "/excelExport", method = RequestMethod.POST)
    @ResponseBody
    public void excelExport(@RequestBody QueryParam param, HttpServletResponse response) {
        /** 模糊搜索配置字段示例 */
        List<String> fuzzyFields = param.getFuzzyFields();
        fuzzyFields.add("billCode");
        fuzzyFields.add("projectName");
        fuzzyFields.add("contractName");
        fuzzyFields.add("supplierName");
        /** 租户隔离 */
        param.getParams().put("tenantId", new Parameter(QueryParam.EQ, InvocationInfoProxy.getTenantid()));
        List<Integer> checkStatusList = new ArrayList<>();
        checkStatusList.add(0);
        checkStatusList.add(1);
        param.getParams().put("checkStatus", new Parameter(QueryParam.IN, checkStatusList));
//        param.getParams().put("closeFlag", new Parameter(QueryParam.EQ,0));

        /** 数据隔离 本下 没有组织orgId的删除下面代码-------------开始 */
        UserContext userContextCache = sessionManager.getUserContext();
        //当前应用有权限的根orgId，以逗号分割，可据此查询其本下数据，需判空
        String authOrgIds = userContextCache.getAuthOrgIds();
        List<OrgVO> orgVOList = null;
        if (!param.getParams().containsKey("orgId")) {//PC端查询
            orgVOList = (List<OrgVO>) getRespData(iOrgApi.findChildrenByParentId(InvocationInfoProxy.getOrgId()), true, "查询失败，获取当前本下组织信息失败。");
            //普通组织 id
            List<Long> commonOrgIds = new ArrayList<>();
            //项目部 id
            List<Long> departmentIds = new ArrayList<>();
            orgVOList.stream().forEach(org -> {
                if (5 == org.getOrgType()) {
                    //项目部
                    departmentIds.add(org.getId());
                } else {
                    //普通组织
                    commonOrgIds.add(org.getId());
                }
            });
            if (CollectionUtils.isNotEmpty(commonOrgIds)) {
                /** 要求主表有orgId字段，保存单据所属组织 */
                param.getParams().put("parentOrgId", new Parameter(QueryParam.IN, commonOrgIds));
            } else if (CollectionUtils.isNotEmpty(departmentIds)) {
                /** 要求主表有projectDepartmentId字段，保存单据所属项目部 */
                param.getParams().put("orgId", new Parameter(QueryParam.IN, departmentIds));
            }
            /** 数据隔离 本下 没有组织orgId的删除上面代码-------------结束！！！ */
        }

        param.setPageIndex(1);
        param.setPageSize(-1);
        List<DeliveryEntity> list = service.queryList(param);
        for (DeliveryEntity entity : list) {
            entity.setCheckStatusName(CheckStateEnum.getEnumByStatus(entity.getCheckStatus()).getStatusName());
        }
        Map<String, Object> beans = new HashMap<>();
        beans.put("records", list);
        ExcelExport.getInstance().export("Delivery-export.xlsx", beans, response);
    }


    @ApiOperation("参照")
    @RequestMapping(value = "/refDeliveryData", method = RequestMethod.GET)
    @ResponseBody
    public CommonResponse<IPage<DeliveryVO>> refDeliveryData(@RequestParam Integer pageNumber, @RequestParam Integer pageSize,
                                                             String condition,
                                                             String searchObject,
                                                             String searchText) {
        QueryParam param = new QueryParam();
        param.setPageSize(pageSize);
        param.setPageIndex(pageNumber);
        param.setSearchText(searchText);
        param.setSearchObject(searchObject);
        /** 租户隔离 */
        param.getParams().put("tenantId", new Parameter(QueryParam.EQ, InvocationInfoProxy.getTenantid()));
        if (StringUtils.isNotEmpty(condition)) {
            /** 处理condition */
            JSONObject _con = JSONObject.parseObject(condition);
        }

        IPage<DeliveryEntity> page = service.queryPage(param, false);
        IPage<DeliveryVO> pageData = new Page<>(page.getCurrent(), page.getSize(), page.getTotal());
        pageData.setRecords(BeanMapper.mapList(page.getRecords(), DeliveryVO.class));

        return CommonResponse.success("查询参照数据成功！", pageData);
    }

   /* @ApiOperation("参照")
    @RequestMapping(value = "/refContractTypeDetailData", method = RequestMethod.GET)
    @ResponseBody
    public CommonResponse<IPage<ContractDetailVO>> refContractTypeDetailData(@RequestParam Integer pageNumber, @RequestParam Integer pageSize,
                                                                             String condition,
                                                                             String searchObject,
                                                                             String searchText) {
        List<ContractDetailVO> materialVOS = new ArrayList<>();
        Integer size = 0;
        if (StringUtils.isNotEmpty(condition)) {
            *//** 处理condition *//*
            JSONObject _con = JSONObject.parseObject(condition);
            if (_con.containsKey("contractId")) {
                CommonResponse<OutcontractVO> commonResponse = outcontractApi.queryDetail(Long.valueOf(String.valueOf(_con.get("contractId"))));
                List<ContractDetailEntity> contractDetailEntities = contractDetailService.queryList(queryParam);
                if (CollectionUtils.isNotEmpty(contractDetailEntities)) {
                    List<Long> longs = contractDetailEntities.stream().map(t -> t.getMaterialTypeId()).collect(Collectors.toList());
                    CommonResponse<List<MaterialVO>> listCommonResponse = shareMaterialApi.queryMaterialByCategoryId(longs);
                    if (!listCommonResponse.isSuccess()) {
                        return CommonResponse.error("查询参照数据失败！错误信息：" + listCommonResponse.getMsg());
                    }
                    List<MaterialVO> materialList = listCommonResponse.getData();
                    if (_con.containsKey("projectId")) {
                        Long projectId = Long.valueOf(String.valueOf(_con.get("projectId")));
                        if (CollectionUtils.isNotEmpty(materialList)) {
                            List<Long> collect = materialList.stream().map(t -> t.getId()).collect(Collectors.toList());
                            CommonResponse<List<WagonMaterialVO>> response = wagonMaterialApi.queryMaterialAutomaticWeighList(projectId, collect);
                            if (!response.isSuccess()) {
                                return CommonResponse.error("查询参照数据失败！错误信息：" + response.getMsg());
                            }
                            List<WagonMaterialVO> wagonMaterialVOS = pageList(response.getData(), pageSize, pageNumber, searchText);
                            size = response.getData().size();
                            logger.info("自动称重材料:" + JSONObject.toJSONString(wagonMaterialVOS));
                            if (CollectionUtils.isNotEmpty(wagonMaterialVOS)) {
                                Map<Long, ContractDetailEntity> collect1 = contractDetailEntities.stream().collect(Collectors.toMap(ContractDetailEntity::getMaterialTypeId, item -> item, (v1, v2) -> v2));
                                List<ContractDetailVO> contractDetailVOS = BeanMapper.mapList(wagonMaterialVOS, ContractDetailVO.class);
                                materialVOS = contractDetailVOS.stream().map(t -> {
                                    t.setMemo(collect1.get(t.getMaterialTypeId()).getMemo());
                                    t.setDetailAdmixtureId(collect1.get(t.getMaterialTypeId()).getDetailAdmixtureId());
                                    t.setDetailAdmixtureName(collect1.get(t.getMaterialTypeId()).getDetailAdmixtureName());
                                    return t;
                                }).collect(Collectors.toList());
                            }
                        }
                    }
                }
            }
        }
        IPage<ContractDetailVO> pageData = new Page<>(pageNumber, pageSize, size);
        pageData.setRecords(materialVOS);
        return CommonResponse.success("查询参照数据成功！", pageData);
    }

    @ApiOperation("参照")
    @RequestMapping(value = "/refContractDetailData", method = RequestMethod.GET)
    @ResponseBody
    public CommonResponse<IPage<ContractDetailVO>> refContractDetailData(@RequestParam Integer pageNumber, @RequestParam Integer pageSize,
                                                                         String condition,
                                                                         String searchObject,
                                                                         String searchText) {
        Long projectId = null;
        Integer size = 0;
        List<ContractDetailVO> materialVOS = new ArrayList<>();
        if (StringUtils.isNotEmpty(condition)) {
            *//** 处理condition *//*
            JSONObject _con = JSONObject.parseObject(condition);
            if (_con.containsKey("contractId")) {
                QueryParam queryParam = new QueryParam();
                queryParam.getParams().put("contract_id", new Parameter(QueryParam.EQ, Long.valueOf(String.valueOf(_con.get("contractId")))));
                queryParam.getParams().put("material_id", new Parameter(QueryParam.NE, null));
                if (_con.containsKey("projectId")) {//---磅单查询用
                    projectId = Long.valueOf(String.valueOf(_con.get("projectId")));
                    List<ContractDetailEntity> contractDetailEntities = contractDetailService.queryList(queryParam);
                    if (CollectionUtils.isNotEmpty(contractDetailEntities)) {
                        List<Long> collect = contractDetailEntities.stream().map(t -> t.getMaterialId()).collect(Collectors.toList());
                        CommonResponse<List<WagonMaterialVO>> response = wagonMaterialApi.queryMaterialAutomaticWeighList(projectId, collect);
                        if (!response.isSuccess()) {
                            return CommonResponse.error("查询参照数据失败！错误信息：" + response.getMsg());
                        }
                        List<WagonMaterialVO> materialVOS1 = pageList(response.getData(), pageSize, pageNumber, searchText);
                        size = response.getData().size();
                        Map<Long, WagonMaterialVO> collect1 = materialVOS1.stream().collect(Collectors.toMap(WagonMaterialVO::getMaterialId, item -> item, (v1, v2) -> v2));
                        List<ContractDetailVO> contractDetailVOS = BeanMapper.mapList(contractDetailEntities, ContractDetailVO.class);
                        materialVOS = contractDetailVOS.stream().filter(t -> collect1.containsKey(t.getMaterialId())).map(t -> {
                            t.setAutomaticWeigh(AutomaticWeighEnum.自动称重.getCode());
                            return t;
                        }).collect(Collectors.toList());
                    }
                }
            }
        }
        IPage<ContractDetailVO> pageData = new Page<>(pageNumber, pageSize, size);
        pageData.setRecords(materialVOS);
        return CommonResponse.success("查询参照数据成功！", pageData);
    }*/

    //分页/模糊查询
    public List<WagonMaterialVO> pageList(List<WagonMaterialVO> dataList, int pageSize, int pageNo, String searchText) {
        List<WagonMaterialVO> currentPageList = new ArrayList<>();
        if (StringUtils.isNotEmpty(searchText)) {
            dataList = dataList.stream().filter(item ->
                    (StringUtils.isNotEmpty(item.getMaterialName()) ? item.getMaterialName().contains(searchText) : false) ||
                            (StringUtils.isNotEmpty(item.getMaterialTypeName()) ? item.getMaterialTypeName().contains(searchText) : false) ||
                            (StringUtils.isNotEmpty(item.getSpec()) ? item.getSpec().contains(searchText) : false) ||
                            (StringUtils.isNotEmpty(item.getMaterialCode()) ? item.getMaterialCode().contains(searchText) : false)
            )
                    .collect(Collectors.toList());
        }
        if (dataList != null && dataList.size() > 0) {
            int currIdx = (pageNo > 1 ? (pageNo - 1) * pageSize : 0);
            for (int i = 0; i < pageSize && i < dataList.size() - currIdx; i++) {
                WagonMaterialVO data = dataList.get(currIdx + i);
                currentPageList.add(data);
            }
        }
        return currentPageList;
    }
}
