package com.ejianc.wzxt.delivery.controller.api;

import com.alibaba.fastjson.JSONObject;
import com.baomidou.mybatisplus.core.conditions.query.LambdaQueryWrapper;
import com.baomidou.mybatisplus.core.toolkit.Wrappers;
import com.ejianc.framework.core.kit.mapper.BeanMapper;
import com.ejianc.framework.core.response.CommonResponse;
import com.ejianc.wzxt.delivery.bean.DeliveryDetailEntity;
import com.ejianc.wzxt.delivery.bean.DeliveryEntity;
import com.ejianc.wzxt.delivery.service.IDeliveryDetailService;
import com.ejianc.wzxt.delivery.service.IDeliveryService;
import com.ejianc.wzxt.delivery.vo.DeliveryDetailVO;
import com.ejianc.wzxt.delivery.vo.DeliveryVO;
import io.swagger.annotations.ApiOperation;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.web.bind.annotation.*;

import java.util.ArrayList;
import java.util.List;

@RestController
@RequestMapping("/api/delivery/")
public class DeliveryApi {
    private Logger logger = LoggerFactory.getLogger(this.getClass());
    @Autowired
    private IDeliveryService deliveryService;
    @Autowired
    private IDeliveryDetailService deliveryDetailService;

    /**
     * 根据物资明细id 获取发货单详情
     *
     * @param detailId 明细id
     * @return
     */
    @ApiOperation("根据物资明细id 获取发货单详情")
    @RequestMapping(value = "/queryDeliveryByDetailId", method = RequestMethod.GET)
    @ResponseBody
    public CommonResponse<DeliveryVO> queryDeliveryByDetailId(@RequestParam("detailId") Long detailId) {
        logger.info("物资明细id，查询参数：{}", detailId);
        DeliveryVO resVo = new DeliveryVO();
        DeliveryDetailEntity deliveryDetailEntity = deliveryDetailService.getById(detailId);
        if(null!=deliveryDetailEntity){
            DeliveryEntity deliveryEntity = deliveryService.getById(deliveryDetailEntity.getDeliveryId());
            resVo = BeanMapper.map(deliveryEntity,DeliveryVO.class);
            DeliveryDetailVO deliveryDetailVO = BeanMapper.map(deliveryDetailEntity,DeliveryDetailVO.class);
            List<DeliveryDetailVO> list = new ArrayList<>();
            list.add(deliveryDetailVO);
            resVo.setDeliveryDetailList(list);
        }
        logger.info("根据物资明细id 获取发货单详情，查询结果：{}", JSONObject.toJSONString(resVo));
        return CommonResponse.success("查询成功",resVo);
    }

    /**
     * 根据子表来源id 获取发货单详情
     *
     * @param detailSrcId 明细id
     * @return
     */
    @ApiOperation("根据子表来源id 获取发货单详情")
    @RequestMapping(value = "/queryDeliveryByDetailSrcId", method = RequestMethod.GET)
    @ResponseBody
    public CommonResponse<DeliveryVO> queryDeliveryByDetailSrcId(@RequestParam("detailSrcId") Long detailSrcId) {
        logger.info("物资明细id，查询参数：{}", detailSrcId);
        DeliveryVO resVo = new DeliveryVO();
        LambdaQueryWrapper<DeliveryDetailEntity> queryWrapper = Wrappers.lambdaQuery();
        queryWrapper.eq(DeliveryDetailEntity::getSourceDetailId, detailSrcId);
        DeliveryDetailEntity deliveryDetailEntity = deliveryDetailService.getOne(queryWrapper, false);
        if(null!=deliveryDetailEntity){
            DeliveryEntity deliveryEntity = deliveryService.getById(deliveryDetailEntity.getDeliveryId());
            resVo = BeanMapper.map(deliveryEntity,DeliveryVO.class);
            DeliveryDetailVO deliveryDetailVO = BeanMapper.map(deliveryDetailEntity,DeliveryDetailVO.class);
            List<DeliveryDetailVO> list = new ArrayList<>();
            list.add(deliveryDetailVO);
            resVo.setDeliveryDetailList(list);
        }
        logger.info("根据物资明细id 获取发货单详情，查询结果：{}", JSONObject.toJSONString(resVo));
        return CommonResponse.success("查询成功",resVo);
    }
}
