package com.ejianc.wzxt.enums;

import java.util.EnumSet;
import java.util.HashMap;
import java.util.Map;
import java.util.function.Function;
import java.util.stream.Collectors;

public enum CheckTypeEnum {
    自制验收(1, "自制验收"),
    零星材料验收(2, "零星材料验收"),
    发货验收(3, "发货验收");

    private Integer code;
    private String name;

    CheckTypeEnum(Integer code, String name) {
        this.code = code;
        this.name = name;
    }

    public Integer getCode() {
        return code;
    }

    public String getName() {
        return name;
    }

    private static Map<Integer, CheckTypeEnum> enumMap = new HashMap();

    public static CheckTypeEnum getEnumByStatus(Integer status) {
        return (CheckTypeEnum)enumMap.get(status);
    }

    static {
        enumMap = (Map) EnumSet.allOf(CheckTypeEnum.class).stream().collect(Collectors.toMap(CheckTypeEnum::getCode, Function.identity(), (k1, k2) -> {
            return k2;
        }));
    }
}
