package com.ejianc.wzxt.plan.controller;

import java.io.Serializable;

import cn.hutool.core.util.NumberUtil;
import com.baomidou.mybatisplus.core.toolkit.Wrappers;
import com.ejianc.foundation.orgcenter.vo.OrgVO;
import com.ejianc.foundation.share.api.IShareMaterialApi;
import com.ejianc.foundation.share.vo.MaterialVO;
import com.ejianc.foundation.support.api.IBillCodeApi;
import com.ejianc.foundation.support.api.IBillTypeApi;
import com.ejianc.foundation.support.vo.BillCodeParam;
import com.ejianc.framework.core.exception.BusinessException;
import com.ejianc.framework.core.response.BillStateEnum;
import com.ejianc.framework.core.util.ExcelExport;
import com.ejianc.framework.core.kit.collection.ListUtil;
import com.ejianc.framework.core.util.ExcelReader;
import com.ejianc.framework.core.util.FileUtils;
import com.ejianc.framework.core.util.ImportTemplate;
import com.ejianc.support.idworker.util.IdWorker;
import com.ejianc.wzxt.plan.vo.MasterPlanVO;
import com.ejianc.wzxt.plan.vo.MaterialPlanDetailVO;
import org.apache.commons.lang3.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

import java.math.BigDecimal;
import java.text.DateFormat;
import java.text.ParseException;
import java.text.SimpleDateFormat;
import java.util.*;
import java.util.stream.Collectors;
import com.alibaba.fastjson.JSONObject;
import org.springframework.stereotype.Controller;
import org.springframework.web.bind.annotation.*;
import org.apache.commons.collections.CollectionUtils;

import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;

import com.ejianc.foundation.orgcenter.api.IOrgApi;
import com.ejianc.framework.core.response.CommonResponse;
import org.springframework.beans.factory.annotation.Autowired;
import com.ejianc.framework.core.context.InvocationInfoProxy;
import com.ejianc.framework.core.kit.mapper.BeanMapper;
import com.ejianc.framework.auth.session.SessionManager;
import com.ejianc.framework.auth.session.UserContext;

import com.baomidou.mybatisplus.core.metadata.IPage;
import com.baomidou.mybatisplus.extension.plugins.pagination.Page;
import com.ejianc.framework.core.response.Parameter;
import com.ejianc.framework.core.response.QueryParam;
import io.swagger.annotations.Api;
import io.swagger.annotations.ApiOperation;
import io.swagger.annotations.ApiParam;

import com.ejianc.wzxt.plan.bean.MaterialPlanEntity;
import com.ejianc.wzxt.plan.service.IMaterialPlanService;
import com.ejianc.wzxt.plan.vo.MaterialPlanVO;
import org.springframework.web.multipart.MultipartFile;
import org.springframework.web.multipart.MultipartHttpServletRequest;

/**
 * 领料计划-主表
 *
 * @author generator
 *
 */
@Controller
@RequestMapping("materialPlan")
@Api(value = "领料计划-主表", tags = {"领料计划-主表"})
public class MaterialPlanController implements Serializable {
	private static final long serialVersionUID = 1L;

    private Logger logger = LoggerFactory.getLogger(this.getClass());

    @Autowired
    private IBillTypeApi billTypeApi;
    @Autowired
    private IBillCodeApi billCodeApi;
    @Autowired
    private IOrgApi iOrgApi;

    private static final String BILL_CODE = "MATERIALPLAN";//此处需要根据实际修改

    @Autowired
    private IMaterialPlanService service;
    @Autowired
    private IShareMaterialApi shareMaterialApi;


    @Autowired
    private SessionManager sessionManager;
    /**
     * 导入模板下载
     *
     * @param request
     * @param response
     */
    @RequestMapping(value = "/downloadModel")
    @ResponseBody
    public void downloadModel(HttpServletRequest request, HttpServletResponse response) {
        ImportTemplate.initialize(response);
        ImportTemplate.templetdownload(request, "MaterialPlanDetail-import.xlsx", "领料计划模板");
    }

    @ApiOperation("新增或者修改")
    @RequestMapping(value = "/saveOrUpdate", method = RequestMethod.POST)
    @ResponseBody
    public CommonResponse<MaterialPlanVO> saveOrUpdate(@ApiParam(name="saveOrUpdateVO", required=true) @RequestBody MaterialPlanVO saveOrUpdateVO) {
    	MaterialPlanEntity entity = BeanMapper.map(saveOrUpdateVO, MaterialPlanEntity.class);
    	if(entity.getId() == null || entity.getId() == 0){
            BillCodeParam billCodeParam = BillCodeParam.build(BILL_CODE,InvocationInfoProxy.getTenantid(),saveOrUpdateVO);
            CommonResponse<String> billCode = billCodeApi.generateBillCode(billCodeParam);
            if(billCode.isSuccess()) {
                entity.setPlanCode(billCode.getData());
            }else{
                throw new BusinessException("网络异常， 编码生成失败， 请稍后再试");
            }
        }
        entity.setSignStatus(1);
    	service.saveOrUpdate(entity, false);
    	MaterialPlanVO vo = BeanMapper.map(entity, MaterialPlanVO.class);
    	return CommonResponse.success("保存或修改单据成功！",vo);
    }


    @ApiOperation("查询详情")
    @RequestMapping(value = "/queryDetail", method = RequestMethod.GET)
    @ResponseBody
    public CommonResponse<MaterialPlanVO> queryDetail(@RequestParam Long id) {
    	MaterialPlanEntity entity = service.selectById(id);
    	MaterialPlanVO vo = BeanMapper.map(entity, MaterialPlanVO.class);
        return CommonResponse.success("查询详情数据成功！",vo);
    }


    @ApiOperation("批量删除单据")
    @RequestMapping(value = "/delete", method = RequestMethod.POST)
    @ResponseBody
    public CommonResponse<String> delete(@RequestBody List<MaterialPlanVO> vos) {
        if(ListUtil.isNotEmpty(vos)){
            for (MaterialPlanVO vo : vos) {
                // 参数是单据类型编码字符串 根据需求是否打开下面代码
                /* CommonResponse<String> resp = billTypeApi.checkQuote("billTypeCode", vo.getId());
                if(!resp.isSuccess()){
                    return CommonResponse.error("删除失败！"+resp.getMsg());
                }*/
            }
        }
        service.removeByIds(vos.stream().map(MaterialPlanVO::getId).collect(Collectors.toList()),true);
        return CommonResponse.success("删除成功！");
    }


    @ApiOperation("查询列表")
    @RequestMapping(value = "/queryList", method = RequestMethod.POST)
    @ResponseBody
    public CommonResponse<IPage<MaterialPlanVO>> queryList(@RequestBody QueryParam param) {
        /** 模糊搜索配置字段示例 */
        List<String> fuzzyFields = param.getFuzzyFields();
        fuzzyFields.add("planCode");
        fuzzyFields.add("projectCode");
        fuzzyFields.add("projectName");
        fuzzyFields.add("operatorName");
        fuzzyFields.add("contractName");

        /** 租户隔离 */
        param.getParams().put("tenantId", new Parameter(QueryParam.EQ, InvocationInfoProxy.getTenantid()));

        if(!param.getParams().containsKey("orgId")){
            /** 数据隔离 本下 没有组织orgId的删除下面代码-------------开始 */
            UserContext userContextCache =sessionManager.getUserContext();
            //当前应用有权限的根orgId，以逗号分割，可据此查询其本下数据，需判空
            String authOrgIds = userContextCache.getAuthOrgIds();
            List<OrgVO> orgVOList = null;
            if(StringUtils.isNotBlank(authOrgIds)){//移动端查询
                orgVOList = (List<OrgVO>) getRespData(iOrgApi.findChildrenByParentIds(Arrays.stream(authOrgIds.split(",")).map(Long::parseLong).collect(Collectors.toList())), true, "查询失败，获取当前本下组织信息失败。");
            }else {//pc端查询
                orgVOList = (List<OrgVO>) getRespData(iOrgApi.findChildrenByParentId(InvocationInfoProxy.getOrgId()), true, "查询失败，获取当前本下组织信息失败。");
            }
            //普通组织 id
            List<Long> commonOrgIds = new ArrayList<>();
            //项目部 id
            List<Long> departmentIds = new ArrayList<>();
            orgVOList.stream().forEach(org -> {
                if(5 == org.getOrgType()) {
                    //项目部
                    departmentIds.add(org.getId());
                } else {
                    //普通组织
                    commonOrgIds.add(org.getId());
                }
            });
            if(CollectionUtils.isNotEmpty(commonOrgIds)) {
                /** 要求主表有orgId字段，保存单据所属组织 */
                param.getParams().put("parentOrgId", new Parameter(QueryParam.IN, commonOrgIds));
            } else if(CollectionUtils.isNotEmpty(departmentIds)) {
                /** 要求主表有projectDepartmentId字段，保存单据所属项目部 */
                param.getParams().put("orgId", new Parameter(QueryParam.IN, departmentIds));
            }
            /** 数据隔离 本下 没有组织orgId的删除上面代码-------------结束！！！ */
        }
        IPage<MaterialPlanEntity> page = service.queryPage(param,false);
        IPage<MaterialPlanVO> pageData = new Page<>(page.getCurrent(), page.getSize(), page.getTotal());
  		pageData.setRecords(BeanMapper.mapList(page.getRecords(), MaterialPlanVO.class));

        return CommonResponse.success("查询列表数据成功！",pageData);
    }

    /**
     * 获取RPC数据
     * resp 返回值
     * isMustSuc 是否必须成功
     * errMsg 失败提示
     */
    private Object getRespData(CommonResponse<?> resp, boolean isMustSuc, String errMsg) {
        if(isMustSuc && !resp.isSuccess()) {
            throw new BusinessException(StringUtils.isNoneBlank(errMsg) ? errMsg : "调用Rpc服务失败");
        }
        return resp.getData();
    }


    @ApiOperation("导出")
    @RequestMapping(value = "/excelExport", method = RequestMethod.POST)
    @ResponseBody
    public void excelExport(@RequestBody QueryParam param, HttpServletResponse response) {
        /** 模糊搜索配置字段示例 */
        List<String> fuzzyFields = param.getFuzzyFields();
        fuzzyFields.add("planCode");
        fuzzyFields.add("projectCode");
        fuzzyFields.add("projectName");
        fuzzyFields.add("operatorName");
        fuzzyFields.add("contractName");
        param.getParams().put("tenant_id",new Parameter(QueryParam.EQ,InvocationInfoProxy.getTenantid()));
        param.setPageIndex(1);
        param.setPageSize(-1);
        /** 数据隔离 本下 没有组织orgId的删除下面代码 */
        param.getParams().put("orgId",new Parameter(QueryParam.IN,iOrgApi.findChildrenByParentId(InvocationInfoProxy.getOrgId()).getData().stream().map(OrgVO::getId).collect(Collectors.toList())));
        List<MaterialPlanEntity> list = service.queryList(param);
        List<MaterialPlanVO> voList = new ArrayList<>();
        if(CollectionUtils.isNotEmpty(list)) {
            voList = BeanMapper.mapList(list, MaterialPlanVO.class);
            voList.forEach(val -> {

                val.setBillStateName(BillStateEnum.getEnumByStateCode(val.getBillState()).getDescription());
            });
        }

        //todo:字段翻译等等
        Map<String, Object> beans = new HashMap<>();
        beans.put("records", list);
        ExcelExport.getInstance().export("MaterialPlan-export.xlsx", beans, response);
    }

    /**
     * excel导入
     *
     * @param request
     * @param response
     * @return
     */
    @RequestMapping(value = "/excelImport", method = RequestMethod.POST)
    @ResponseBody
    public CommonResponse<Object> excelImport(HttpServletRequest request,HttpServletResponse response) throws ParseException {
        logger.info("11112222");
        MultipartHttpServletRequest multipartRequest = (MultipartHttpServletRequest) request;
        Map<String, MultipartFile> fileMap = multipartRequest.getFileMap();
        List<MaterialPlanDetailVO> successList = new ArrayList<>();
        List<MaterialPlanDetailVO> errorList = new ArrayList<>();
        DateFormat sdf = new SimpleDateFormat("yyyy/MM/dd");
        boolean isFailed = false;
        MultipartFile mf = null;
        for (Map.Entry<String, MultipartFile> entity : fileMap.entrySet()) {
            mf = entity.getValue();
            String originalFileName = mf.getOriginalFilename();
            String extName = null;
            originalFileName = originalFileName.replaceAll("\\/|\\/|\\||:|\\?|\\*|\"|<|>|\\p{Cntrl}", "_");
            originalFileName.replaceAll("00.", "");
            extName = FileUtils.getFileExt(originalFileName, false);
            if (!"xls".equals(extName) && !"xlsx".equals(extName)) {
                isFailed = true;
                break;
            }
        }
        if (isFailed) {
            return CommonResponse.error("文件格式不合法");
        } else {
            List<List<String>> result = ExcelReader.readExcel(mf);
            Map<String, String> map = new HashMap<>();
            if (result != null && result.size() > 0) {
                for (int i = 1; i < result.size(); i++) {
                    int errorCount =0;
                    List<String> datas = result.get(i);
                    MaterialPlanDetailVO materialPlanDetailVO = new MaterialPlanDetailVO();
                    materialPlanDetailVO.setId(IdWorker.getId());//id
                    if (datas.get(0) == null && StringUtils.isBlank(datas.get(0))) {
                        materialPlanDetailVO.setErrorMsg("'物资分类'不能为空");
                        errorCount++;
                        errorList.add(materialPlanDetailVO);
                        continue;
                    }else{
                        materialPlanDetailVO.setMaterialCategoryName(StringUtils.isNotBlank(datas.get(0)) ? datas.get(0) : null); // 材料编码
                    }

                    if (StringUtils.isBlank(datas.get(1)) && datas.get(1) == null) {
                        materialPlanDetailVO.setErrorMsg("'物资编码'不能为空");
                        errorCount++;
                        errorList.add(materialPlanDetailVO);
                        continue;
                    }else{
                        materialPlanDetailVO.setMaterialCode(StringUtils.isNotBlank(datas.get(1)) ? datas.get(1) : null); // 材料名称
                    }
                    if (StringUtils.isBlank(datas.get(2)) && datas.get(2) == null) {
                        materialPlanDetailVO.setErrorMsg("'物资名称'不能为空");
                        errorCount++;
                        errorList.add(materialPlanDetailVO);
                        continue;
                    }else{
                        materialPlanDetailVO.setMaterialName(StringUtils.isNotBlank(datas.get(2)) ? datas.get(2) : null); //

                    }
                    if (map.containsKey(materialPlanDetailVO.getMaterialCode())){
                        materialPlanDetailVO.setErrorMsg("'物资编码'重复");
                        errorCount++;
                        errorList.add(materialPlanDetailVO);
                        continue;
                    }else {
                        map.put(materialPlanDetailVO.getMaterialCode(),"1");
                    }


//                    if (StringUtils.isBlank(datas.get(3)) && datas.get(3) == null) {
//                        materialPlanDetailVO.setErrorMsg("'规格型号'不能为空");
//                        errorCount++;
//                        errorList.add(materialPlanDetailVO);
//                        continue;
//                    }else{
                        materialPlanDetailVO.setSpec(StringUtils.isNotBlank(datas.get(3)) ? datas.get(3) : null);
//                    }

//                    if (StringUtils.isBlank(datas.get(4)) && datas.get(4) == null) {
//                        materialPlanDetailVO.setErrorMsg("'计量单位'不能为空");
//                        errorCount++;
//                        errorList.add(materialPlanDetailVO);
//                        continue;
//                    }else{
                        materialPlanDetailVO.setUnit(StringUtils.isNotBlank(datas.get(4)) ? datas.get(4) : null);
//                    }

                    if (!NumberUtil.isNumber(datas.get(5))) {
                        materialPlanDetailVO.setErrorMsg("'计划领用数量'不是数字");
                        errorCount++;
                        errorList.add(materialPlanDetailVO);
                        continue;
                    }else{
                        materialPlanDetailVO.setPlanNum(StringUtils.isNotBlank(datas.get(5)) ? new BigDecimal(datas.get(5)) : null);
                    }

//                    if (StringUtils.isBlank(datas.get(6)) && datas.get(6) == null) {
//                        materialPlanDetailVO.setErrorMsg("'计量单位'不能为空");
//                        errorCount++;
//                        errorList.add(materialPlanDetailVO);
//                        continue;
//                    }else{
                        materialPlanDetailVO.setUnit(StringUtils.isNotBlank(datas.get(6)) ? datas.get(6) : null);
//                    }




                    //校验库中物资
                    CommonResponse<MaterialVO> back0 = shareMaterialApi.queryMaterialByCode(datas.get(1));
                    if (back0.getCode() == 1 || back0.getData() == null) {
                        materialPlanDetailVO.setErrorMsg("未查询到该物资编码下的物资详情");
                        errorCount++;
                        errorList.add(materialPlanDetailVO);
                        continue;
                    }
                    MaterialVO materialVO = back0.getData();
                    materialPlanDetailVO.setMaterialName(materialVO.getName());
                    materialPlanDetailVO.setMaterialCategoryName(materialVO.getCategoryName());
                    materialPlanDetailVO.setMaterialCategoryId(materialVO.getCategoryId());
                    materialPlanDetailVO.setMaterialId(materialVO.getId());

                    if(errorCount==0){
                        successList.add(materialPlanDetailVO);
                    }
                }
            }
        }

        JSONObject json = new JSONObject();
        json.put("successNum", successList.size());
        json.put("successList", successList);
        json.put("errorList", errorList);
        json.put("errorNum", errorList.size());
        return CommonResponse.success(json);
    }



    @ApiOperation("参照")
    @RequestMapping(value = "/refMaterialPlanData", method = RequestMethod.GET)
    @ResponseBody
    public CommonResponse<IPage<MaterialPlanVO>> refMaterialPlanData(@RequestParam Integer pageNumber, @RequestParam Integer pageSize,
                                                                        String condition,
                                                                        String searchObject,
                                                                        String searchText) {
        QueryParam param = new QueryParam();
        param.setPageSize(pageSize);
        param.setPageIndex(pageNumber);
        param.setSearchText(searchText);
        param.setSearchObject(searchObject);
        /** 租户隔离 */
        param.getParams().put("tenantId", new Parameter(QueryParam.EQ, InvocationInfoProxy.getTenantid()));
        if(StringUtils.isNotEmpty(condition)){
            /** 处理condition */
            JSONObject _con = JSONObject.parseObject(condition);
        }

        IPage<MaterialPlanEntity> page = service.queryPage(param,false);
        IPage<MaterialPlanVO> pageData = new Page<>(page.getCurrent(), page.getSize(), page.getTotal());
        pageData.setRecords(BeanMapper.mapList(page.getRecords(), MaterialPlanVO.class));

        return CommonResponse.success("查询参照数据成功！",pageData);
     }

    /**
     * 供方签字确认信息回写
     *
     * @param request
     * @return
     */
    @PostMapping(value = "/updateSignStatus")
    @ResponseBody
    public CommonResponse<String> updateSignStatus(HttpServletRequest request) {
        String msg = service.updateBillSupSignSyncInfo(request);
        if (StringUtils.isNotBlank(msg)) {
            return CommonResponse.error(msg);
        }
        return CommonResponse.success("签字状态回写成功！");
    }

}
