package com.ejianc.wzxt.plan.controller;

import com.alibaba.fastjson.JSONObject;
import com.baomidou.mybatisplus.core.conditions.query.LambdaQueryWrapper;
import com.baomidou.mybatisplus.core.metadata.IPage;
import com.baomidou.mybatisplus.core.toolkit.Wrappers;
import com.baomidou.mybatisplus.extension.plugins.pagination.Page;
import com.ejianc.foundation.orgcenter.api.IOrgApi;
import com.ejianc.foundation.orgcenter.vo.OrgVO;
import com.ejianc.foundation.support.api.IBillCodeApi;
import com.ejianc.foundation.support.api.IBillTypeApi;
import com.ejianc.foundation.support.vo.ParamsCheckVO;
import com.ejianc.framework.auth.session.SessionManager;
import com.ejianc.framework.auth.session.UserContext;
import com.ejianc.framework.core.context.InvocationInfoProxy;
import com.ejianc.framework.core.exception.BusinessException;
import com.ejianc.framework.core.kit.collection.ListUtil;
import com.ejianc.framework.core.kit.mapper.BeanMapper;
import com.ejianc.framework.core.response.BillStateEnum;
import com.ejianc.framework.core.response.CommonResponse;
import com.ejianc.framework.core.response.Parameter;
import com.ejianc.framework.core.response.QueryParam;
import com.ejianc.framework.core.util.ComputeUtil;
import com.ejianc.framework.core.util.ExcelExport;
import com.ejianc.wzxt.plan.bean.MonthPlanDetailEntity;
import com.ejianc.wzxt.plan.bean.MonthPlanEntity;
import com.ejianc.wzxt.plan.service.IMonthPlanService;
import com.ejianc.wzxt.plan.vo.*;
import io.swagger.annotations.Api;
import io.swagger.annotations.ApiOperation;
import io.swagger.annotations.ApiParam;
import org.apache.commons.collections.CollectionUtils;
import org.apache.commons.lang3.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Controller;
import org.springframework.web.bind.annotation.*;

import javax.servlet.http.HttpServletResponse;
import java.io.Serializable;
import java.util.*;
import java.util.stream.Collectors;

/**
 * 材料月计划-主表
 *
 * @author generator
 *
 */
@Controller
@RequestMapping("monthPlan")
@Api(value = "材料月计划-主表", tags = {"材料月计划-主表"})
public class MonthPlanController implements Serializable {
    private static final long serialVersionUID = 1L;

    private Logger logger = LoggerFactory.getLogger(this.getClass());

    @Autowired
    private IBillTypeApi billTypeApi;
    @Autowired
    private IBillCodeApi billCodeApi;
    @Autowired
    private IOrgApi iOrgApi;

    private static final String BILL_CODE = "Invoice_Open_Apply_Code";//此处需要根据实际修改

    @Autowired
    private IMonthPlanService service;

    @Autowired
    private SessionManager sessionManager;

    @ApiOperation("新增或者修改")
    @RequestMapping(value = "/saveOrUpdate", method = RequestMethod.POST)
    @ResponseBody
    public CommonResponse<MonthPlanVO> saveOrUpdate(@ApiParam(name="saveOrUpdateVO", required=true) @RequestBody MonthPlanVO saveOrUpdateVO) {
        MonthPlanVO vo = service.saveOrUpdate(saveOrUpdateVO);

        return CommonResponse.success("保存或修改单据成功！",vo);
    }
    /**
     * 单据管控-
     *
     * @return
     */
    @RequestMapping(value = "/checkParams", method = RequestMethod.POST)
    @ResponseBody
    public CommonResponse<ParamsCheckVO> checkParams(@RequestBody MonthPlanVO vo) {
        ParamsCheckVO paramsCheckVO = service.checkParams(vo, null);
        return CommonResponse.success("参数校验成功！", paramsCheckVO);
    }

    @ApiOperation("查询详情")
    @RequestMapping(value = "/queryDetail", method = RequestMethod.GET)
    @ResponseBody
    public CommonResponse<MonthPlanVO> queryDetail(@RequestParam Long id) {
        MonthPlanVO vo = service.queryDetail(id);
        return CommonResponse.success("查询详情数据成功！",vo);
    }

    @ApiOperation("根据项目id校验数据是否能新增")
    @RequestMapping(value = "/queryDetailByProjectId", method = RequestMethod.GET)
    @ResponseBody
    public CommonResponse<MonthPlanBooleanVO> queryDetailByProjectId(@RequestParam(required = false) Long projectId,@RequestParam(required = false) Long id) {
        LambdaQueryWrapper<MonthPlanEntity> lambda = Wrappers.<MonthPlanEntity>lambdaQuery();
        lambda.eq(MonthPlanEntity::getProjectId,projectId);
        lambda.notIn(id != null,MonthPlanEntity::getId,id);
        lambda.orderByDesc(MonthPlanEntity::getId);
        List<MonthPlanEntity> monthPlanEntities = service.list(lambda);
        MonthPlanBooleanVO booleanVO = new MonthPlanBooleanVO();
        Boolean b = true;
        if (CollectionUtils.isNotEmpty(monthPlanEntities)){
            boolean match = monthPlanEntities.stream().anyMatch(s -> s.getBillState() == 0 || s.getChangeState() == 1);
            if (match){
               b = false;
            }
        }
        booleanVO.setB(b);
        if (CollectionUtils.isNotEmpty(monthPlanEntities)){
            booleanVO.setDate(monthPlanEntities.stream().findFirst().get().getPlanDate());
        }


        return CommonResponse.success("查询详情数据成功！",booleanVO);
    }
//    @ApiOperation("根据项目id校验一个项目一个月只能有一条数据")
//    @RequestMapping(value = "/checkAloneById", method = RequestMethod.GET)
//    @ResponseBody
//    public CommonResponse<MonthPlanBooleanVO> checkAloneById(@RequestParam Long projectId,@RequestParam Long id) {
//        LambdaQueryWrapper<MonthPlanEntity> lambda = Wrappers.<MonthPlanEntity>lambdaQuery();
//        lambda.eq(MonthPlanEntity::getProjectId,projectId);
//        lambda.notIn(id != null,MonthPlanEntity::getId,id);
//        lambda.notIn(id != null,MonthPlanEntity::getId,id);
//        lambda.orderByDesc(MonthPlanEntity::getId);
//        List<MonthPlanEntity> monthPlanEntities = service.list(lambda);
//        MonthPlanBooleanVO booleanVO = new MonthPlanBooleanVO();
//        Boolean b = true;
//        if (CollectionUtils.isNotEmpty(monthPlanEntities)){
//            boolean match = monthPlanEntities.stream().anyMatch(s -> s.getBillState() == 0 || s.getChangeState() == 1);
//            if (match){
//               b = false;
//            }
//        }
//        booleanVO.setB(b);
//        booleanVO.setDate(monthPlanEntities.stream().findFirst().get().getPlanDate());
//
//        return CommonResponse.success("查询详情数据成功！",booleanVO);
//    }



    @ApiOperation("批量删除单据")
    @RequestMapping(value = "/delete", method = RequestMethod.POST)
    @ResponseBody
    public CommonResponse<String> delete(@RequestBody List<MonthPlanVO> vos) {
        if(ListUtil.isNotEmpty(vos)){
            for (MonthPlanVO vo : vos) {
                // 参数是单据类型编码字符串 根据需求是否打开下面代码
                /* CommonResponse<String> resp = billTypeApi.checkQuote("billTypeCode", vo.getId());
                if(!resp.isSuccess()){
                    return CommonResponse.error("删除失败！"+resp.getMsg());
                }*/
            }
        }
        service.removeByIds(vos.stream().map(MonthPlanVO::getId).collect(Collectors.toList()),true);
        return CommonResponse.success("删除成功！");
    }
    @ApiOperation("")
    @RequestMapping(value = "/getDeleteFlag", method = RequestMethod.POST)
    @ResponseBody
    public CommonResponse<List<MonthPlanDetailVO>> getDeleteFlag(@RequestBody MonthPlanDetailQueryVO vo) {
        List<MonthPlanDetailVO> list = service.getDeleteFlag(vo);
        return CommonResponse.success("查询成功！",list);
    }
    /**
     * @Description saveOrUpdate 查询是否能填写收款信息
     */
    @RequestMapping(value = "/getFlag", method = RequestMethod.GET)
    @ResponseBody
    public CommonResponse<Boolean> getFlag(Long id){

        MonthPlanEntity monthPlanEntity = service.selectById(id);
        LambdaQueryWrapper<MonthPlanEntity> lambda = Wrappers.<MonthPlanEntity>lambdaQuery();
        lambda.gt(MonthPlanEntity::getId, id);
        lambda.eq(MonthPlanEntity::getProjectId, monthPlanEntity.getProjectId());
//        lambda.eq(MonthPlanEntity::getContractId, engineermeasurementEntity.getContractId());
//        lambda.in(MonthPlanEntity::getBillState, 1,3);
        List<MonthPlanEntity> costanalysisEntityList = service.list(lambda);
        Boolean b = true;
        if (CollectionUtils.isNotEmpty(costanalysisEntityList)){
            b = false;
        }
        return CommonResponse.success(b);
    }



    @ApiOperation("查询列表")
    @RequestMapping(value = "/queryList", method = RequestMethod.POST)
    @ResponseBody
    public CommonResponse<IPage<MonthPlanVO>> queryList(@RequestBody QueryParam param) {
        /** 模糊搜索配置字段示例 */
        List<String> fuzzyFields = param.getFuzzyFields();
        fuzzyFields.add("planCode");
        fuzzyFields.add("projectCode");
        fuzzyFields.add("projectName");
        fuzzyFields.add("operatorName");
        /** 租户隔离 */
        param.getParams().put("tenantId", new Parameter(QueryParam.EQ, InvocationInfoProxy.getTenantid()));

        if(!param.getParams().containsKey("orgId")){
            /** 数据隔离 本下 没有组织orgId的删除下面代码-------------开始 */
            UserContext userContextCache =sessionManager.getUserContext();
            //当前应用有权限的根orgId，以逗号分割，可据此查询其本下数据，需判空
            String authOrgIds = userContextCache.getAuthOrgIds();
            List<OrgVO> orgVOList = null;
            if(StringUtils.isNotBlank(authOrgIds)){//移动端查询
                orgVOList = (List<OrgVO>) getRespData(iOrgApi.findChildrenByParentIds(Arrays.stream(authOrgIds.split(",")).map(Long::parseLong).collect(Collectors.toList())), true, "查询失败，获取当前本下组织信息失败。");
            }else {//pc端查询
                orgVOList = (List<OrgVO>) getRespData(iOrgApi.findChildrenByParentId(InvocationInfoProxy.getOrgId()), true, "查询失败，获取当前本下组织信息失败。");
            }
            //普通组织 id
            List<Long> commonOrgIds = new ArrayList<>();
            //项目部 id
            List<Long> departmentIds = new ArrayList<>();
            orgVOList.stream().forEach(org -> {
                if(5 == org.getOrgType()) {
                    //项目部
                    departmentIds.add(org.getId());
                } else {
                    //普通组织
                    commonOrgIds.add(org.getId());
                }
            });
            if(CollectionUtils.isNotEmpty(commonOrgIds)) {
                /** 要求主表有orgId字段，保存单据所属组织 */
                param.getParams().put("parentOrgId", new Parameter(QueryParam.IN, commonOrgIds));
            } else if(CollectionUtils.isNotEmpty(departmentIds)) {
                /** 要求主表有projectDepartmentId字段，保存单据所属项目部 */
                param.getParams().put("orgId", new Parameter(QueryParam.IN, departmentIds));
            }
            /** 数据隔离 本下 没有组织orgId的删除上面代码-------------结束！！！ */
        }
        IPage<MonthPlanEntity> page = service.queryPage(param,false);
        IPage<MonthPlanVO> pageData = new Page<>(page.getCurrent(), page.getSize(), page.getTotal());
        pageData.setRecords(BeanMapper.mapList(page.getRecords(), MonthPlanVO.class));

        return CommonResponse.success("查询列表数据成功！",pageData);
    }

    /**
     * 获取RPC数据
     * resp 返回值
     * isMustSuc 是否必须成功
     * errMsg 失败提示
     */
    private Object getRespData(CommonResponse<?> resp, boolean isMustSuc, String errMsg) {
        if(isMustSuc && !resp.isSuccess()) {
            throw new BusinessException(StringUtils.isNoneBlank(errMsg) ? errMsg : "调用Rpc服务失败");
        }
        return resp.getData();
    }


    @ApiOperation("导出")
    @RequestMapping(value = "/excelExport", method = RequestMethod.POST)
    @ResponseBody
    public void excelExport(@RequestBody QueryParam param, HttpServletResponse response) {
        /** 模糊搜索配置字段示例 */
        List<String> fuzzyFields = param.getFuzzyFields();
        param.getParams().put("tenant_id",new Parameter(QueryParam.EQ,InvocationInfoProxy.getTenantid()));
        param.setPageIndex(1);
        param.setPageSize(-1);
        fuzzyFields.add("planCode");
        fuzzyFields.add("projectCode");
        fuzzyFields.add("projectName");
        fuzzyFields.add("operatorName");
        /** 数据隔离 本下 没有组织orgId的删除下面代码 */
        param.getParams().put("orgId",new Parameter(QueryParam.IN,iOrgApi.findChildrenByParentId(InvocationInfoProxy.getOrgId()).getData().stream().map(OrgVO::getId).collect(Collectors.toList())));
        List<MonthPlanEntity> list = service.queryList(param);
        //todo:字段翻译等等
        Map<String, Object> beans = new HashMap<>();
        List<MonthPlanVO> voList = new ArrayList<>();
        if(CollectionUtils.isNotEmpty(list)) {
            voList = BeanMapper.mapList(list, MonthPlanVO.class);
            voList.forEach(val -> {
                switch (val.getChangeState()) {
                    case 0:
                        val.setChangeStateName("未变更");
                        break;
                    case 1:
                        val.setChangeStateName("变更中");
                        break;
                    case 2:
                        val.setChangeStateName("已变更");
                        break;
                }
                val.setBillStateName(BillStateEnum.getEnumByStateCode(val.getBillState()).getDescription());
            });
        }
        beans.put("records", voList);
        ExcelExport.getInstance().export("MonthPlan-export.xlsx", beans, response);
    }


    @ApiOperation("参照")
    @RequestMapping(value = "/refMonthPlanData", method = RequestMethod.GET)
    @ResponseBody
    public CommonResponse<IPage<MonthPlanVO>> refMonthPlanData(@RequestParam Integer pageNumber, @RequestParam Integer pageSize,
                                                                 String condition,
                                                                 String searchObject,
                                                                 String searchText) {
        QueryParam param = new QueryParam();
        param.setPageSize(pageSize);
        param.setPageIndex(pageNumber);
        param.setSearchText(searchText);
        param.setSearchObject(searchObject);
        /** 租户隔离 */
        param.getParams().put("tenantId", new Parameter(QueryParam.EQ, InvocationInfoProxy.getTenantid()));
        if(StringUtils.isNotEmpty(condition)){
            /** 处理condition */
            JSONObject _con = JSONObject.parseObject(condition);
        }

        IPage<MonthPlanEntity> page = service.queryPage(param,false);
        IPage<MonthPlanVO> pageData = new Page<>(page.getCurrent(), page.getSize(), page.getTotal());
        pageData.setRecords(BeanMapper.mapList(page.getRecords(), MonthPlanVO.class));

        return CommonResponse.success("查询参照数据成功！",pageData);
    }

    @GetMapping(value = "/getContrastInfo")
    @ResponseBody
    public CommonResponse<List<MonthPlanContrastVO>> getContrastInfo(@RequestParam(value = "materialMonthPlanId") Long materialMonthPlanId,
                                                                      @RequestParam(value = "oldMaterialMonthPlanId") Long oldMaterialMonthPlanId) {

        List<MonthPlanContrastVO> list= service.getContrastInfo(materialMonthPlanId,oldMaterialMonthPlanId);

        return CommonResponse.success("获取对比数据成功！",list);
    }

    @GetMapping(value = "/getDetailByProject")
    @ResponseBody
    public CommonResponse<List<MonthPlanDetailVO>> getDetailByProject(@RequestParam(value = "projectId") Long projectId) {
        LambdaQueryWrapper<MonthPlanEntity> lambdaMaster = Wrappers.<MonthPlanEntity>lambdaQuery();
        lambdaMaster.eq(MonthPlanEntity::getProjectId, projectId);
        lambdaMaster.in(MonthPlanEntity::getBillState, 1, 3);
        lambdaMaster.orderByDesc(MonthPlanEntity::getPlanDate);
        lambdaMaster.last("limit 1");
        MonthPlanEntity planEntity = service.getOne(lambdaMaster);
        if (null != planEntity) {
            MonthPlanEntity entity = service.selectById(planEntity.getId());
            List<MonthPlanDetailEntity> monthPlanDetailList = entity.getMonthPlanDetailList();
            if(CollectionUtils.isNotEmpty(monthPlanDetailList)){
                for (MonthPlanDetailEntity masterPlanDetailEntity : monthPlanDetailList){
                    masterPlanDetailEntity.setPlanTotalSurplusNum(ComputeUtil.safeSub(masterPlanDetailEntity.getPlanMonthNum(), masterPlanDetailEntity.getOrderNum(), masterPlanDetailEntity.getSelfCheckNum()));
                }
            }
            return CommonResponse.success("获取对比数据成功！", BeanMapper.mapList(monthPlanDetailList, MonthPlanDetailVO.class));
        }
        return CommonResponse.success("获取对比数据成功！", new ArrayList<>());
    }
}
