package com.ejianc.wzxt.plan.controller;

import java.io.Serializable;

import com.baomidou.mybatisplus.core.conditions.query.LambdaQueryWrapper;
import com.baomidou.mybatisplus.core.conditions.query.QueryWrapper;
import com.baomidou.mybatisplus.core.toolkit.Wrappers;
import com.ejianc.foundation.orgcenter.vo.OrgVO;
import com.ejianc.foundation.support.api.IBillCodeApi;
import com.ejianc.foundation.support.api.IBillTypeApi;
import com.ejianc.foundation.support.vo.BillCodeParam;
import com.ejianc.framework.core.exception.BusinessException;
import com.ejianc.framework.core.util.ComputeUtil;
import com.ejianc.framework.core.util.ExcelExport;
import com.ejianc.framework.core.kit.collection.ListUtil;
import com.ejianc.wzxt.check.bean.CheckDetailEntity;
import com.ejianc.wzxt.check.bean.CheckEntity;
import com.ejianc.wzxt.check.service.ICheckDetailService;
import com.ejianc.wzxt.check.service.ICheckService;
import com.ejianc.wzxt.delivery.vo.DeliveryDetailVO;
import com.ejianc.wzxt.plan.bean.MonthPlanDetailEntity;
import com.ejianc.wzxt.plan.bean.MonthPlanEntity;
import com.ejianc.wzxt.plan.bean.SmallPlanEntity;
import com.ejianc.wzxt.plan.service.ISmallPlanService;
import com.ejianc.wzxt.plan.vo.MasterPlanDetailVO;
import com.ejianc.wzxt.plan.vo.SmallPlanVO;
import org.apache.commons.lang3.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

import java.math.BigDecimal;
import java.util.*;
import java.util.stream.Collectors;
import com.alibaba.fastjson.JSONObject;
import org.springframework.stereotype.Controller;
import org.springframework.web.bind.annotation.*;
import org.apache.commons.collections.CollectionUtils;
import javax.servlet.http.HttpServletResponse;

import com.ejianc.foundation.orgcenter.api.IOrgApi;
import com.ejianc.framework.core.response.CommonResponse;
import org.springframework.beans.factory.annotation.Autowired;
import com.ejianc.framework.core.context.InvocationInfoProxy;
import com.ejianc.framework.core.kit.mapper.BeanMapper;
import com.ejianc.framework.auth.session.SessionManager;
import com.ejianc.framework.auth.session.UserContext;

import com.baomidou.mybatisplus.core.metadata.IPage;
import com.baomidou.mybatisplus.extension.plugins.pagination.Page;
import com.ejianc.framework.core.response.Parameter;
import com.ejianc.framework.core.response.QueryParam;
import io.swagger.annotations.Api;
import io.swagger.annotations.ApiOperation;
import io.swagger.annotations.ApiParam;

import com.ejianc.wzxt.plan.bean.SmallPlanDetailEntity;
import com.ejianc.wzxt.plan.service.ISmallPlanDetailService;
import com.ejianc.wzxt.plan.vo.SmallPlanDetailVO;

import static com.ejianc.framework.skeleton.template.BaseServiceImpl.changeToQueryWrapper;

/**
 * 零星材料计划-子表
 *
 * @author generator
 *
 */
@Controller
@RequestMapping("smallPlanDetail")
@Api(value = "零星材料计划-子表", tags = {"零星材料计划-子表"})
public class SmallPlanDetailController implements Serializable {
	private static final long serialVersionUID = 1L;

    private Logger logger = LoggerFactory.getLogger(this.getClass());

    @Autowired
    private IBillTypeApi billTypeApi;
    @Autowired
    private IBillCodeApi billCodeApi;
    @Autowired
    private IOrgApi iOrgApi;

    private static final String BILL_CODE = "Invoice_Open_Apply_Code";//此处需要根据实际修改

    @Autowired
    private ISmallPlanDetailService service;
    @Autowired
    private ISmallPlanService smallPlanService;

    @Autowired
    private SessionManager sessionManager;
    @Autowired
    private ICheckService checkService;
    @Autowired
    private ICheckDetailService checkDetailService;

    @ApiOperation("新增或者修改")
    @RequestMapping(value = "/saveOrUpdate", method = RequestMethod.POST)
    @ResponseBody
    public CommonResponse<SmallPlanDetailVO> saveOrUpdate(@ApiParam(name="saveOrUpdateVO", required=true) @RequestBody SmallPlanDetailVO saveOrUpdateVO) {
    	SmallPlanDetailEntity entity = BeanMapper.map(saveOrUpdateVO, SmallPlanDetailEntity.class);
    	if(entity.getId() == null || entity.getId() == 0){
            BillCodeParam billCodeParam = BillCodeParam.build(BILL_CODE,InvocationInfoProxy.getTenantid(),saveOrUpdateVO);
            CommonResponse<String> billCode = billCodeApi.generateBillCode(billCodeParam);
            if(billCode.isSuccess()) {
            }else{
                throw new BusinessException("网络异常， 编码生成失败， 请稍后再试");
            }
        }
    	service.saveOrUpdate(entity, false);
    	SmallPlanDetailVO vo = BeanMapper.map(entity, SmallPlanDetailVO.class);
    	return CommonResponse.success("保存或修改单据成功！",vo);
    }


    @ApiOperation("查询详情")
    @RequestMapping(value = "/queryDetail", method = RequestMethod.GET)
    @ResponseBody
    public CommonResponse<SmallPlanDetailVO> queryDetail(@RequestParam Long id) {
    	SmallPlanDetailEntity entity = service.selectById(id);
    	SmallPlanDetailVO vo = BeanMapper.map(entity, SmallPlanDetailVO.class);
        return CommonResponse.success("查询详情数据成功！",vo);
    }


    @ApiOperation("批量删除单据")
    @RequestMapping(value = "/delete", method = RequestMethod.POST)
    @ResponseBody
    public CommonResponse<String> delete(@RequestBody List<SmallPlanDetailVO> vos) {
        if(ListUtil.isNotEmpty(vos)){
            for (SmallPlanDetailVO vo : vos) {
                // 参数是单据类型编码字符串 根据需求是否打开下面代码
                /* CommonResponse<String> resp = billTypeApi.checkQuote("billTypeCode", vo.getId());
                if(!resp.isSuccess()){
                    return CommonResponse.error("删除失败！"+resp.getMsg());
                }*/
            }
        }
        service.removeByIds(vos.stream().map(SmallPlanDetailVO::getId).collect(Collectors.toList()),true);
        return CommonResponse.success("删除成功！");
    }


    @ApiOperation("查询列表")
    @RequestMapping(value = "/queryList", method = RequestMethod.POST)
    @ResponseBody
    public CommonResponse<IPage<SmallPlanDetailVO>> queryList(@RequestBody QueryParam param) {
        /** 模糊搜索配置字段示例 */
        List<String> fuzzyFields = param.getFuzzyFields();
        /** 租户隔离 */
        param.getParams().put("tenantId", new Parameter(QueryParam.EQ, InvocationInfoProxy.getTenantid()));

        /** 数据隔离 本下 没有组织orgId的删除下面代码-------------开始 */
        UserContext userContextCache =sessionManager.getUserContext();
        //当前应用有权限的根orgId，以逗号分割，可据此查询其本下数据，需判空
        String authOrgIds = userContextCache.getAuthOrgIds();
        List<OrgVO> orgVOList = null;
        if(StringUtils.isNotBlank(authOrgIds)){//移动端查询
            orgVOList = (List<OrgVO>) getRespData(iOrgApi.findChildrenByParentIds(Arrays.stream(authOrgIds.split(",")).map(Long::parseLong).collect(Collectors.toList())), true, "查询失败，获取当前本下组织信息失败。");
        }else {//pc端查询
            orgVOList = (List<OrgVO>) getRespData(iOrgApi.findChildrenByParentId(InvocationInfoProxy.getOrgId()), true, "查询失败，获取当前本下组织信息失败。");
        }
        //普通组织 id
        List<Long> commonOrgIds = new ArrayList<>();
        //项目部 id
        List<Long> departmentIds = new ArrayList<>();
        orgVOList.stream().forEach(org -> {
            if(5 == org.getOrgType()) {
                //项目部
                departmentIds.add(org.getId());
            } else {
                //普通组织
                commonOrgIds.add(org.getId());
            }
        });
        if(CollectionUtils.isNotEmpty(commonOrgIds)) {
            /** 要求主表有orgId字段，保存单据所属组织 */
            param.getParams().put("orgId", new Parameter(QueryParam.IN, commonOrgIds));
        } else if(CollectionUtils.isNotEmpty(departmentIds)) {
            /** 要求主表有projectDepartmentId字段，保存单据所属项目部 */
            param.getParams().put("projectDepartmentId", new Parameter(QueryParam.IN, departmentIds));
        }
        /** 数据隔离 本下 没有组织orgId的删除上面代码-------------结束！！！ */

        IPage<SmallPlanDetailEntity> page = service.queryPage(param,false);
        IPage<SmallPlanDetailVO> pageData = new Page<>(page.getCurrent(), page.getSize(), page.getTotal());
  		pageData.setRecords(BeanMapper.mapList(page.getRecords(), SmallPlanDetailVO.class));

        return CommonResponse.success("查询列表数据成功！",pageData);
    }

    /**
     * 获取RPC数据
     * resp 返回值
     * isMustSuc 是否必须成功
     * errMsg 失败提示
     */
    private Object getRespData(CommonResponse<?> resp, boolean isMustSuc, String errMsg) {
        if(isMustSuc && !resp.isSuccess()) {
            throw new BusinessException(StringUtils.isNoneBlank(errMsg) ? errMsg : "调用Rpc服务失败");
        }
        return resp.getData();
    }


    @ApiOperation("导出")
    @RequestMapping(value = "/excelExport", method = RequestMethod.POST)
    @ResponseBody
    public void excelExport(@RequestBody QueryParam param, HttpServletResponse response) {
        /** 模糊搜索配置字段示例 */
        List<String> fuzzyFields = param.getFuzzyFields();
        param.getParams().put("tenant_id",new Parameter(QueryParam.EQ,InvocationInfoProxy.getTenantid()));
        param.setPageIndex(1);
        param.setPageSize(-1);
        /** 数据隔离 本下 没有组织orgId的删除下面代码 */
        param.getParams().put("orgId",new Parameter(QueryParam.IN,iOrgApi.findChildrenByParentId(InvocationInfoProxy.getOrgId()).getData().stream().map(OrgVO::getId).collect(Collectors.toList())));
        List<SmallPlanDetailEntity> list = service.queryList(param);
        //todo:字段翻译等等
        Map<String, Object> beans = new HashMap<>();
        beans.put("records", list);
        ExcelExport.getInstance().export("SmallPlanDetail-export.xlsx", beans, response);
    }


    /**
     *
     * @param pageNumber
     * @param pageSize
     * @param searchText
     * @return
     */
    @RequestMapping(value = "/refSmallPlanDetailData", method = RequestMethod.GET)
    @ResponseBody
    public CommonResponse<JSONObject> refSmallPlanDetailData(@RequestParam(defaultValue = "1") Integer pageNumber,
                                                                     @RequestParam(defaultValue = "10") Integer pageSize,
                                                                     @RequestParam(value = "searchText", required = false) String searchText,
                                                                     @RequestParam(value = "condition", required = false) String condition) {

        QueryParam queryParam = new QueryParam();
        queryParam.setPageIndex(pageNumber);
        queryParam.setPageSize(pageSize);
        queryParam.setSearchText(searchText);
        /** 模糊搜索配置字段示例 */
        queryParam.getFuzzyFields().add("materialCategoryName");
        queryParam.getFuzzyFields().add("materialName");
        queryParam.getFuzzyFields().add("materialCode");
        Long projectId = null;
        if (StringUtils.isNotEmpty(condition)) {
            Map<String, Object> conditionMap = JSONObject.parseObject(condition, Map.class);
            if (null != conditionMap.get("projectId")) {
                projectId = Long.valueOf(conditionMap.get("projectId").toString());
            }
        }

        Page<MonthPlanDetailEntity> page = new Page<>((long) queryParam.getPageIndex(), (long) queryParam.getPageSize());
        QueryWrapper wrapper = changeToQueryWrapper(queryParam);
        List<SmallPlanDetailEntity> list = service.getQueryPage(page, wrapper,projectId);

        //获取项目下物资明细验收量
        LambdaQueryWrapper<CheckEntity> lambdaCheck = Wrappers.<CheckEntity>lambdaQuery();
        lambdaCheck.eq(CheckEntity::getProjectId, projectId);
        List<CheckEntity> checkEntities = checkService.list(lambdaCheck);

        List<Long> ids = null;
        Map<Long, BigDecimal> numInMap = new HashMap<>();
        if (CollectionUtils.isNotEmpty(checkEntities)) {
            ids = checkEntities.stream().map(CheckEntity::getId).collect(Collectors.toList());
            LambdaQueryWrapper<CheckDetailEntity> lambdaCheckDetail = Wrappers.<CheckDetailEntity>lambdaQuery();
            lambdaCheckDetail.in(CheckDetailEntity::getCheckId, ids);
            List<CheckDetailEntity> checkDetailEntities = checkDetailService.list(lambdaCheckDetail);
            if (CollectionUtils.isNotEmpty(checkDetailEntities)){
                numInMap = checkDetailEntities.stream().filter(s -> s.getCheckNum() != null).collect(Collectors.groupingBy(CheckDetailEntity::getMaterialId,
                        Collectors.collectingAndThen(Collectors.toList(), m -> m.stream().map(a -> a.getCheckNum()).reduce(BigDecimal.ZERO, BigDecimal::add))));
            }
        }

        if(CollectionUtils.isNotEmpty(list)){
            for (SmallPlanDetailEntity smallPlanDetailEntity : list){

                //计算计划剩余量
                if (numInMap.containsKey(smallPlanDetailEntity.getMaterialId())){
                    smallPlanDetailEntity.setPlanSurplusNum(ComputeUtil.safeSub(smallPlanDetailEntity.getPlanNum(),numInMap.get(smallPlanDetailEntity.getMaterialId())));
                }else {
                    smallPlanDetailEntity.setPlanSurplusNum(smallPlanDetailEntity.getPlanNum());
                }
            }
        }

        JSONObject res = new JSONObject();
        res.put("records", list);
        res.put("total", page.getTotal());
        res.put("current", page.getCurrent());
        res.put("size", page.getSize());
        res.put("pages", page.getPages());
        return CommonResponse.success("查询列表数据成功！", res);
    }
}
