package com.ejianc.wzxt.plan.service.impl;

import com.baomidou.mybatisplus.core.conditions.query.LambdaQueryWrapper;
import com.baomidou.mybatisplus.core.toolkit.CollectionUtils;
import com.baomidou.mybatisplus.core.toolkit.Wrappers;
import com.ejianc.foundation.orgcenter.vo.OrgVO;
import com.ejianc.framework.core.util.ComputeUtil;
import com.ejianc.wzxt.check.bean.CheckDetailEntity;
import com.ejianc.wzxt.plan.bean.*;
import com.ejianc.wzxt.plan.bean.MonthPlanEntity;
import com.ejianc.wzxt.plan.service.IMasterPlanDetailService;
import com.ejianc.wzxt.plan.service.IMasterPlanService;
import com.ejianc.wzxt.plan.service.IMonthPlanDetailService;
import com.ejianc.wzxt.plan.service.IMonthPlanService;
import com.ejianc.wzxt.plan.vo.MonthPlanVO;
import org.springframework.stereotype.Service;
import com.ejianc.foundation.support.api.IBillTypeApi;
import com.ejianc.framework.core.response.CommonResponse;
import com.ejianc.framework.skeleton.billState.service.ICommonBusinessService;
import org.springframework.beans.factory.annotation.Autowired;

import java.math.BigDecimal;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;

@Service("monthPlan") 
public class MonthPlanBpmServiceImpl implements ICommonBusinessService {

    @Autowired
    private IBillTypeApi billTypeApi;

	@Autowired
	private IMonthPlanService monthPlanService;
	@Autowired
	private IMasterPlanService masterPlanService;
	@Autowired
	private IMasterPlanDetailService masterPlanDetailService;
	@Autowired
	private IMonthPlanDetailService monthPlanDetailService;


	/**
	 * 提交前回调
	 * 
	 * @param billId
	 * @param state
	 * @return
	 */
	@Override
	public CommonResponse<String> beforeSubmitProcessor(Long billId, Integer state, String billTypeCode) {
		//TODO
		return CommonResponse.success();
	};

	/**
	 * 提交完回调
	 *
	 * @param
	 * @return
	 */
	@Override
	public CommonResponse<String> afterSubmitProcessor(Long billId, Integer state, String billTypeCode){
		//TODO
		return CommonResponse.success();
	}

	/**
	 * 有审批流的撤回前回调
	 *
	 * @param billId
	 * @param state
	 * @return
	 */
	@Override
	public CommonResponse<String> beforeHasBpmBack(Long billId, Integer state, String billTypeCode) {

		return CommonResponse.success();
	};

	/**
	 * 有审批流的撤回后回调
	 *
	 * @param
	 * @return
	 */
	@Override
	public CommonResponse<String> afterHasBpmBack(Long billId, Integer state, String billTypeCode){
		return CommonResponse.success();
	};

	/**
	 * 审批节点审批中时节点审批前回调
	 *
	 * @param billId
	 * @param state
	 * @return
	 */
	@Override
	public CommonResponse<String> beforeInApprovalBack(Long billId, Integer state, String billTypeCode, String sign) {
		return CommonResponse.success();
	};

	/**
	 * 终审审核前回调
	 * 
	 * @param billId
	 * @param state
	 * @return
	 */
	@Override
	public CommonResponse<String> beforeApprovalProcessor(Long billId, Integer state, String billTypeCode) {
		//TODO
		return CommonResponse.success();
	}

	/**
	 * 终审审核完回调
	 * 
	 * @param
	 * @return
	 */
	@Override
	public CommonResponse<String> afterApprovalProcessor(Long billId, Integer state, String billTypeCode) {
		//TODO


		//回写总计中的月计划量,释放上月的月计划量
		MonthPlanEntity monthPlanEntity = monthPlanService.selectById(billId);
		LambdaQueryWrapper<MonthPlanEntity> lambda = Wrappers.<MonthPlanEntity>lambdaQuery();
		lambda.eq(MonthPlanEntity::getProjectId, monthPlanEntity.getProjectId());
		lambda.in(MonthPlanEntity::getBillState, 1,3);
		lambda.notIn(MonthPlanEntity::getId, billId);
		List<MonthPlanEntity> monthPlanEntities = monthPlanService.list(lambda);
//		BigDecimal orderNum = BigDecimal.ZERO;
//		BigDecimal selfCheckNum = BigDecimal.ZERO;
		Map<Long, BigDecimal> orderNumMap = new HashMap<>();
		Map<Long, BigDecimal> selfCheckNumMap = new HashMap<>();

		if (CollectionUtils.isNotEmpty(monthPlanEntities)){
			List<Long> ids = monthPlanEntities.stream().map(MonthPlanEntity::getId).collect(Collectors.toList());

			LambdaQueryWrapper<MonthPlanDetailEntity> lambdaDetail = Wrappers.<MonthPlanDetailEntity>lambdaQuery();
			lambdaDetail.in(MonthPlanDetailEntity::getMaterialMonthPlanId, ids);
			List<MonthPlanDetailEntity> monthPlanDetailEntities = monthPlanDetailService.list(lambdaDetail);
			if (CollectionUtils.isNotEmpty(monthPlanDetailEntities)){
				orderNumMap = monthPlanDetailEntities.stream().filter(s -> s.getOrderNum() != null).collect(Collectors.groupingBy(MonthPlanDetailEntity::getMaterialId,
						Collectors.collectingAndThen(Collectors.toList(), m -> m.stream().map(a -> a.getOrderNum()).reduce(BigDecimal.ZERO, BigDecimal::add))));
				selfCheckNumMap = monthPlanDetailEntities.stream().filter(s -> s.getSelfCheckNum() != null).collect(Collectors.groupingBy(MonthPlanDetailEntity::getMaterialId,
						Collectors.collectingAndThen(Collectors.toList(), m -> m.stream().map(a -> a.getSelfCheckNum()).reduce(BigDecimal.ZERO, BigDecimal::add))));
			}
		}

		//本期月计划量
		Map<Long, BigDecimal> planMonthNumMap = new HashMap<>();
		List<MonthPlanDetailEntity> monthPlanDetailList = monthPlanEntity.getMonthPlanDetailList();
		if (CollectionUtils.isNotEmpty(monthPlanDetailList)){
			planMonthNumMap = monthPlanDetailList.stream().filter(s -> s.getPlanMonthNum() != null && s.getChangeType() != 2).collect(Collectors.groupingBy(MonthPlanDetailEntity::getMaterialId,
					Collectors.collectingAndThen(Collectors.toList(), m -> m.stream().map(a -> a.getPlanMonthNum()).reduce(BigDecimal.ZERO, BigDecimal::add))));
		}

		//回写总计划
		LambdaQueryWrapper<MasterPlanEntity> lambdaMaster = Wrappers.<MasterPlanEntity>lambdaQuery();
		lambdaMaster.eq(MasterPlanEntity::getProjectId, monthPlanEntity.getProjectId());
		lambdaMaster.in(MasterPlanEntity::getBillState, 1,3);
		MasterPlanEntity masterPlanEntity = masterPlanService.getOne(lambdaMaster);
		if (masterPlanEntity != null){
			LambdaQueryWrapper<MasterPlanDetailEntity> lambdaMasterDetail = Wrappers.<MasterPlanDetailEntity>lambdaQuery();
			lambdaMasterDetail.in(MasterPlanDetailEntity::getMaterialMasterPlanId, masterPlanEntity.getId());
			List<MasterPlanDetailEntity> masterPlanDetailEntities = masterPlanDetailService.list(lambdaMasterDetail);
			if (CollectionUtils.isNotEmpty(masterPlanDetailEntities)){
				for (MasterPlanDetailEntity masterPlanDetailEntity : masterPlanDetailEntities){
					BigDecimal planMonthNum = BigDecimal.ZERO;
					if (orderNumMap.containsKey(masterPlanDetailEntity.getMaterialId())){
						BigDecimal orderNum = orderNumMap.get(masterPlanDetailEntity.getMaterialId());
						planMonthNum = ComputeUtil.safeAdd(planMonthNum, orderNum);
					}
					if (orderNumMap.containsKey(masterPlanDetailEntity.getMaterialId())){
						BigDecimal selfCheckNum = selfCheckNumMap.get(masterPlanDetailEntity.getMaterialId());
						planMonthNum = ComputeUtil.safeAdd(planMonthNum, selfCheckNum);
					}
					if (planMonthNumMap.containsKey(masterPlanDetailEntity.getMaterialId())){
						BigDecimal planMonthNumNum = planMonthNumMap.get(masterPlanDetailEntity.getMaterialId());
						planMonthNum = ComputeUtil.safeAdd(planMonthNum, planMonthNumNum);
					}
					masterPlanDetailEntity.setPlanMonthNum(planMonthNum);
				}
				masterPlanDetailService.saveOrUpdateBatch(masterPlanDetailEntities);

			}
		}

		return CommonResponse.success();
	}

	
	/**
	 * 弃审前事件回调
	 *
	 * @param billId
	 * @param state
	 * @return
	 */
	@Override
	public CommonResponse<String> beforeAbstainingProcessor(Long billId, Integer state, String billTypeCode) {




		//有计划不允许撤回

		MonthPlanEntity monthPlanEntity = monthPlanService.selectById(billId);

		if(monthPlanEntity!=null){
			if(monthPlanEntity.getChangeState() == MonthPlanVO.PLAN_CHANGE_STATE_CHANGING){
				return CommonResponse.error("变更中单据无法撤回");
			}
			if(monthPlanEntity.getChangeState() == MonthPlanVO.PLAN_CHANGE_STATE_CHANGED){
				return CommonResponse.error("已变更单据无法撤回");
			}
		}

		LambdaQueryWrapper<MonthPlanEntity> lambda = Wrappers.<MonthPlanEntity>lambdaQuery();
		lambda.eq(MonthPlanEntity::getProjectId, monthPlanEntity.getProjectId());
		List<MonthPlanEntity> monthPlanEntities = monthPlanService.list(lambda);
		if (CollectionUtils.isNotEmpty(monthPlanEntities)){
			return CommonResponse.error("已有月计划数据,不能撤回!");
		}
		return CommonResponse.success();
	}

	/**
	 * 弃审后事件回调
	 * 
	 * @param billId
	 * @param state
	 * @return
	 */
	@Override
	public CommonResponse<String> afterAbstainingProcessor(Long billId, Integer state, String billTypeCode) {
		//TODO
		// 参数是单据类型编码字符串 根据需求是否打开下面代码
        /**CommonResponse<String> resp = billTypeApi.checkQuote(billTypeCode, billId);
        if(!resp.isSuccess()){
            return CommonResponse.error("无法撤回！"+resp.getMsg());
        }*/
		return CommonResponse.success();
	}

}
