package com.ejianc.wzxt.plan.service.impl;

import com.baomidou.mybatisplus.core.conditions.query.LambdaQueryWrapper;
import com.baomidou.mybatisplus.core.toolkit.Wrappers;
import com.ejianc.framework.core.kit.mapper.BeanMapper;
import com.ejianc.framework.core.response.Parameter;
import com.ejianc.framework.core.response.QueryParam;
import com.ejianc.framework.skeleton.template.BaseServiceImpl;
import com.ejianc.wzxt.plan.bean.MonthPlanChangeHisEntity;
import com.ejianc.wzxt.plan.bean.MonthPlanDetailChangeHisEntity;
import com.ejianc.wzxt.plan.enums.ChangeTypeEnum;
import com.ejianc.wzxt.plan.mapper.MonthPlanChangeHisMapper;
import com.ejianc.wzxt.plan.service.IMonthPlanChangeHisService;
import com.ejianc.wzxt.plan.service.IMonthPlanDetailChangeHisService;
import com.ejianc.wzxt.plan.vo.MonthPlanChangeHisVO;
import com.ejianc.wzxt.plan.vo.MonthPlanDetailChangeHisVO;
import org.apache.commons.collections.CollectionUtils;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;

import java.util.ArrayList;
import java.util.List;

/**
 * 材料月计划历史-主表
 * 
 * @author generator
 * 
 */
@Service("monthPlanChangeHisService")
public class MonthPlanChangeHisServiceImpl extends BaseServiceImpl<MonthPlanChangeHisMapper, MonthPlanChangeHisEntity> implements IMonthPlanChangeHisService{
    @Autowired
    private IMonthPlanDetailChangeHisService planDetailChangeHisService;
    @Override
    public MonthPlanChangeHisVO queryDetail(Long id) {
        LambdaQueryWrapper<MonthPlanChangeHisEntity> lambda = Wrappers.<MonthPlanChangeHisEntity>lambdaQuery();
        lambda.eq(MonthPlanChangeHisEntity::getChangePlanId, id);
        MonthPlanChangeHisEntity one = this.getOne(lambda);
        MonthPlanChangeHisVO planChangeHisVO = BeanMapper.map(one, MonthPlanChangeHisVO.class);
        QueryParam queryParam = new QueryParam();
        queryParam.getParams().put("materialMonthPlanId", new Parameter(QueryParam.EQ, one.getId()));
//        queryParam.getOrderMap().put("treeIndex", "asc");
        List<MonthPlanDetailChangeHisEntity> detailEntityListDb = planDetailChangeHisService.queryList(queryParam, false);
        List<MonthPlanDetailChangeHisEntity> detailEntityList = new ArrayList<>();
        if(CollectionUtils.isNotEmpty(detailEntityListDb)) {
            detailEntityListDb.forEach(entity ->{
                if(null == entity.getChangeType() || ChangeTypeEnum.中止项.getCode() != entity.getChangeType()){
                    detailEntityList.add(entity);
                }
            });
        }
        if(CollectionUtils.isNotEmpty(detailEntityList)) {
            for(MonthPlanDetailChangeHisEntity cdEntity : detailEntityList){
                cdEntity.setRowState("add");
            }
            List<MonthPlanDetailChangeHisVO> resultMapList = BeanMapper.mapList(detailEntityList, MonthPlanDetailChangeHisVO.class);
            planChangeHisVO.setMonthPlanDetailList(resultMapList);
        } else {
            planChangeHisVO.setMonthPlanDetailList(BeanMapper.mapList(detailEntityList, MonthPlanDetailChangeHisVO.class));
        }
        return planChangeHisVO;
    }
}
