package com.ejianc.wzxt.plan.service.impl;

import com.alibaba.fastjson.JSONObject;
import com.baomidou.mybatisplus.core.conditions.query.LambdaQueryWrapper;
import com.baomidou.mybatisplus.core.toolkit.Wrappers;
import com.ejianc.foundation.costmanage.vo.ResponsepartdetailApiVO;
import com.ejianc.foundation.orgcenter.vo.OrgVO;
import com.ejianc.foundation.support.api.IBillCodeApi;
import com.ejianc.foundation.support.api.IParamConfigApi;
import com.ejianc.foundation.support.vo.BillCodeParam;
import com.ejianc.foundation.support.vo.BillParamVO;
import com.ejianc.foundation.support.vo.ParamsCheckDsVO;
import com.ejianc.foundation.support.vo.ParamsCheckVO;
import com.ejianc.framework.core.context.InvocationInfoProxy;
import com.ejianc.framework.core.exception.BusinessException;
import com.ejianc.framework.core.kit.mapper.BeanMapper;
import com.ejianc.framework.core.response.BillStateEnum;
import com.ejianc.framework.core.response.CommonResponse;
import com.ejianc.framework.core.response.Parameter;
import com.ejianc.framework.core.response.QueryParam;
import com.ejianc.framework.core.util.ComputeUtil;
import com.ejianc.support.idworker.util.IdWorker;
import com.ejianc.wzxt.check.vo.CheckDetailVO;
import com.ejianc.wzxt.plan.bean.*;
import com.ejianc.wzxt.plan.enums.ChangeTypeEnum;
import com.ejianc.wzxt.plan.service.*;
import com.ejianc.wzxt.plan.vo.*;
import org.apache.commons.collections.CollectionUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;
import com.ejianc.framework.skeleton.template.BaseServiceImpl;

import com.ejianc.wzxt.plan.mapper.MonthPlanMapper;
import com.ejianc.wzxt.plan.bean.MonthPlanEntity;

import java.math.BigDecimal;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.function.Function;
import java.util.stream.Collectors;

/**
 * 材料月计划-主表
 * 
 * @author generator
 * 
 */
@Service("monthPlanService")
public class MonthPlanServiceImpl extends BaseServiceImpl<MonthPlanMapper, MonthPlanEntity> implements IMonthPlanService{
    private static final String BILL_CODE = "MONTHPLAN";
    @Autowired
    private IBillCodeApi billCodeApi;
    @Autowired
    private IMonthPlanDetailService monthPlanDetailService;
    @Autowired
    private IMonthPlanChangeDetailService monthPlanChangeDetailService;
    @Autowired
    private IMonthPlanChangeService monthPlanChangeService;

    @Autowired
    private MonthPlanMapper monthPlanMapper;

    private static final String MASTER_CHECK_CODE = "P-40x8720297";//数量控制
    @Autowired
    private IMasterPlanService masterPlanService;
    @Autowired
    private IMasterPlanDetailService masterPlanDetailService;




    private Logger logger = LoggerFactory.getLogger(this.getClass());

    @Autowired
    private IParamConfigApi paramConfigApi;




    @Override
    public MonthPlanVO saveOrUpdate(MonthPlanVO saveOrUpdateVO) {

        MonthPlanEntity entity = BeanMapper.map(saveOrUpdateVO, MonthPlanEntity.class);
        if(entity.getId() == null || entity.getId() == 0){
            BillCodeParam billCodeParam = BillCodeParam.build(BILL_CODE,InvocationInfoProxy.getTenantid(),saveOrUpdateVO);
            CommonResponse<String> billCode = billCodeApi.generateBillCode(billCodeParam);
            if(billCode.isSuccess()) {
                entity.setPlanCode(billCode.getData());
            }else{
                throw new BusinessException("网络异常， 编码生成失败， 请稍后再试");
            }
        }

        if(null == saveOrUpdateVO.getId()) {
            entity.setId(IdWorker.getId());
            //设置为未变更
            entity.setChangeState(0);
            //设置为自由态
            entity.setBillState(BillStateEnum.UNCOMMITED_STATE.getBillStateCode());
            //变更版本号
            entity.setChangeVersion(1);
            //设置编制人
//            saveEntity.setCreateUserName(userContext.getUserName());
        }
        List<MonthPlanDetailEntity> detailEntities = entity.getMonthPlanDetailList();
        if (CollectionUtils.isNotEmpty(detailEntities)) {
            for (MonthPlanDetailEntity monthPlanDetailEntity : detailEntities) {
                monthPlanDetailEntity.setChangeType(ChangeTypeEnum.未变更.getCode());
            }
        }

        super.saveOrUpdate(entity, false);
        MonthPlanVO vo = BeanMapper.map(entity, MonthPlanVO.class);
        return vo;
    }

    @Override
    public MonthPlanVO queryDetail(Long id) {

        MonthPlanEntity monthPlanEntity = super.selectById(id);
        MonthPlanVO monthPlanVO =  BeanMapper.map(monthPlanEntity, MonthPlanVO.class);
        QueryParam queryParam = new QueryParam();
        queryParam.getParams().put("materialMonthPlanId", new Parameter(QueryParam.EQ, id));
//        queryParam.getOrderMap().put("treeIndex", "asc");
        List<MonthPlanDetailEntity> detailEntityListDb = monthPlanDetailService.queryList(queryParam, false);
        List<MonthPlanDetailEntity> detailEntityList = new ArrayList<>();
        if(CollectionUtils.isNotEmpty(detailEntityListDb)) {
            detailEntityListDb.forEach(entity ->{
                if(null == entity.getChangeType() || ChangeTypeEnum.中止项.getCode() != entity.getChangeType()){
                    detailEntityList.add(entity);
                }
            });
        }
        //设置最新的总计划量
        LambdaQueryWrapper<MasterPlanEntity> lambdaMaster = Wrappers.<MasterPlanEntity>lambdaQuery();
        lambdaMaster.eq(MasterPlanEntity::getProjectId,monthPlanEntity.getProjectId());
        lambdaMaster.in(MasterPlanEntity::getBillState,1,3);
        MasterPlanEntity masterPlanEntity = masterPlanService.getOne(lambdaMaster);
        Map<Long, MasterPlanDetailEntity> map = new HashMap<>();
        if (masterPlanEntity != null){
            LambdaQueryWrapper<MasterPlanDetailEntity> lambdaMasterDetail = Wrappers.<MasterPlanDetailEntity>lambdaQuery();
            lambdaMasterDetail.eq(MasterPlanDetailEntity::getMaterialMasterPlanId,masterPlanEntity.getId());
            List<MasterPlanDetailEntity> masterPlanDetailEntities = masterPlanDetailService.list(lambdaMasterDetail);
            if(CollectionUtils.isNotEmpty(masterPlanDetailEntities)){
                map = masterPlanDetailEntities.stream().collect(Collectors.toMap(MasterPlanDetailEntity::getMaterialId, Function.identity(), (key1, key2) -> key1));
            }
        }

        if(CollectionUtils.isNotEmpty(detailEntityList)) {
            for(MonthPlanDetailEntity cdEntity : detailEntityList){
                cdEntity.setRowState("edit");
                if (map.containsKey(cdEntity.getMaterialId())){
                    MasterPlanDetailEntity masterPlanDetailEntity = map.get(cdEntity.getMaterialId());
                    cdEntity.setPlanTotalNum(masterPlanDetailEntity.getPlanTotalNum());
                    cdEntity.setPlanTotalSurplusNum(ComputeUtil.safeSub(masterPlanDetailEntity.getPlanTotalNum(),masterPlanDetailEntity.getPlanMonthNum()));
                }
            }
            List<MonthPlanDetailVO> resultMapList = BeanMapper.mapList(detailEntityList, MonthPlanDetailVO.class);
            monthPlanVO.setMonthPlanDetailList(resultMapList);

        } else {
            monthPlanVO.setMonthPlanDetailList(BeanMapper.mapList(detailEntityList, MonthPlanDetailVO.class));
        }

        if(null != monthPlanEntity.getChangeVersion() && monthPlanEntity.getChangeVersion() > 0){
            monthPlanVO.setMonthPlanChangeHisList(monthPlanChangeService.queryDetailRecord(monthPlanEntity.getId()));
        }
        return monthPlanVO;

    }

    @Override
    public List<MonthPlanContrastVO> getContrastInfo(Long materialMonthPlanId, Long oldMaterialMonthPlanId) {
        return  monthPlanMapper.getContrastInfo(materialMonthPlanId,oldMaterialMonthPlanId);
    }

    private List<ParamsCheckVO> masterCtrlNum(MonthPlanVO masterPlanVO) {
        // 三种控制方式：不控制，提醒，无法保存 (默认为提醒)
        String[] paramsArray = {"none", "warn", "alert"};
        List<ParamsCheckVO> paramsCheckVOList = new ArrayList<>();
        LambdaQueryWrapper<MasterPlanEntity> queryWrapper = Wrappers.lambdaQuery();
        queryWrapper.eq(MasterPlanEntity::getProjectId, masterPlanVO.getProjectId());
        queryWrapper.in(MasterPlanEntity::getBillState, BillStateEnum.PASSED_STATE.getBillStateCode(), BillStateEnum.COMMITED_STATE.getBillStateCode());
        queryWrapper.last("limit 1");
        MasterPlanEntity masterPlanEntity = masterPlanService.getOne(queryWrapper, false);
        if(null != masterPlanEntity){
            MasterPlanEntity planEntity = masterPlanService.selectById(masterPlanEntity.getId());
            Map<Long, MasterPlanDetailEntity> map = planEntity.getMasterPlanDetailList().stream().collect(Collectors.toMap(MasterPlanDetailEntity::getMaterialId, Function.identity(), (k1, k2) -> k1));
            CommonResponse<List<BillParamVO>> billParamByCode = paramConfigApi.getBillParamByCodeAndOrgId(MASTER_CHECK_CODE, masterPlanVO.getParentOrgId());
            if (billParamByCode.isSuccess() && null != billParamByCode.getData()) {
                List<BillParamVO> data = billParamByCode.getData();
                logger.info("清单量大于总控计划剩余量控制：" + JSONObject.toJSONString(data));
                if (CollectionUtils.isNotEmpty(data)) {
                    for (MonthPlanDetailVO detailVO : masterPlanVO.getMonthPlanDetailList()) {
                        BigDecimal planTotalNum = map.containsKey(detailVO.getMaterialId()) ? map.get(detailVO.getMaterialId()).getPlanTotalNum() : BigDecimal.ZERO;
                        BigDecimal planMonthNum = map.containsKey(detailVO.getMaterialId()) ? map.get(detailVO.getMaterialId()).getPlanMonthNum() : BigDecimal.ZERO;
                        for (BillParamVO datum : data) {
                            ParamsCheckVO paramsCheckVO = new ParamsCheckVO();
                            List<ParamsCheckDsVO> checkDsVOS = new ArrayList<>();
                            BigDecimal roleValue = datum.getRoleValue();//参数值
                            paramsCheckVO.setWarnType(paramsArray[datum.getControlType()]);
                            BigDecimal compareNum = ComputeUtil.safeSub(ComputeUtil.safeMultiply(planTotalNum, ComputeUtil.safeDiv(roleValue, BigDecimal.valueOf(100))),planMonthNum);
                            if (ComputeUtil.isGreaterThan(detailVO.getPlanMonthNum(), compareNum)) {
                                ParamsCheckDsVO paramsCheckDsVO = new ParamsCheckDsVO();
                                paramsCheckDsVO.setOrgName(datum.getOrgName());
                                paramsCheckDsVO.setWarnItem("清单量大于总控计划剩余量");
                                paramsCheckDsVO.setWarnName("清单量大于总控计划剩余量");
                                StringBuffer stringBuffer = new StringBuffer();
                                stringBuffer.append("清单编码[").append(detailVO.getMaterialCode()).append("]的月计划量:").append(detailVO.getPlanMonthNum().setScale(3, BigDecimal.ROUND_HALF_UP))
                                        .append("，总控计划剩余量:").append(compareNum.setScale(3, BigDecimal.ROUND_HALF_UP))
                                        .append("。超出量：").append(ComputeUtil.safeSub(detailVO.getPlanMonthNum(), compareNum).setScale(3, BigDecimal.ROUND_HALF_UP));
                                paramsCheckDsVO.setContent(stringBuffer.toString());
                                checkDsVOS.add(paramsCheckDsVO);
                            }
                            paramsCheckVO.setDataSource(checkDsVOS);
                            paramsCheckVOList.add(paramsCheckVO);
                        }
                    }
                }

            } else {
                logger.info(billParamByCode.getMsg());
                throw new BusinessException("获取控制参数失败");
            }
        }
        return paramsCheckVOList;
    }

    @Override
    public ParamsCheckVO checkParams(MonthPlanVO vo, ParamsCheckVO paramsCheckVO2) {


        List<ParamsCheckVO> paramsCheckVOS = new ArrayList<>();
        ParamsCheckVO paramsCheckVO = new ParamsCheckVO();
        paramsCheckVO.setWarnType("none");

        paramsCheckVOS.addAll(masterCtrlNum(vo));

        /*预警参数添加域*/
        Map<String, List<ParamsCheckDsVO>> map = new HashMap<>();
        String[] paramsArray = {"none", "warn", "alert"};
        if (CollectionUtils.isNotEmpty(paramsCheckVOS)) {
            for (ParamsCheckVO checkVO : paramsCheckVOS) {
                String warnType = checkVO.getWarnType();
                if (map.containsKey(warnType)) {
                    List<ParamsCheckDsVO> checkDsVOS = map.get(warnType);
                    checkDsVOS.addAll(checkVO.getDataSource());
                    map.put(warnType, checkDsVOS);
                } else {
                    map.put(warnType, checkVO.getDataSource());
                }
            }
        }
        for (String s : paramsArray) {
            if (map.containsKey(s)) {
                paramsCheckVO.setWarnType(s);
                paramsCheckVO.setDataSource(map.get(s));
                if (CollectionUtils.isEmpty(paramsCheckVO.getDataSource())) {
                    paramsCheckVO.setWarnType("none");
                } else {
                    return paramsCheckVO;
                }
            }
        }
        return paramsCheckVO;
    }

    @Override
    public List<MonthPlanDetailVO> getDeleteFlag(MonthPlanDetailQueryVO vo) {

        LambdaQueryWrapper<MonthPlanEntity> lambdaMonth = Wrappers.<MonthPlanEntity>lambdaQuery();
        lambdaMonth.in(MonthPlanEntity::getProjectId, vo.getProjectId());
        List<MonthPlanEntity> monthPlanEntities = super.list(lambdaMonth);
        Map<Long, BigDecimal> numMap = new HashMap<>();
        if (CollectionUtils.isNotEmpty(monthPlanEntities)){
            List<Long> ids = monthPlanEntities.stream().map(MonthPlanEntity::getId).collect(Collectors.toList());
            LambdaQueryWrapper<MonthPlanDetailEntity> lambdaDetail = Wrappers.<MonthPlanDetailEntity>lambdaQuery();
            lambdaDetail.in(MonthPlanDetailEntity::getMaterialMonthPlanId, ids);
            List<MonthPlanDetailEntity> monthPlanDetailEntities = monthPlanDetailService.list(lambdaDetail);
            numMap = monthPlanDetailEntities.stream().collect(Collectors.groupingBy(MonthPlanDetailEntity::getMaterialId,
                    Collectors.collectingAndThen(Collectors.toList(), m -> m.stream().map(a -> a.getPlanMonthNum()).reduce(BigDecimal.ZERO, BigDecimal::add))));
        }

        LambdaQueryWrapper<MonthPlanChangeEntity> lambdaMonthChange = Wrappers.<MonthPlanChangeEntity>lambdaQuery();
        lambdaMonthChange.in(MonthPlanChangeEntity::getProjectId, vo.getProjectId());
        lambdaMonthChange.notIn(MonthPlanChangeEntity::getBillState, 1,3);
        List<MonthPlanChangeEntity> monthPlanChangeEntities = monthPlanChangeService.list(lambdaMonthChange);
        Map<Long, BigDecimal> numChangeMap = new HashMap<>();
        if (CollectionUtils.isNotEmpty(monthPlanChangeEntities)){
            List<Long> ids = monthPlanChangeEntities.stream().map(MonthPlanChangeEntity::getId).collect(Collectors.toList());
            LambdaQueryWrapper<MonthPlanChangeDetailEntity> lambdaDetailChange = Wrappers.<MonthPlanChangeDetailEntity>lambdaQuery();
            lambdaDetailChange.in(MonthPlanChangeDetailEntity::getMaterialMonthPlanId, ids);
            List<MonthPlanChangeDetailEntity> monthPlanDetailChangeEntities = monthPlanChangeDetailService.list(lambdaDetailChange);
            numChangeMap = monthPlanDetailChangeEntities.stream().collect(Collectors.groupingBy(MonthPlanChangeDetailEntity::getMaterialId,
                    Collectors.collectingAndThen(Collectors.toList(), m -> m.stream().map(a -> a.getPlanMonthNum()).reduce(BigDecimal.ZERO, BigDecimal::add))));
        }

        for (MonthPlanDetailVO monthPlanDetailVO : vo.getMonthPlanDetailList()){
            if (numMap.containsKey(monthPlanDetailVO.getMaterialId()) || numChangeMap.containsKey(monthPlanDetailVO.getMaterialId())){
                monthPlanDetailVO.setDeleteFlag(0);
            }else {
                monthPlanDetailVO.setDeleteFlag(1);

            }

        }





        return null;
    }
}
