package com.ejianc.wzxt.supplier.controller;

import java.io.Serializable;

import com.ejianc.foundation.orgcenter.vo.OrgVO;
import com.ejianc.foundation.support.vo.BillCodeParam;
import com.ejianc.foundation.support.api.IBillCodeApi;
import com.ejianc.foundation.support.api.IBillTypeApi;
import com.ejianc.framework.core.exception.BusinessException;
import com.ejianc.framework.core.kit.time.DateFormatUtil;
import com.ejianc.framework.core.util.ExcelExport;
import com.ejianc.wzxt.supplier.bean.EvalSeasonScoreEntity;
import com.ejianc.wzxt.supplier.service.IEvalSeasonScoreService;
import com.ejianc.wzxt.supplier.vo.EvalSeasonScoreVO;
import org.apache.commons.lang3.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

import java.text.DateFormat;
import java.text.SimpleDateFormat;
import java.util.*;
import java.util.stream.Collectors;
import com.alibaba.fastjson.JSONObject;
import org.springframework.stereotype.Controller;
import org.springframework.web.bind.annotation.*;
import javax.servlet.http.HttpServletResponse;

import com.ejianc.foundation.orgcenter.api.IOrgApi;
import com.ejianc.framework.core.response.CommonResponse;
import org.springframework.beans.factory.annotation.Autowired;
import com.ejianc.framework.core.context.InvocationInfoProxy;
import com.ejianc.framework.core.kit.mapper.BeanMapper;
import com.ejianc.framework.core.kit.collection.ListUtil;
import com.ejianc.framework.auth.session.SessionManager;
import com.ejianc.framework.auth.session.UserContext;

import com.baomidou.mybatisplus.core.metadata.IPage;
import com.baomidou.mybatisplus.extension.plugins.pagination.Page;
import com.ejianc.framework.core.response.Parameter;
import com.ejianc.framework.core.response.QueryParam;

import com.ejianc.wzxt.supplier.bean.EvalSeasonEntity;
import com.ejianc.wzxt.supplier.service.IEvalSeasonService;
import com.ejianc.wzxt.supplier.vo.EvalSeasonVO;

/**
 * 供应商季度评价
 *
 * @author generator
 *
 */
@Controller
@RequestMapping("evalSeason")
public class EvalSeasonController implements Serializable {
	private static final long serialVersionUID = 1L;

    private Logger logger = LoggerFactory.getLogger(this.getClass());

    @Autowired
    private IBillTypeApi billTypeApi;
    @Autowired
    private IBillCodeApi billCodeApi;
    @Autowired
    private IOrgApi iOrgApi;

    private static final String BILL_CODE = "zjkj-wzxt-supplier-season-eval001";//此处需要根据实际修改
    private static final DateFormat sdf = new SimpleDateFormat("yyyy");

    @Autowired
    private IEvalSeasonService service;

    @Autowired
    private SessionManager sessionManager;
    @Autowired
    private IEvalSeasonScoreService scoreService;

    /**
     * @Description saveOrUpdate 新增或者修改
     */
    @RequestMapping(value = "/saveOrUpdate", method = RequestMethod.POST)
    @ResponseBody
    public CommonResponse<EvalSeasonVO> saveOrUpdate(@RequestBody EvalSeasonVO saveOrUpdateVO) {
        QueryParam queryParam = new QueryParam();
        queryParam.getParams().put("id", new Parameter(QueryParam.NE, saveOrUpdateVO.getId()));
        queryParam.getParams().put("period", new Parameter(QueryParam.EQ, saveOrUpdateVO.getPeriod()));
        queryParam.getParams().put("season", new Parameter(QueryParam.EQ, saveOrUpdateVO.getSeason()));
        queryParam.getParams().put("contractId", new Parameter(QueryParam.EQ, saveOrUpdateVO.getContractId()));
        List<EvalSeasonEntity> list = service.queryList(queryParam,false);
        if(ListUtil.isNotEmpty(list)){
            return CommonResponse.error("合同【"+saveOrUpdateVO.getContractName() +"】已存在【"+sdf.format(list.get(0).getPeriod())+"年"+list.get(0).getSeason()+"】的季度评价记录，单据编码是【"+list.get(0).getCode()+"】！");
        }
    	EvalSeasonEntity entity = BeanMapper.map(saveOrUpdateVO, EvalSeasonEntity.class);
    	if(entity.getId() == null || entity.getId() == 0){
            BillCodeParam billCodeParam = BillCodeParam.build(BILL_CODE,InvocationInfoProxy.getTenantid(),saveOrUpdateVO);
            CommonResponse<String> billCode = billCodeApi.generateBillCode(billCodeParam);
            if(billCode.isSuccess()) {
                entity.setCode(billCode.getData());//此处需要根据实际修改 删除本行或者下一行
            }else{
                throw new BusinessException("网络异常， 编码生成失败， 请稍后再试");
            }
        }
    	service.saveOrUpdate(entity, false);
    	EvalSeasonVO vo = BeanMapper.map(entity, EvalSeasonVO.class);
        queryParam = new QueryParam();
        queryParam.getParams().put("pid", new Parameter(QueryParam.EQ, entity.getId()));
        queryParam.getOrderMap().put("rowNum",QueryParam.ASC);
        List<EvalSeasonScoreEntity> scoreEntities = scoreService.queryList(queryParam,false);
        vo.setEvalSeasonScoreList(BeanMapper.mapList(scoreEntities, EvalSeasonScoreVO.class));
    	return CommonResponse.success("保存或修改单据成功！",vo);
    }

    /**
     * @Description queryDetail 查询详情
     * @param id
     */
    @RequestMapping(value = "/queryDetail", method = RequestMethod.GET)
    @ResponseBody
    public CommonResponse<EvalSeasonVO> queryDetail(Long id) {
    	EvalSeasonEntity entity = service.selectById(id);
    	EvalSeasonVO vo = BeanMapper.map(entity, EvalSeasonVO.class);
        QueryParam queryParam = new QueryParam();
        queryParam.getParams().put("pid", new Parameter(QueryParam.EQ, entity.getId()));
        queryParam.getOrderMap().put("rowNum",QueryParam.ASC);
        List<EvalSeasonScoreEntity> scoreEntities = scoreService.queryList(queryParam,false);
        vo.setEvalSeasonScoreList(BeanMapper.mapList(scoreEntities, EvalSeasonScoreVO.class));
        return CommonResponse.success("查询详情数据成功！",vo);
    }

    /**
     * @Description delete 批量删除单据
     * @Param [ids]
     */
    @RequestMapping(value = "/delete", method = RequestMethod.POST)
    @ResponseBody
    public CommonResponse<String> delete(@RequestBody List<EvalSeasonVO> vos) {
        service.removeByIds(vos.stream().map(EvalSeasonVO::getId).collect(Collectors.toList()),true);
        return CommonResponse.success("删除成功！");
    }

    /**
     * @Description queryList 查询列表
     * @param param
     * @Return com.ejianc.framework.core.response.CommonResponse<java.lang.String>
     */
    @RequestMapping(value = "/queryList", method = RequestMethod.POST)
    @ResponseBody
    public CommonResponse<IPage<EvalSeasonVO>> queryList(@RequestBody QueryParam param) {

        /** 模糊搜索配置字段示例 */
        List<String> fuzzyFields = param.getFuzzyFields();
        fuzzyFields.add("projectName");
        fuzzyFields.add("contractName");
        fuzzyFields.add("supplierName");
        fuzzyFields.add("orgName");
        /** 租户隔离 */
        param.getParams().put("tenantId", new Parameter(QueryParam.EQ, InvocationInfoProxy.getTenantid()));

        /** 数据隔离 本下 没有组织orgId的删除下面代码-------------开始 */
        UserContext userContextCache =sessionManager.getUserContext();
        //当前应用有权限的根orgId，以逗号分割，可据此查询其本下数据，需判空
        String authOrgIds = userContextCache.getAuthOrgIds();
        List<OrgVO> orgVOList = null;
        if(StringUtils.isNotBlank(authOrgIds)){//移动端查询
            orgVOList = (List<OrgVO>) getRespData(iOrgApi.findChildrenByParentIds(Arrays.stream(authOrgIds.split(",")).map(Long::parseLong).collect(Collectors.toList())), true, "查询失败，获取当前本下组织信息失败。");
        }else {//pc端查询
            orgVOList = (List<OrgVO>) getRespData(iOrgApi.findChildrenByParentId(InvocationInfoProxy.getOrgId()), true, "查询失败，获取当前本下组织信息失败。");
        }
        //普通组织 id
        List<Long> commonOrgIds = orgVOList.stream().map(OrgVO::getId).collect(Collectors.toList());
        param.getParams().put("projectOrgId", new Parameter(QueryParam.IN, commonOrgIds));
        /** 数据隔离 本下 没有组织orgId的删除上面代码-------------结束！！！ */

        IPage<EvalSeasonEntity> page = service.queryPage(param,false);
        IPage<EvalSeasonVO> pageData = new Page<>(page.getCurrent(), page.getSize(), page.getTotal());
  		pageData.setRecords(BeanMapper.mapList(page.getRecords(), EvalSeasonVO.class));

        return CommonResponse.success("查询列表数据成功！",pageData);
    }

    /**
     * 获取RPC数据
     * resp 返回值
     * isMustSuc 是否必须成功
     * errMsg 失败提示
     */
    private Object getRespData(CommonResponse<?> resp, boolean isMustSuc, String errMsg) {
        if(isMustSuc && !resp.isSuccess()) {
            throw new BusinessException(StringUtils.isNoneBlank(errMsg) ? errMsg : "调用Rpc服务失败");
        }
        return resp.getData();
    }


    /**
     * @Description 导出
     * @param param
     * @Return void
     */
    @RequestMapping(value = "/excelExport", method = RequestMethod.POST)
    @ResponseBody
    public void excelExport(@RequestBody QueryParam param, HttpServletResponse response) {
        /** 模糊搜索配置字段示例 */
        List<String> fuzzyFields = param.getFuzzyFields();
        param.getParams().put("tenant_id",new Parameter(QueryParam.EQ,InvocationInfoProxy.getTenantid()));
        fuzzyFields.add("projectName");
        fuzzyFields.add("supplierName");
        fuzzyFields.add("contractName");
        fuzzyFields.add("orgName");
        param.setPageIndex(1);
        param.setPageSize(-1);
        /** 数据隔离 本下 没有组织orgId的删除下面代码 */
        List<OrgVO> orgVOList = (List<OrgVO>) getRespData(iOrgApi.findChildrenByParentId(InvocationInfoProxy.getOrgId()), true, "查询失败，获取当前本下组织信息失败。");
        param.getParams().put("projectOrgId",new Parameter(QueryParam.IN,orgVOList.stream().map(OrgVO::getId).collect(Collectors.toList())));
        List<EvalSeasonEntity> list = service.queryList(param);
        //todo:字段翻译等等
        Map<String, Object> beans = new HashMap<>();
        beans.put("records", list);
        SimpleDateFormat timeFormat = new SimpleDateFormat(DateFormatUtil.PATTERN_DEFAULT_ON_SECOND);
        beans.put("dateFormat",timeFormat);
        SimpleDateFormat yearFormat = new SimpleDateFormat("yyyy");
        beans.put("yearFormat",yearFormat);
        ExcelExport.getInstance().exportWithTrans("EvalSeason-export.xlsx", beans, response);
    }

    /**
     * @Description 参照
     * @Return void
     */
    @RequestMapping(value = "/refEvalSeasonData", method = RequestMethod.GET)
    @ResponseBody
    public CommonResponse<IPage<EvalSeasonVO>> refEvalSeasonData(@RequestParam Integer pageNumber, @RequestParam Integer pageSize,
                                                                        String condition,
                                                                        String searchObject,
                                                                        String searchText) {
        QueryParam param = new QueryParam();
        param.setPageSize(pageSize);
        param.setPageIndex(pageNumber);
        param.setSearchText(searchText);
        param.setSearchObject(searchObject);
        /** 租户隔离 */
        param.getParams().put("tenantId", new Parameter(QueryParam.EQ, InvocationInfoProxy.getTenantid()));
        if(StringUtils.isNotEmpty(condition)){
            /** 处理condition */
            JSONObject _con = JSONObject.parseObject(condition);
        }

        IPage<EvalSeasonEntity> page = service.queryPage(param,false);
        IPage<EvalSeasonVO> pageData = new Page<>(page.getCurrent(), page.getSize(), page.getTotal());
        pageData.setRecords(BeanMapper.mapList(page.getRecords(), EvalSeasonVO.class));

        return CommonResponse.success("查询参照数据成功！",pageData);
     }
}
