package com.ejianc.wzxt.supplier.vo;

import java.util.Date;
import java.math.*;
import java.util.List;
import java.util.ArrayList;

import com.ejianc.framework.skeleton.refer.annotation.ReferDeserialTransfer;
import com.ejianc.framework.skeleton.refer.annotation.ReferSerialTransfer;
import com.ejianc.framework.skeleton.template.BaseVO;

import com.fasterxml.jackson.annotation.JsonFormat;

/**
 * 供应商月度评价
 * 
 * @author generator
 * 
 */
public class EvalMonthlyVO extends BaseVO {
    private static final long serialVersionUID = 1L;

    private Integer billState; // 单据状态
    private String code; // 单据编号
    private Long projectId; // 项目id
    private String projectName; // 项目名称
    private String projectCode; // 项目编码
    private Long orgId; // 组织id
    private String orgName; // 组织名称
    private Long projectOrgId; // 项目部组织id
    private String contractName; // 合同名称
    private Long contractId; // 合同id
    private Long supplierId; // 供应商id
    private String supplierName; // 供应商名称
    @JsonFormat(pattern = "yyyy-MM", timezone = "GMT+8")
    private Date period; // 评价周期
    private BigDecimal scoreTotal; // 评估总得分
    private String memo; // 备注
    private Long createUserId; // 编制人id

    private List<EvalMonthlyScoreVO> evalMonthlyScoreList = new ArrayList<>(); // 供应商月度评价履约评分表

    public Integer getBillState() {
        return billState;
    }

    public void setBillState(Integer billState) {
        this.billState = billState;
    }

    public String getCode() {
        return code;
    }

    public void setCode(String code) {
        this.code = code;
    }

    @ReferSerialTransfer(referCode = "ejc-zjkj-project")
    public Long getProjectId() {
        return projectId;
    }

    @ReferDeserialTransfer
    public void setProjectId(Long projectId) {
        this.projectId = projectId;
    }
    public String getProjectName() {
        return projectName;
    }

    public void setProjectName(String projectName) {
        this.projectName = projectName;
    }
    public String getProjectCode() {
        return projectCode;
    }

    public void setProjectCode(String projectCode) {
        this.projectCode = projectCode;
    }
    public Long getOrgId() {
        return orgId;
    }

    public void setOrgId(Long orgId) {
        this.orgId = orgId;
    }
    public String getOrgName() {
        return orgName;
    }

    public void setOrgName(String orgName) {
        this.orgName = orgName;
    }

    public Long getProjectOrgId() {
        return projectOrgId;
    }

    public void setProjectOrgId(Long projectOrgId) {
        this.projectOrgId = projectOrgId;
    }

    public String getContractName() {
        return contractName;
    }

    public void setContractName(String contractName) {
        this.contractName = contractName;
    }

    @ReferSerialTransfer(referCode = "ejc-zjkj-outcontract")
    public Long getContractId() {
        return contractId;
    }

    @ReferDeserialTransfer
    public void setContractId(Long contractId) {
        this.contractId = contractId;
    }
    public Long getSupplierId() {
        return supplierId;
    }

    public void setSupplierId(Long supplierId) {
        this.supplierId = supplierId;
    }
    public String getSupplierName() {
        return supplierName;
    }

    public void setSupplierName(String supplierName) {
        this.supplierName = supplierName;
    }
    public Date getPeriod() {
        return period;
    }

    public void setPeriod(Date period) {
        this.period = period;
    }
    public BigDecimal getScoreTotal() {
        return scoreTotal;
    }

    public void setScoreTotal(BigDecimal scoreTotal) {
        this.scoreTotal = scoreTotal;
    }
    public String getMemo() {
        return memo;
    }

    public void setMemo(String memo) {
        this.memo = memo;
    }

    @ReferSerialTransfer(referCode = "idm-user")
    public Long getCreateUserId() {
        return createUserId;
    }

    @ReferDeserialTransfer
    public void setCreateUserId(Long createUserId) {
        this.createUserId = createUserId;
    }

     public List<EvalMonthlyScoreVO> getEvalMonthlyScoreList() {
        return evalMonthlyScoreList;
     }

     public void setEvalMonthlyScoreList(List<EvalMonthlyScoreVO> evalMonthlyScoreList) {
        this.evalMonthlyScoreList = evalMonthlyScoreList;
     }
}
