package com.ejianc.business.financeintegration.PMPayApply.api;

import com.ejianc.business.financeintegration.PMPayApply.hystrix.PMSalaryPayApplyHystrix;
import com.ejianc.business.financeintegration.PMPayApply.vo.PMSalaryPayApplyVO;
import com.ejianc.framework.core.response.CommonResponse;
import org.springframework.cloud.openfeign.FeignClient;
import org.springframework.web.bind.annotation.PostMapping;
import org.springframework.web.bind.annotation.RequestBody;

/**
 * PM付款申请单API
 */
@FeignClient(name = "zzyj-financeintegration-web", url = "${common.env.feign-client-url}", path = "zzyj-financeintegration-web", fallback = PMSalaryPayApplyHystrix.class)
public interface IPMSalaryPayApplyApi {

    // 付款申请生效
    @PostMapping(value = "/api/PMSalaryPayApply/salaryTakeEffect")
    public CommonResponse<PMSalaryPayApplyVO> salaryTakeEffect(@RequestBody PMSalaryPayApplyVO vo);

    // 付款申请弃审/关闭
    @PostMapping(value = "/api/PMSalaryPayApply/salaryAbandonOrClose")
    public CommonResponse<PMSalaryPayApplyVO> salaryAbandonOrClose(@RequestBody PMSalaryPayApplyVO vo);


}
