package com.ejianc.business.financeintegration.PMPayApply.api;

import com.ejianc.business.financeintegration.PMPayApply.hystrix.PMPayApplyHystrix;
import com.ejianc.business.financeintegration.PMPayApply.vo.PMPayApplyVO;
import com.ejianc.framework.core.response.CommonResponse;
import org.springframework.cloud.openfeign.FeignClient;
import org.springframework.web.bind.annotation.PostMapping;
import org.springframework.web.bind.annotation.RequestBody;

import java.util.List;
import java.util.Map;

/**
 * PM付款申请单API
 */
@FeignClient(name = "zzyj-financeintegration-web", url = "${common.env.feign-client-url}", path = "zzyj-financeintegration-web", fallback = PMPayApplyHystrix.class)
public interface IPMPayApplyApi {

    // 付款申请生效
    @PostMapping(value = "/api/PMPayApply/takeEffect")
    public CommonResponse<PMPayApplyVO> takeEffect(@RequestBody PMPayApplyVO vo);

    // 付款申请弃审/关闭
    @PostMapping(value = "/api/PMPayApply/abandonOrClose")
    public CommonResponse<PMPayApplyVO> abandonOrClose(@RequestBody PMPayApplyVO vo);

    // 付款申请核销
    @PostMapping(value = "/api/PMPayApply/writeOff")
    public CommonResponse<PMPayApplyVO> writeOff(@RequestBody PMPayApplyVO vo);

    @PostMapping(value = "/api/PMPayApply/dailyFinanceInfo")
    public CommonResponse<List<Map<String, Object>>> dailyFinanceInfo(@RequestBody String dateStr);

}
