package com.ejianc.business.financeintegration.PMPayApply.vo;

import java.io.Serializable;
import java.math.BigDecimal;

public class PMPayApplyVO implements Serializable {

    private static final long serialVersionUID = -6550871832456894273L;
    private static final String REFER_CACHE_KEY = "refer_cache_key:";

    private String id;

    /**
     * 创建时间
     */
    private String createTime;

    /**
     * 修改时间
     */
    private String updateTime;

    /**
     * 项目ID
     */
    private String projectId;

    /**
     * 供应商ID
     */
    private String supplierId;

    /**
     * 合同登记ID
     */
    private String contractRegisterId;

    /**
     * 收款方ID
     */
    private String payeeId;

    /**
     * 累计应付金额
     */
    private BigDecimal totalPayableMny;

    /**
     * 累计已支付金额
     */
    private BigDecimal totalPaidMny;

    /**
     * 可支付金额
     */
    private BigDecimal canPayMny;

    /**
     * 支付占用金额
     */
    private BigDecimal payingMny;

    /**
     * 本次申请金额
     */
    private BigDecimal curApplyMny;

    /**
     * 本次释放金额
     */
    private BigDecimal curReleaseMny;

    /**
     * 实际支付
     */
    private BigDecimal payMnyActual;

    /**
     * 是否有合同标识：0无合同，1有合同
     */
    private Integer isContract;

    /**
     * 类型标识：1付款申请弃审，2付款申请关闭
     */
    private Integer type;


    /**
     * 标识
     */
    private String bs;

    public String getBs() {
        return bs;
    }

    public void setBs(String bs) {
        this.bs = bs;
    }

    public PMPayApplyVO() {
    }

    public BigDecimal getPayMnyActual() {
        return payMnyActual;
    }

    public void setPayMnyActual(BigDecimal payMnyActual) {
        this.payMnyActual = payMnyActual;
    }

    public BigDecimal getCurReleaseMny() {
        return curReleaseMny;
    }

    public void setCurReleaseMny(BigDecimal curReleaseMny) {
        this.curReleaseMny = curReleaseMny;
    }

    public Integer getIsContract() {
        return isContract;
    }

    public void setIsContract(Integer isContract) {
        this.isContract = isContract;
    }

    public Integer getType() {
        return type;
    }

    public void setType(Integer type) {
        this.type = type;
    }

    public BigDecimal getCurApplyMny() {
        return curApplyMny;
    }

    public void setCurApplyMny(BigDecimal curApplyMny) {
        this.curApplyMny = curApplyMny;
    }

    public String getId() {
        return id;
    }

    public void setId(String id) {
        this.id = id;
    }

    public String getCreateTime() {
        return createTime;
    }

    public void setCreateTime(String createTime) {
        this.createTime = createTime;
    }

    public String getUpdateTime() {
        return updateTime;
    }

    public void setUpdateTime(String updateTime) {
        this.updateTime = updateTime;
    }

    public String getProjectId() {
        return projectId;
    }

    public void setProjectId(String projectId) {
        this.projectId = projectId;
    }

    public String getSupplierId() {
        return supplierId;
    }

    public void setSupplierId(String supplierId) {
        this.supplierId = supplierId;
    }

    public String getContractRegisterId() {
        return contractRegisterId;
    }

    public void setContractRegisterId(String contractRegisterId) {
        this.contractRegisterId = contractRegisterId;
    }

    public String getPayeeId() {
        return payeeId;
    }

    public void setPayeeId(String payeeId) {
        this.payeeId = payeeId;
    }

    public BigDecimal getTotalPayableMny() {
        return totalPayableMny;
    }

    public void setTotalPayableMny(BigDecimal totalPayableMny) {
        this.totalPayableMny = totalPayableMny;
    }

    public BigDecimal getTotalPaidMny() {
        return totalPaidMny;
    }

    public void setTotalPaidMny(BigDecimal totalPaidMny) {
        this.totalPaidMny = totalPaidMny;
    }

    public BigDecimal getCanPayMny() {
        return canPayMny;
    }

    public void setCanPayMny(BigDecimal canPayMny) {
        this.canPayMny = canPayMny;
    }

    public BigDecimal getPayingMny() {
        return payingMny;
    }

    public void setPayingMny(BigDecimal payingMny) {
        this.payingMny = payingMny;
    }

    @Override
    public String toString() {
        return "PMPayApplyVO{" +
                "id=" + id +
                ", createTime='" + createTime + '\'' +
                ", updateTime='" + updateTime + '\'' +
                ", projectId='" + projectId + '\'' +
                ", supplierId='" + supplierId + '\'' +
                ", contractRegisterId='" + contractRegisterId + '\'' +
                ", payeeId='" + payeeId + '\'' +
                ", totalPayableMny=" + totalPayableMny +
                ", totalPaidMny=" + totalPaidMny +
                ", canPayMny=" + canPayMny +
                ", payingMny=" + payingMny +
                ", curApplyMny=" + curApplyMny +
                ", curReleaseMny=" + curReleaseMny +
                ", payMnyActual=" + payMnyActual +
                ", isContract=" + isContract +
                ", type=" + type +
                '}';
    }
}
