package com.ejianc.business.steel.controller;

import com.alibaba.fastjson.JSONObject;
import org.apache.http.HttpEntity;
import org.apache.http.client.methods.CloseableHttpResponse;
import org.apache.http.client.methods.HttpPost;
import org.apache.http.entity.StringEntity;
import org.apache.http.impl.client.CloseableHttpClient;
import org.apache.http.impl.client.HttpClients;
import org.apache.http.util.EntityUtils;

import java.io.IOException;
import java.text.ParseException;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;

/**
 * @Author Chen chunlei
 * @Date 23/5/19 17:37:27
 */
public class JsonPost {

    /**
     * 发送post请求
     *
     * @param url        路径
     * @param jsonObject 参数(json类型)
     * @param encoding   编码格式
     * @return
     * @throws
     * @throws IOException
     */
    public static String send(String url, JSONObject jsonObject, String encoding) throws ParseException, IOException {
        String body = "";

        //创建httpclient对象
        CloseableHttpClient client = HttpClients.createDefault();
        //创建post方式请求对象
        HttpPost httpPost = new HttpPost(url);

        //装填参数
        StringEntity s = new StringEntity(jsonObject.toString(), "utf-8");
        // s.setContentEncoding(new BasicHeader(HTTP.CONTENT_TYPE,
        //         "application/json"));
        //设置参数到请求对象中
        httpPost.setEntity(s);

        //设置header信息
        //指定报文头【Content-type】、【User-Agent】
        httpPost.setHeader("Content-type", "application/json");
        httpPost.setHeader("User-Agent", "Mozilla/4.0 (compatible; MSIE 5.0; Windows NT; DigExt)");
       // httpPost.setHeader("accessTokenSign", "OKgKVnCLjbLdvtriYnjRZ7F6m5FCBsXqM0V81xCqvOgPh24DJp8Ir5qwVCo3NyB9yoWBr2tEf5kPWYS+OzBzZIsGxHazvzw00fI8yrYdAqoHUHkYUL4v6QkmtSwXftoDgbCuS6bDgXMdCgwc0Q0Oa1vbeox0bX8738sGpgOdSCg=");
        httpPost.setHeader("accessTokenSign", "JkGdvCh7F1wt5+jtgu2pQMuO4qYIRNxr");
        httpPost.setHeader("infoOrData", "info");
        //执行请求操作，并拿到结果（同步阻塞）
        CloseableHttpResponse response = client.execute(httpPost);
        //获取结果实体
        HttpEntity entity = response.getEntity();
        if (entity != null) {
            //按指定编码转换结果实体为String类型
            body = EntityUtils.toString(entity, encoding);
        }
        EntityUtils.consume(entity);
        //释放链接
        response.close();
        return body;
    }



    public static void main(String[] args) throws IOException {

        HashMap<String, Object> map = new HashMap<>();
        map.put("pageNum", 1);
        map.put("pageSize", 10);
        map.put("includeInfo", true);
        // 将map转为json对象
        JSONObject json = new JSONObject(map);
        String url = "https://mds.mysteel.com/dynamic/order/api/ZESHZCMJF";
        try {
            System.out.println("结果开始展示:"+JsonPost.send(url, json, "UTF-8")+"：：结果展示结束");
        } catch (ParseException e) {
            e.printStackTrace();
        }
    }
}
