package com.ejianc.business.steel.controller;

import java.io.IOException;
import java.io.Serializable;

import com.alibaba.fastjson.JSON;
import com.ejianc.business.steel.bean.ReturnDataEntity;
import com.ejianc.business.steel.bean.ReturnMessageEntity;
import com.ejianc.foundation.orgcenter.vo.OrgVO;
import com.ejianc.foundation.support.vo.BillCodeParam;
import com.ejianc.foundation.support.api.IBillCodeApi;
import com.ejianc.foundation.support.api.IBillTypeApi;
import com.ejianc.framework.core.exception.BusinessException;
import com.ejianc.framework.core.util.ExcelExport;
import org.apache.commons.httpclient.HttpClient;
import org.apache.commons.httpclient.HttpStatus;
import org.apache.commons.httpclient.methods.PostMethod;
import org.apache.commons.httpclient.methods.StringRequestEntity;
import org.apache.commons.lang3.StringUtils;
import org.apache.http.HttpEntity;
import org.apache.http.client.methods.CloseableHttpResponse;
import org.apache.http.client.methods.HttpPost;
import org.apache.http.entity.StringEntity;
import org.apache.http.impl.client.CloseableHttpClient;
import org.apache.http.impl.client.HttpClients;
import org.apache.http.util.EntityUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

import java.text.ParseException;
import java.text.SimpleDateFormat;
import java.util.*;
import java.util.stream.Collectors;
import com.alibaba.fastjson.JSONObject;
import org.springframework.stereotype.Controller;
import org.springframework.web.bind.annotation.*;
import org.apache.commons.collections.CollectionUtils;

import javax.servlet.ServletOutputStream;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;

import com.ejianc.foundation.orgcenter.api.IOrgApi;
import com.ejianc.framework.core.response.CommonResponse;
import org.springframework.beans.factory.annotation.Autowired;
import com.ejianc.framework.core.context.InvocationInfoProxy;
import com.ejianc.framework.core.kit.mapper.BeanMapper;
import com.ejianc.framework.core.kit.collection.ListUtil;
import com.ejianc.framework.auth.session.SessionManager;
import com.ejianc.framework.auth.session.UserContext;

import com.baomidou.mybatisplus.core.metadata.IPage;
import com.baomidou.mybatisplus.extension.plugins.pagination.Page;
import com.ejianc.framework.core.response.Parameter;
import com.ejianc.framework.core.response.QueryParam;

import com.ejianc.business.steel.bean.SteelInfoEntity;
import com.ejianc.business.steel.service.ISteelInfoService;
import com.ejianc.business.steel.vo.SteelInfoVO;

/**
 * 钢铁网数据表
 *
 * @author generator
 *
 */
@Controller
@RequestMapping("steelInfo")
public class SteelInfoController implements Serializable {
	private static final long serialVersionUID = 1L;

    private Logger logger = LoggerFactory.getLogger(this.getClass());

    @Autowired
    private IBillTypeApi billTypeApi;
    @Autowired
    private IBillCodeApi billCodeApi;
    @Autowired
    private IOrgApi iOrgApi;

    private static final String BILL_CODE = "Invoice_Open_Apply_Code";//此处需要根据实际修改

    @Autowired
    private ISteelInfoService service;

    @Autowired
    private SessionManager sessionManager;

    /**
     * @Description saveOrUpdate 新增或者修改
     */
    @RequestMapping(value = "/saveOrUpdate", method = RequestMethod.POST)
    @ResponseBody
    public CommonResponse<SteelInfoVO> saveOrUpdate(@RequestBody SteelInfoVO saveOrUpdateVO) {
    	SteelInfoEntity entity = BeanMapper.map(saveOrUpdateVO, SteelInfoEntity.class);
    	service.saveOrUpdate(entity, false);
    	SteelInfoVO vo = BeanMapper.map(entity, SteelInfoVO.class);
    	return CommonResponse.success("保存或修改单据成功！",vo);
    }

    /**
     * @Description queryDetail 查询详情
     * @param id
     */
    @RequestMapping(value = "/queryDetail", method = RequestMethod.GET)
    @ResponseBody
    public CommonResponse<SteelInfoVO> queryDetail(Long id) {
    	SteelInfoEntity entity = service.selectById(id);
    	SteelInfoVO vo = BeanMapper.map(entity, SteelInfoVO.class);
        return CommonResponse.success("查询详情数据成功！",vo);
    }

    /**
     * @Description delete 批量删除单据
     * @Param [ids]
     */
    @RequestMapping(value = "/delete", method = RequestMethod.POST)
    @ResponseBody
    public CommonResponse<String> delete(@RequestBody List<SteelInfoVO> vos) {
        if(ListUtil.isNotEmpty(vos)){
            for (SteelInfoVO vo : vos) {
                // 参数是单据类型编码字符串 根据需求是否打开下面代码
                /* CommonResponse<String> resp = billTypeApi.checkQuote("billTypeCode", vo.getId());
                if(!resp.isSuccess()){
                    return CommonResponse.error("删除失败！"+resp.getMsg());
                }*/
            }
        }
        service.removeByIds(vos.stream().map(SteelInfoVO::getId).collect(Collectors.toList()),true);
        return CommonResponse.success("删除成功！");
    }

    /**
     * @Description queryList 查询列表
     * @param param
     * @Return com.ejianc.framework.core.response.CommonResponse<java.lang.String>
     */
    @RequestMapping(value = "/queryList", method = RequestMethod.POST)
    @ResponseBody
    public CommonResponse<IPage<SteelInfoVO>> queryList(@RequestBody QueryParam param) {

        /** 模糊搜索配置字段示例 */
        List<String> fuzzyFields = param.getFuzzyFields();
        /** 租户隔离 */
        param.getParams().put("tenantId", new Parameter(QueryParam.EQ, InvocationInfoProxy.getTenantid()));

        IPage<SteelInfoEntity> page = service.queryPage(param,false);
        IPage<SteelInfoVO> pageData = new Page<>(page.getCurrent(), page.getSize(), page.getTotal());
  		pageData.setRecords(BeanMapper.mapList(page.getRecords(), SteelInfoVO.class));

        return CommonResponse.success("查询列表数据成功！",pageData);
    }

    /**
     * 获取RPC数据
     * resp 返回值
     * isMustSuc 是否必须成功
     * errMsg 失败提示
     */
    private Object getRespData(CommonResponse<?> resp, boolean isMustSuc, String errMsg) {
        if(isMustSuc && !resp.isSuccess()) {
            throw new BusinessException(StringUtils.isNoneBlank(errMsg) ? errMsg : "调用Rpc服务失败");
        }
        return resp.getData();
    }


    /**
     * @Description 导出
     * @param param
     * @Return void
     */
    @RequestMapping(value = "/excelExport", method = RequestMethod.POST)
    @ResponseBody
    public void excelExport(@RequestBody QueryParam param, HttpServletResponse response) {
        /** 模糊搜索配置字段示例 */
        List<String> fuzzyFields = param.getFuzzyFields();
        param.getParams().put("tenant_id",new Parameter(QueryParam.EQ,InvocationInfoProxy.getTenantid()));
        param.setPageIndex(1);
        param.setPageSize(-1);
        /** 数据隔离 本下 没有组织orgId的删除下面代码 */
        param.getParams().put("orgId",new Parameter(QueryParam.IN,iOrgApi.findChildrenByParentId(InvocationInfoProxy.getOrgId()).getData().stream().map(OrgVO::getId).collect(Collectors.toList())));
        List<SteelInfoEntity> list = service.queryList(param);
        //todo:字段翻译等等
        Map<String, Object> beans = new HashMap<>();
        beans.put("records", list);
        ExcelExport.getInstance().export("SteelInfo-export.xlsx", beans, response);
    }




    /**
     * @Description queryNewDataList 获取最新钢材数据，并缓存到本地
     * @param
     * @Return com.ejianc.framework.core.response.CommonResponse<java.lang.String>
     */
    @RequestMapping(value = "/queryNewDataList", method = RequestMethod.POST)
    @ResponseBody
    public CommonResponse<List<JSONObject>> queryNewDataList(HttpServletRequest request) {
        logger.info("执行获取钢材网数据逻辑：开始---------------->");

        beforeSend(1,100);

        logger.info("执行获取钢材网数据逻辑：结束---------------->");
        return CommonResponse.success("执行成功！");
    }

    /**
     * 发送post请求
     *
     * @param url        路径
     * @param jsonObject 参数(json类型)
     * @param encoding   编码格式
     * @return
     * @throws
     * @throws IOException
     */
    public  String send(String url, JSONObject jsonObject, String encoding) throws ParseException, IOException {
        String body = "";

        //创建httpclient对象
        CloseableHttpClient client = HttpClients.createDefault();
        //创建post方式请求对象
        HttpPost httpPost = new HttpPost(url);

        //装填参数
        StringEntity s = new StringEntity(jsonObject.toString(), "utf-8");
        // s.setContentEncoding(new BasicHeader(HTTP.CONTENT_TYPE,
        //         "application/json"));
        //设置参数到请求对象中
        httpPost.setEntity(s);

        //设置header信息
        //指定报文头【Content-type】、【User-Agent】
        httpPost.setHeader("Content-type", "application/json");
        httpPost.setHeader("User-Agent", "Mozilla/4.0 (compatible; MSIE 5.0; Windows NT; DigExt)");
        // httpPost.setHeader("accessTokenSign", "OKgKVnCLjbLdvtriYnjRZ7F6m5FCBsXqM0V81xCqvOgPh24DJp8Ir5qwVCo3NyB9yoWBr2tEf5kPWYS+OzBzZIsGxHazvzw00fI8yrYdAqoHUHkYUL4v6QkmtSwXftoDgbCuS6bDgXMdCgwc0Q0Oa1vbeox0bX8738sGpgOdSCg=");
        httpPost.setHeader("accessTokenSign", "JkGdvCh7F1wt5+jtgu2pQMuO4qYIRNxr");
        httpPost.setHeader("infoOrData", "info");
        //执行请求操作，并拿到结果（同步阻塞）
        CloseableHttpResponse response = client.execute(httpPost);
        //获取结果实体
        HttpEntity entity = response.getEntity();
        if (entity != null) {
            //按指定编码转换结果实体为String类型
            body = EntityUtils.toString(entity, encoding);
        }
        EntityUtils.consume(entity);
        //释放链接
        response.close();
        return body;
    }

    public  void beforeSend(int pageNum,int pageSize){
        HashMap<String, Object> map = new HashMap<>();
        map.put("pageNum", pageNum);
        map.put("pageSize", pageSize);
        map.put("includeInfo", true);
        // 将map转为json对象
        JSONObject json = new JSONObject(map);
        String url = "https://mds.mysteel.com/dynamic/order/api/ZESHZCMJF";
        try {
            String send = send(url, json, "UTF-8");
            ReturnMessageEntity returnMessageEntity = JSONObject.parseObject(send, ReturnMessageEntity.class);
            if ("200".equals(returnMessageEntity.getCode())){
                //处理并存储数据
                ReturnDataEntity data = returnMessageEntity.getData();
                //获取具体信息
                List<SteelInfoEntity> list = data.getList();
                if (CollectionUtils.isNotEmpty(list)){
                    Date date = new Date();
                    for (SteelInfoEntity steelInfoEntity : list) {
                        steelInfoEntity.setCreateTime(date);//创建时间
                        steelInfoEntity.setSteelId(Long.toString(steelInfoEntity.getId()));//钢铁网中的id
                        steelInfoEntity.setDr(0);
                        steelInfoEntity.setTenantId(999999L);
                        steelInfoEntity.setSyncEsFlag(0);
                        steelInfoEntity.setVersion(1);
                        steelInfoEntity.setId(null);
                    }
                    service.saveBatch(list);
                }
                //如果后续有数据，继续处理数据
                logger.info("当前页面："+returnMessageEntity.getData().getPageNum());
                if (data.getHasNextPage()){
                    beforeSend(data.getNextPage(),data.getPageSize());
                }
            }
        } catch (ParseException e) {
            e.printStackTrace();
        } catch (IOException e) {
            e.printStackTrace();
        }
    }

//    public static void main(String[] args) throws IOException, ParseException {
//        beforeSend(1,10);
//
//    }

}
