package com.ejianc.business.steel.service.impl;

import com.baomidou.mybatisplus.core.conditions.query.QueryWrapper;
import com.baomidou.mybatisplus.extension.plugins.pagination.Page;
import com.ejianc.business.steel.vo.SteelInfoVO;
import com.ejianc.framework.skeleton.template.BaseEntity;
import org.checkerframework.checker.units.qual.A;
import org.springframework.stereotype.Service;
import com.ejianc.framework.skeleton.template.BaseServiceImpl;

import com.ejianc.business.steel.mapper.SteelInfoMapper;
import com.ejianc.business.steel.bean.SteelInfoEntity;
import com.ejianc.business.steel.service.ISteelInfoService;

import java.math.BigDecimal;
import java.util.ArrayList;
import java.util.Date;
import java.util.List;
import java.util.stream.Collectors;

/**
 * 钢铁网数据表
 * 
 * @author generator
 * 
 */
@Service("steelInfoService")
public class SteelInfoServiceImpl extends BaseServiceImpl<SteelInfoMapper, SteelInfoEntity> implements ISteelInfoService{

    @Override
    public SteelInfoVO priceChange(String dictSpec,String cj, String dateIn) {
        List<SteelInfoVO> steelInfoVO  = new ArrayList<>();
        if ("near7day".equals(dateIn)){
             steelInfoVO = baseMapper.priceChange7Day(dictSpec,cj);

        }else if ("near1Mon".equals(dateIn)){
            steelInfoVO =baseMapper.priceChange4Week(dictSpec,cj);
        }else if ("near1Year".equals(dateIn)){
            steelInfoVO = baseMapper.priceChange3Month(dictSpec,cj);
        }
        List<String> time = steelInfoVO.stream().map(SteelInfoVO::getDateTime).collect(Collectors.toList());
        List<BigDecimal> value = steelInfoVO.stream().map(SteelInfoVO::getVal).collect(Collectors.toList());
        SteelInfoVO steelInfoVO1 = new SteelInfoVO();
        steelInfoVO1.setTime(time);
        steelInfoVO1.setValue(value);
        return steelInfoVO1;
    }

    @Override
    public List<SteelInfoVO> queryCj(Page<SteelInfoVO> page, QueryWrapper wrapper) {
        return baseMapper.queryCj(page,wrapper);
    }
}
