package com.ejianc.business.outputvalcount.api;

import com.baomidou.mybatisplus.core.metadata.IPage;
import com.ejianc.business.outputvalcount.hyxtrix.OutputValueHystrix;
import com.ejianc.business.outputvalcount.vo.OutputValueVO;
import com.ejianc.framework.core.response.CommonResponse;
import org.springframework.cloud.openfeign.FeignClient;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestMethod;
import org.springframework.web.bind.annotation.RequestParam;

/**
 * @Author Chen chunlei
 * @Date 22/4/26 18:31
 */
@FeignClient(name= "zzyj-outputvalcount-web", url="${common.env.feign-client-url}", path="zzyj-outputvalcount-web", fallback = OutputValueHystrix.class)

public interface IOutputValueApi {

    @RequestMapping(value = "/api/outputValue/getSumByProjectId", method= RequestMethod.GET)
    CommonResponse<OutputValueVO> getSumByProjectId(@RequestParam Long projectId);

}
