package com.ejianc.business.outputvalcount.api;

import com.baomidou.mybatisplus.core.metadata.IPage;
import com.ejianc.business.outputvalcount.hyxtrix.OutputValueHystrix;
import com.ejianc.business.outputvalcount.vo.OutputValueVO;
import com.ejianc.business.outputvalcount.vo.XmyxglVO;
import com.ejianc.framework.core.response.CommonResponse;
import org.springframework.cloud.openfeign.FeignClient;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestMethod;
import org.springframework.web.bind.annotation.RequestParam;
import com.baomidou.mybatisplus.extension.plugins.pagination.Page;

import java.util.List;

/**
 * @Author
 * @Date 22/4/26 18:31
 */
@FeignClient(name= "zzyj-outputvalcount-web", url="${common.env.feign-client-url}", path="zzyj-outputvalcount-web", fallback = OutputValueHystrix.class)

public interface IOutputValueApi {

    @RequestMapping(value = "/api/outputValue/getSumByProjectId", method= RequestMethod.GET)
    CommonResponse<OutputValueVO> getSumByProjectId(@RequestParam(value = "projectId") Long projectId);

    @RequestMapping(value = "/api/outputValue/getInfoByProjectId", method= RequestMethod.GET)
    CommonResponse<List<XmyxglVO>> getInfoByProjectId(@RequestParam(value = "projectId") Long projectId,@RequestParam(value = "num") Integer num);

}
