package com.ejianc.business.outputvalcount.vo;

import java.util.Date;
import java.math.*;
import java.util.List;
import java.util.ArrayList;
import java.io.Serializable;
import com.ejianc.framework.skeleton.template.BaseVO;
import com.fasterxml.jackson.annotation.JsonFormat;


/**
 * 投标情况分析报表
 *
 * @author generator
 *
 */
public class BidReportVO extends BaseVO {
    private static final long serialVersionUID = 1L;

    private Long aid; // 主键
    private String billcode; // 单据编号
    private Integer billstate; // 单据状态
    private Long pid; // 项目
    private String pcode; // 项目编号
    private String pname; //
    private Long orgid; // 组织
    private String orgname; //
    private String contractname; //
    @JsonFormat(pattern = "yyyy-MM-dd", timezone = "GMT+8")
    private Date signdate; // 签约日期
    private Long customerid; // 合同甲方
    private String custormername; //
    private Long supplierid; // 合同乙方
    private String suppliername; //
    private BigDecimal contractmny; // 合同(签订)金额
    private BigDecimal taxrate; // 合同税率
    private BigDecimal base; // 初始版本金额（含税）
    private BigDecimal zanliemny; // 暂列金额
    private String settlementtype; // 结算方式：0-过程结算，1-竣工结算
    @JsonFormat(pattern = "yyyy-MM-dd", timezone = "GMT+8")
    private Date startdate; // 合同开工日期
    @JsonFormat(pattern = "yyyy-MM-dd", timezone = "GMT+8")
    private Date enddate; // 合同竣工日期
    private Integer aschedule; // 工期
    private Long tenantid; // 租户主键
    private BigDecimal buggetmny; //
    private BigDecimal jtpfmny; //
    private Long sqcs; //
    @JsonFormat(pattern = "yyyy-MM-dd", timezone = "GMT+8")
    private Date quotedate; // 报量时间
    private BigDecimal quotemny; //
    private BigDecimal replymny; //
    private BigDecimal productionmny; //
    private Long qssl; //
    private BigDecimal qsmny; //
    private BigDecimal qsreplymny; //
    private Long qzsl; //
    private BigDecimal qzmny; //
    private BigDecimal qzreplymny; //
    private Long spsl; //
    private BigDecimal spduration; //
    private BigDecimal spreplydurat; //
    private BigDecimal spmny; //
    private BigDecimal spreplymny; //
    private Long contractId; // 合同主键
    @JsonFormat(pattern = "yyyy-MM-dd", timezone = "GMT+8")
    private Date statDate;
    private BigDecimal kgwccz; //
    private Long progressid; // 进度主键
    private Long projectid; // 项目主键


    public Long getProjectid() {
        return projectid;
    }

    public void setProjectid(Long projectid) {
        this.projectid = projectid;
    }

    public Long getProgressid() {
        return progressid;
    }

    public void setProgressid(Long progressid) {
        this.progressid = progressid;
    }

    public Date getStatDate() {
        return statDate;
    }

    public void setStatDate(Date statDate) {
        this.statDate = statDate;
    }

    public BigDecimal getKgwccz() {
        return kgwccz;
    }

    public void setKgwccz(BigDecimal kgwccz) {
        this.kgwccz = kgwccz;
    }

    public Long getAid() {
        return aid;
    }

    public void setAid(Long aid) {
        this.aid = aid;
    }
    public String getBillcode() {
        return billcode;
    }

    public void setBillcode(String billcode) {
        this.billcode = billcode;
    }
    public Integer getBillstate() {
        return billstate;
    }

    public void setBillstate(Integer billstate) {
        this.billstate = billstate;
    }
    public Long getPid() {
        return pid;
    }

    public void setPid(Long pid) {
        this.pid = pid;
    }
    public String getPcode() {
        return pcode;
    }

    public void setPcode(String pcode) {
        this.pcode = pcode;
    }
    public String getPname() {
        return pname;
    }

    public void setPname(String pname) {
        this.pname = pname;
    }
    public Long getOrgid() {
        return orgid;
    }

    public void setOrgid(Long orgid) {
        this.orgid = orgid;
    }
    public String getOrgname() {
        return orgname;
    }

    public void setOrgname(String orgname) {
        this.orgname = orgname;
    }
    public String getContractname() {
        return contractname;
    }

    public void setContractname(String contractname) {
        this.contractname = contractname;
    }
    public Date getSigndate() {
        return signdate;
    }

    public void setSigndate(Date signdate) {
        this.signdate = signdate;
    }
    public Long getCustomerid() {
        return customerid;
    }

    public void setCustomerid(Long customerid) {
        this.customerid = customerid;
    }
    public String getCustormername() {
        return custormername;
    }

    public void setCustormername(String custormername) {
        this.custormername = custormername;
    }
    public Long getSupplierid() {
        return supplierid;
    }

    public void setSupplierid(Long supplierid) {
        this.supplierid = supplierid;
    }
    public String getSuppliername() {
        return suppliername;
    }

    public void setSuppliername(String suppliername) {
        this.suppliername = suppliername;
    }
    public BigDecimal getContractmny() {
        return contractmny;
    }

    public void setContractmny(BigDecimal contractmny) {
        this.contractmny = contractmny;
    }
    public BigDecimal getTaxrate() {
        return taxrate;
    }

    public void setTaxrate(BigDecimal taxrate) {
        this.taxrate = taxrate;
    }
    public BigDecimal getBase() {
        return base;
    }

    public void setBase(BigDecimal base) {
        this.base = base;
    }
    public BigDecimal getZanliemny() {
        return zanliemny;
    }

    public void setZanliemny(BigDecimal zanliemny) {
        this.zanliemny = zanliemny;
    }
    public String getSettlementtype() {
        return settlementtype;
    }

    public void setSettlementtype(String settlementtype) {
        this.settlementtype = settlementtype;
    }
    public Date getStartdate() {
        return startdate;
    }

    public void setStartdate(Date startdate) {
        this.startdate = startdate;
    }
    public Date getEnddate() {
        return enddate;
    }

    public void setEnddate(Date enddate) {
        this.enddate = enddate;
    }
    public Integer getAschedule() {
        return aschedule;
    }

    public void setAschedule(Integer aschedule) {
        this.aschedule = aschedule;
    }
    public Long getTenantid() {
        return tenantid;
    }

    public void setTenantid(Long tenantid) {
        this.tenantid = tenantid;
    }
    public BigDecimal getBuggetmny() {
        return buggetmny;
    }

    public void setBuggetmny(BigDecimal buggetmny) {
        this.buggetmny = buggetmny;
    }
    public BigDecimal getJtpfmny() {
        return jtpfmny;
    }

    public void setJtpfmny(BigDecimal jtpfmny) {
        this.jtpfmny = jtpfmny;
    }
    public Long getSqcs() {
        return sqcs;
    }

    public void setSqcs(Long sqcs) {
        this.sqcs = sqcs;
    }
    public Date getQuotedate() {
        return quotedate;
    }

    public void setQuotedate(Date quotedate) {
        this.quotedate = quotedate;
    }
    public BigDecimal getQuotemny() {
        return quotemny;
    }

    public void setQuotemny(BigDecimal quotemny) {
        this.quotemny = quotemny;
    }
    public BigDecimal getReplymny() {
        return replymny;
    }

    public void setReplymny(BigDecimal replymny) {
        this.replymny = replymny;
    }
    public BigDecimal getProductionmny() {
        return productionmny;
    }

    public void setProductionmny(BigDecimal productionmny) {
        this.productionmny = productionmny;
    }
    public Long getQssl() {
        return qssl;
    }

    public void setQssl(Long qssl) {
        this.qssl = qssl;
    }
    public BigDecimal getQsmny() {
        return qsmny;
    }

    public void setQsmny(BigDecimal qsmny) {
        this.qsmny = qsmny;
    }
    public BigDecimal getQsreplymny() {
        return qsreplymny;
    }

    public void setQsreplymny(BigDecimal qsreplymny) {
        this.qsreplymny = qsreplymny;
    }
    public Long getQzsl() {
        return qzsl;
    }

    public void setQzsl(Long qzsl) {
        this.qzsl = qzsl;
    }
    public BigDecimal getQzmny() {
        return qzmny;
    }

    public void setQzmny(BigDecimal qzmny) {
        this.qzmny = qzmny;
    }
    public BigDecimal getQzreplymny() {
        return qzreplymny;
    }

    public void setQzreplymny(BigDecimal qzreplymny) {
        this.qzreplymny = qzreplymny;
    }
    public Long getSpsl() {
        return spsl;
    }

    public void setSpsl(Long spsl) {
        this.spsl = spsl;
    }
    public BigDecimal getSpduration() {
        return spduration;
    }

    public void setSpduration(BigDecimal spduration) {
        this.spduration = spduration;
    }
    public BigDecimal getSpreplydurat() {
        return spreplydurat;
    }

    public void setSpreplydurat(BigDecimal spreplydurat) {
        this.spreplydurat = spreplydurat;
    }
    public BigDecimal getSpmny() {
        return spmny;
    }

    public void setSpmny(BigDecimal spmny) {
        this.spmny = spmny;
    }
    public BigDecimal getSpreplymny() {
        return spreplymny;
    }

    public void setSpreplymny(BigDecimal spreplymny) {
        this.spreplymny = spreplymny;
    }
    public Long getContractId() {
        return contractId;
    }

    public void setContractId(Long contractId) {
        this.contractId = contractId;
    }
}
