package com.ejianc.business.outputvalcount.vo;

import java.util.Date;
import java.math.*;
import java.util.List;
import java.util.ArrayList;
import java.io.Serializable;

import com.ejianc.framework.skeleton.refer.annotation.ReferDeserialTransfer;
import com.ejianc.framework.skeleton.refer.annotation.ReferSerialTransfer;
import com.ejianc.framework.skeleton.template.BaseVO;
import com.fasterxml.jackson.annotation.JsonFormat;


/**
 * 月度产值计划
 * 
 * @author generator
 * 
 */
public class MonthlyPlanVO extends BaseVO {
    private static final long serialVersionUID = 1L;
    
    private String billCode; // 单据编码
    private Long orgId; // 组织id
    private String orgName; // 组织名称
    private Integer billState; // 单据状态（审批必须字段）
    private String createUserName; // 编制人
    private Long operatorId; // 经办人ID
    private String operatorName; // 经办人姓名
    private String updateUserName; // 修改者
    private String remark; // 备注
    private Long projectId; // 工程名称id
    private String projectName; // 工程名称
    private Long lbId; // 工程类别id
    private String lbName; // 工程类别
    private String address; // 工程所在地
    private Integer year; // 年份
    private Integer month; // 月份
    private Long gcztId; // 工程状态id
    private String gcztName; // 工程状态
    private BigDecimal byjhwccz; // 本月计划完成产值
    private String description; // 形象进度描述
    private Long buildUnitId; // 工程父id
    private String bildUnitName; // 施工单位
    @JsonFormat(pattern = "yyyy-MM-dd", timezone = "GMT+8")
    private Date statDate; // 产值统计日期

    public String getBillCode() {
        return billCode;
    }

    public void setBillCode(String billCode) {
        this.billCode = billCode;
    }
    public Long getOrgId() {
        return orgId;
    }

    public void setOrgId(Long orgId) {
        this.orgId = orgId;
    }
    public String getOrgName() {
        return orgName;
    }

    public void setOrgName(String orgName) {
        this.orgName = orgName;
    }
    public Integer getBillState() {
        return billState;
    }

    public void setBillState(Integer billState) {
        this.billState = billState;
    }
    public String getCreateUserName() {
        return createUserName;
    }

    public void setCreateUserName(String createUserName) {
        this.createUserName = createUserName;
    }
    public Long getOperatorId() {
        return operatorId;
    }

    public void setOperatorId(Long operatorId) {
        this.operatorId = operatorId;
    }
    public String getOperatorName() {
        return operatorName;
    }

    public void setOperatorName(String operatorName) {
        this.operatorName = operatorName;
    }
    public String getUpdateUserName() {
        return updateUserName;
    }

    public void setUpdateUserName(String updateUserName) {
        this.updateUserName = updateUserName;
    }
    public String getRemark() {
        return remark;
    }

    public void setRemark(String remark) {
        this.remark = remark;
    }

    @ReferSerialTransfer(referCode="project-set")
    public Long getProjectId() {
        return projectId;
    }
    @ReferDeserialTransfer
    public void setProjectId(Long projectId) {
        this.projectId = projectId;
    }
    public String getProjectName() {
        return projectName;
    }

    public void setProjectName(String projectName) {
        this.projectName = projectName;
    }

    @ReferSerialTransfer(referCode = "support-defdoc")
    public Long getLbId() {
        return lbId;
    }
    @ReferDeserialTransfer
    public void setLbId(Long lbId) {
        this.lbId = lbId;
    }
    public String getLbName() {
        return lbName;
    }

    public void setLbName(String lbName) {
        this.lbName = lbName;
    }
    public String getAddress() {
        return address;
    }

    public void setAddress(String address) {
        this.address = address;
    }
    public Integer getYear() {
        return year;
    }

    public void setYear(Integer year) {
        this.year = year;
    }
    public Integer getMonth() {
        return month;
    }

    public void setMonth(Integer month) {
        this.month = month;
    }
    public Long getGcztId() {
        return gcztId;
    }

    public void setGcztId(Long gcztId) {
        this.gcztId = gcztId;
    }
    public String getGcztName() {
        return gcztName;
    }

    public void setGcztName(String gcztName) {
        this.gcztName = gcztName;
    }
    public BigDecimal getByjhwccz() {
        return byjhwccz;
    }

    public void setByjhwccz(BigDecimal byjhwccz) {
        this.byjhwccz = byjhwccz;
    }
    public String getDescription() {
        return description;
    }

    public void setDescription(String description) {
        this.description = description;
    }

    public Long getBuildUnitId() {
        return buildUnitId;
    }

    public void setBuildUnitId(Long buildUnitId) {
        this.buildUnitId = buildUnitId;
    }

    public String getBildUnitName() {
        return bildUnitName;
    }

    public void setBildUnitName(String bildUnitName) {
        this.bildUnitName = bildUnitName;
    }

    public Date getStatDate() {
        return statDate;
    }

    public void setStatDate(Date statDate) {
        this.statDate = statDate;
    }
}
