package com.ejianc.business.outputvalcount.api;

import com.baomidou.mybatisplus.core.metadata.IPage;
import com.ejianc.business.outputvalcount.hyxtrix.OutputValueHystrix;
import com.ejianc.business.outputvalcount.vo.OutputValDTO;
import com.ejianc.business.outputvalcount.vo.OutputValueVO;
import com.ejianc.business.outputvalcount.vo.XmyxglVO;
import com.ejianc.framework.core.response.CommonResponse;
import org.springframework.cloud.openfeign.FeignClient;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestMethod;
import org.springframework.web.bind.annotation.RequestParam;
import com.baomidou.mybatisplus.extension.plugins.pagination.Page;

import java.math.BigDecimal;
import java.util.HashMap;
import java.util.List;

/**
 * @Author
 * @Date 22/4/26 18:31
 */
@FeignClient(name= "zzyj-outputvalcount-web", url="${common.env.feign-client-url}", path="zzyj-outputvalcount-web", fallback = OutputValueHystrix.class)

public interface IOutputValueApi {

    @RequestMapping(value = "/api/outputValue/getSumByProjectId", method= RequestMethod.GET)
    CommonResponse<OutputValueVO> getSumByProjectId(@RequestParam(value = "projectId") Long projectId);

    @RequestMapping(value = "/api/outputValue/getInfoByProjectId", method= RequestMethod.GET)
    CommonResponse<List<XmyxglVO>> getInfoByProjectId(@RequestParam(value = "projectId") Long projectId,@RequestParam(value = "num") Integer num);


    @RequestMapping(value = "/api/outputValue/getSumByOrgId", method= RequestMethod.GET)
    CommonResponse<OutputValueVO> getSumByOrgId(@RequestParam(value = "orgId") Long orgId);

    /**
     * 获取本下单位的总产值
     * @param orgId
     * @return
     */
    @RequestMapping(value = "/api/outputValue/getSumByOrgIdUnder", method= RequestMethod.GET)
    CommonResponse<BigDecimal> getSumByOrgIdUnder(@RequestParam(value = "orgId") Long orgId, @RequestParam(value = "year") Integer year);



    /**
     * 批量获取本下单位的总产值  按年度取产值
     * @param
     * @return
     */
    @RequestMapping(value = "/api/outputValue/getSumByOrgIds", method= RequestMethod.POST)
    CommonResponse<HashMap<Long, BigDecimal>> getSumByOrgIds(@RequestBody OutputValDTO dto);
}
