package com.ejianc.business.outputvalcount.vo;

import java.util.Date;
import java.math.*;
import java.util.List;
import java.util.ArrayList;
import java.io.Serializable;

import com.ejianc.framework.skeleton.refer.annotation.ReferDeserialTransfer;
import com.ejianc.framework.skeleton.refer.annotation.ReferSerialTransfer;
import com.ejianc.framework.skeleton.template.BaseVO;

import com.ejianc.business.outputvalcount.vo.ProjectInfoRegisterExamineVO;
import com.ejianc.business.outputvalcount.vo.ProjectInfoRegisterDisputeVO;
import com.ejianc.business.outputvalcount.vo.ProjectInfoRegisterCommunicationVO;
import com.fasterxml.jackson.annotation.JsonFormat;

/**
 * 项目相关方信息每日填报
 * 
 * @author generator
 * 
 */
public class ProjectInfoRegisterVO extends BaseVO {
    private static final long serialVersionUID = 1L;
    
    private String billCode; // 单据编码
    private Long orgId; // 组织id
    private String orgName; // 组织名称
    private Integer billState; // 单据状态
    private String createUserName; // 编制人
    private String updateUserName; // 修改者
    private String remark; // 备注
    private Long projectId; // 工程名称id
    private String projectName; // 工程名称
    @JsonFormat(pattern = "yyyy-MM-dd", timezone = "GMT+8")
    private Date createDate; // 创建日期
    private Long operatorId; // 经办人ID
    private String operatorName; // 经办人姓名
    private String operatorPhone; // 经办人手机号
    private Integer examineState; // 外部行政部门检查
    private Integer disputeState; // 现场是否存在纠纷
    private Integer communicationState; // 现场是否存在外部沟通
    
    private List<ProjectInfoRegisterExamineVO> projectInfoRegisterExamineList = new ArrayList<>(); // 信息每日填报行政部门检查
    private List<ProjectInfoRegisterDisputeVO> projectInfoRegisterDisputeList = new ArrayList<>(); // 信息每日填报-纠纷
    private List<ProjectInfoRegisterCommunicationVO> projectInfoRegisterCommunicationList = new ArrayList<>(); // 信息每日填报-外部沟通

    private Integer examineCount; // 外部行政部门检查
    private Integer disputeCount; // 现场是否存在纠纷
    private Integer communicationCount; // 现场是否存在外部沟通
    private Long count;
    //patrol_group
    private Long patrolGroup; // 巡检组
    private Integer sum; // 开工累计个数
    private Integer thisMonth; // 本月个数


    public Integer getSum() {
        return sum;
    }

    public void setSum(Integer sum) {
        this.sum = sum;
    }

    public Integer getThisMonth() {
        return thisMonth;
    }

    public void setThisMonth(Integer thisMonth) {
        this.thisMonth = thisMonth;
    }

    @ReferSerialTransfer(referCode = "support-defdoc")
    public Long getPatrolGroup() {
        return patrolGroup;
    }
    @ReferDeserialTransfer
    public void setPatrolGroup(Long patrolGroup) {
        this.patrolGroup = patrolGroup;
    }

    public Integer getExamineCount() {
        return examineCount;
    }

    public void setExamineCount(Integer examineCount) {
        this.examineCount = examineCount;
    }

    public Integer getDisputeCount() {
        return disputeCount;
    }

    public void setDisputeCount(Integer disputeCount) {
        this.disputeCount = disputeCount;
    }

    public Integer getCommunicationCount() {
        return communicationCount;
    }

    public void setCommunicationCount(Integer communicationCount) {
        this.communicationCount = communicationCount;
    }

    public Long getCount() {
        return count;
    }

    public void setCount(Long count) {
        this.count = count;
    }

    public String getBillCode() {
        return billCode;
    }

    public void setBillCode(String billCode) {
        this.billCode = billCode;
    }

    @ReferSerialTransfer(referCode="idm-org")
    public Long getOrgId() {
        return orgId;
    }

    @ReferDeserialTransfer
    public void setOrgId(Long orgId) {
        this.orgId = orgId;
    }
    public String getOrgName() {
        return orgName;
    }

    public void setOrgName(String orgName) {
        this.orgName = orgName;
    }
    public Integer getBillState() {
        return billState;
    }

    public void setBillState(Integer billState) {
        this.billState = billState;
    }
    public String getCreateUserName() {
        return createUserName;
    }

    public void setCreateUserName(String createUserName) {
        this.createUserName = createUserName;
    }
    public String getUpdateUserName() {
        return updateUserName;
    }

    public void setUpdateUserName(String updateUserName) {
        this.updateUserName = updateUserName;
    }
    public String getRemark() {
        return remark;
    }

    public void setRemark(String remark) {
        this.remark = remark;
    }
    public Long getProjectId() {
        return projectId;
    }
    @ReferDeserialTransfer
    public void setProjectId(Long projectId) {
        this.projectId = projectId;
    }
    public String getProjectName() {
        return projectName;
    }

    public void setProjectName(String projectName) {
        this.projectName = projectName;
    }
    public Date getCreateDate() {
        return createDate;
    }

    public void setCreateDate(Date createDate) {
        this.createDate = createDate;
    }
    public Long getOperatorId() {
        return operatorId;
    }

    public void setOperatorId(Long operatorId) {
        this.operatorId = operatorId;
    }
    public String getOperatorName() {
        return operatorName;
    }

    public void setOperatorName(String operatorName) {
        this.operatorName = operatorName;
    }
    public String getOperatorPhone() {
        return operatorPhone;
    }

    public void setOperatorPhone(String operatorPhone) {
        this.operatorPhone = operatorPhone;
    }
    public Integer getExamineState() {
        return examineState;
    }

    public void setExamineState(Integer examineState) {
        this.examineState = examineState;
    }
    public Integer getDisputeState() {
        return disputeState;
    }

    public void setDisputeState(Integer disputeState) {
        this.disputeState = disputeState;
    }
    public Integer getCommunicationState() {
        return communicationState;
    }

    public void setCommunicationState(Integer communicationState) {
        this.communicationState = communicationState;
    }
    
     public List<ProjectInfoRegisterExamineVO> getProjectInfoRegisterExamineList() {
        return projectInfoRegisterExamineList;
     }

     public void setProjectInfoRegisterExamineList(List<ProjectInfoRegisterExamineVO> projectInfoRegisterExamineList) {
        this.projectInfoRegisterExamineList = projectInfoRegisterExamineList;
     }
     public List<ProjectInfoRegisterDisputeVO> getProjectInfoRegisterDisputeList() {
        return projectInfoRegisterDisputeList;
     }

     public void setProjectInfoRegisterDisputeList(List<ProjectInfoRegisterDisputeVO> projectInfoRegisterDisputeList) {
        this.projectInfoRegisterDisputeList = projectInfoRegisterDisputeList;
     }
     public List<ProjectInfoRegisterCommunicationVO> getProjectInfoRegisterCommunicationList() {
        return projectInfoRegisterCommunicationList;
     }

     public void setProjectInfoRegisterCommunicationList(List<ProjectInfoRegisterCommunicationVO> projectInfoRegisterCommunicationList) {
        this.projectInfoRegisterCommunicationList = projectInfoRegisterCommunicationList;
     }
}
