package com.ejianc.business.worklog.vo;

import com.ejianc.framework.skeleton.refer.annotation.ReferDeserialTransfer;
import com.ejianc.framework.skeleton.refer.annotation.ReferSerialTransfer;
import com.ejianc.framework.skeleton.template.BaseVO;
import com.fasterxml.jackson.annotation.JsonFormat;

import java.util.ArrayList;
import java.util.Date;
import java.util.List;


/**
 * 课题登记
 *
 * @author generator
 */
public class ProjectRegistWithProgressVO extends BaseVO {
    private static final long serialVersionUID = 1L;

    private String billCode; // 单据编码
    private Long orgId; // 组织id
    private String orgCode; // 组织编号
    private String orgName; // 组织名称
    private Integer billState; // 单据状态（审批必须字段）
    private String createUserName; // 编制人
    private String updateUserName; // 修改者
    private Long workTypeId; // 工作类别id
    private String workTypeCode; // 工作类别编号
    private String workTypeName; // 工作类别名称
    private Long workTypeDetailId; // 工作详细类别id
    private String workTypeDetailCode; // 工作详细类别编号
    private String workTypeDetailName; // 工作详细类别名称
    private String projectCode; // 课题编号
    private String projectName; // 课题名称
    @JsonFormat(pattern = "yyyy-MM-dd", timezone = "GMT+8")
    private Date registTime; // 立项时间
    private Long chargeOrgId; // 责任部门id
    private String chargeOrgName; // 责任部门名称
    private Long coordinateOrgId; // 配合部门id
    private String coordinateOrgName; // 配合部门名称
    private String registRemark; // 立项事由概述
    private String anticipatedResults; // 预期成果
    @JsonFormat(pattern = "yyyy-MM-dd", timezone = "GMT+8")
    private Date endTime; // 预计完成时间
    private String operatorId; // 联络人ID
    private String operatorName; // 联络人姓名
    private Long progressId; // 进展ID
    private String progressName; // 进展
    private String progressRemark; // 进展描述
    @JsonFormat(pattern = "yyyy-MM-dd", timezone = "GMT+8")
    private Date progressTime; // 最新进展日期
    private List<WorkPlanLogVO> planLogVOS = new ArrayList<>(); // 计划进展
    private List<WorkPlanVO> childrenVOS = new ArrayList<>(); // 子课题


    public String getBillCode() {
        return billCode;
    }

    public void setBillCode(String billCode) {
        this.billCode = billCode;
    }

    public Long getOrgId() {
        return orgId;
    }

    public void setOrgId(Long orgId) {
        this.orgId = orgId;
    }

    public String getOrgCode() {
        return orgCode;
    }

    public void setOrgCode(String orgCode) {
        this.orgCode = orgCode;
    }

    public String getOrgName() {
        return orgName;
    }

    public void setOrgName(String orgName) {
        this.orgName = orgName;
    }

    public Integer getBillState() {
        return billState;
    }

    public void setBillState(Integer billState) {
        this.billState = billState;
    }

    public String getCreateUserName() {
        return createUserName;
    }

    public void setCreateUserName(String createUserName) {
        this.createUserName = createUserName;
    }

    public String getUpdateUserName() {
        return updateUserName;
    }

    public void setUpdateUserName(String updateUserName) {
        this.updateUserName = updateUserName;
    }

    @ReferSerialTransfer(referCode = "development_work_type")
    public Long getWorkTypeId() {
        return workTypeId;
    }

    @ReferDeserialTransfer
    public void setWorkTypeId(Long workTypeId) {
        this.workTypeId = workTypeId;
    }

    public String getWorkTypeCode() {
        return workTypeCode;
    }

    public void setWorkTypeCode(String workTypeCode) {
        this.workTypeCode = workTypeCode;
    }

    public String getWorkTypeName() {
        return workTypeName;
    }

    public void setWorkTypeName(String workTypeName) {
        this.workTypeName = workTypeName;
    }


    @ReferSerialTransfer(referCode = "development_work_type")
    public Long getWorkTypeDetailId() {
        return workTypeDetailId;
    }

    @ReferDeserialTransfer
    public void setWorkTypeDetailId(Long workTypeDetailId) {
        this.workTypeDetailId = workTypeDetailId;
    }

    public String getWorkTypeDetailCode() {
        return workTypeDetailCode;
    }

    public void setWorkTypeDetailCode(String workTypeDetailCode) {
        this.workTypeDetailCode = workTypeDetailCode;
    }

    public String getWorkTypeDetailName() {
        return workTypeDetailName;
    }

    public void setWorkTypeDetailName(String workTypeDetailName) {
        this.workTypeDetailName = workTypeDetailName;
    }

    public String getProjectCode() {
        return projectCode;
    }

    public void setProjectCode(String projectCode) {
        this.projectCode = projectCode;
    }

    public String getProjectName() {
        return projectName;
    }

    public void setProjectName(String projectName) {
        this.projectName = projectName;
    }

    public Date getRegistTime() {
        return registTime;
    }

    public void setRegistTime(Date registTime) {
        this.registTime = registTime;
    }

    @ReferSerialTransfer(referCode = "idm-dept")
    public Long getChargeOrgId() {
        return chargeOrgId;
    }

    @ReferDeserialTransfer
    public void setChargeOrgId(Long chargeOrgId) {
        this.chargeOrgId = chargeOrgId;
    }

    public String getChargeOrgName() {
        return chargeOrgName;
    }

    public void setChargeOrgName(String chargeOrgName) {
        this.chargeOrgName = chargeOrgName;
    }


    @ReferSerialTransfer(referCode = "idm-org")
    public Long getCoordinateOrgId() {
        return coordinateOrgId;
    }

    @ReferDeserialTransfer
    public void setCoordinateOrgId(Long coordinateOrgId) {
        this.coordinateOrgId = coordinateOrgId;
    }

    public String getCoordinateOrgName() {
        return coordinateOrgName;
    }

    public void setCoordinateOrgName(String coordinateOrgName) {
        this.coordinateOrgName = coordinateOrgName;
    }

    public String getRegistRemark() {
        return registRemark;
    }

    public void setRegistRemark(String registRemark) {
        this.registRemark = registRemark;
    }

    public String getAnticipatedResults() {
        return anticipatedResults;
    }

    public void setAnticipatedResults(String anticipatedResults) {
        this.anticipatedResults = anticipatedResults;
    }

    public Date getEndTime() {
        return endTime;
    }

    public void setEndTime(Date endTime) {
        this.endTime = endTime;
    }

    public String getOperatorId() {
        return operatorId;
    }

    public void setOperatorId(String operatorId) {
        this.operatorId = operatorId;
    }

    public String getOperatorName() {
        return operatorName;
    }

    public void setOperatorName(String operatorName) {
        this.operatorName = operatorName;
    }

    public Long getProgressId() {
        return progressId;
    }

    public void setProgressId(Long progressId) {
        this.progressId = progressId;
    }

    public String getProgressName() {
        return progressName;
    }

    public void setProgressName(String progressName) {
        this.progressName = progressName;
    }

    public String getProgressRemark() {
        return progressRemark;
    }

    public void setProgressRemark(String progressRemark) {
        this.progressRemark = progressRemark;
    }

    public Date getProgressTime() {
        return progressTime;
    }

    public void setProgressTime(Date progressTime) {
        this.progressTime = progressTime;
    }

    public List<WorkPlanLogVO> getPlanLogVOS() {
        return planLogVOS;
    }

    public void setPlanLogVOS(List<WorkPlanLogVO> planLogVOS) {
        this.planLogVOS = planLogVOS;
    }

    public List<WorkPlanVO> getChildrenVOS() {
        return childrenVOS;
    }

    public void setChildrenVOS(List<WorkPlanVO> childrenVOS) {
        this.childrenVOS = childrenVOS;
    }
}
