package com.ejianc.business.outputvalcount.utils;


import java.util.HashMap;
import java.util.Map;

/**
 * @author sunxy
 * @description: 工程状态
 * @return:
 * @date: 2022/07/06
 */
public enum MonthlyPlanEnum {

    ZAI_SHI(1L, "在施"),
    TING_GONG(2L, "停工"),
    WAN_GONG(3L, "完工"),
    JUN_GONG(4L, "竣工");


    private Long code;
    private String name;

    private static Map<Long, String> enumMap;

    static {
        enumMap = new HashMap<>();
        enumMap.put(ZAI_SHI.getCode(), ZAI_SHI.getName());
        enumMap.put(TING_GONG.getCode(), TING_GONG.getName());
        enumMap.put(WAN_GONG.getCode(), WAN_GONG.getName());
        enumMap.put(JUN_GONG.getCode(), JUN_GONG.getName());
    }

    public static String getNameByCode(Long code) {
        return enumMap.get(code);
    }


    MonthlyPlanEnum(Long code, String name) {
        this.code = code;
        this.name = name;
    }

    public Long getCode() {
        return code;
    }

    public String getName() {
        return name;
    }


}
