package com.ejianc.business.projectmanage.vo;

import java.util.Date;
import java.math.*;
import java.util.List;
import java.util.ArrayList;
import java.io.Serializable;

import com.ejianc.framework.skeleton.refer.annotation.ReferDeserialTransfer;
import com.ejianc.framework.skeleton.refer.annotation.ReferSerialTransfer;
import com.ejianc.framework.skeleton.template.BaseVO;

import com.ejianc.business.projectmanage.vo.ReturnVisitRecordDetailVO;
import com.fasterxml.jackson.annotation.JsonFormat;

/**
 * 工程管理-回访记录表
 *
 * @author generator
 */
public class ReturnVisitRecordVO extends BaseVO {
    private static final long serialVersionUID = 1L;

    private String billCode; // 单据编码
    private Long orgId; // 组织id
    private String orgName; // 组织名称
    private Integer billState; // 单据状态
    private String createUserName; // 编制人
    private String updateUserName; // 修改者
    private String remark; // 备注
    private Long parentOrgId; // 单位id
    private String parentOrgName; // 单位名称
    private Long projectId; // 工程id
    private String projectName; // 工程名称
    @JsonFormat(pattern = "yyyy-MM-dd", timezone = "GMT+8")
    private Date visitDate; // 回访日期
    private Long dutyPerson; // 回访负责人
    private String dutyPersonName; // 回访负责人名称
    private String dutyPersonPhone; // 回访负责人联系方式
    private Long buildUnitId; // 施工单位
    private String buildUnitName; // 施工单位名称
    private Long commitUser; // 提交人
    private String commitUserName; // 提交人名称
    @JsonFormat(pattern = "yyyy-MM-dd", timezone = "GMT+8")
    private Date commitDate; // 提交日期
    private Long engineeringType; // 工程类别
    private String engineeringTypeName; // 工程类别名称
    private Long visitType; // 回访类型
    private String visitTypeName; // 回访类型名称
    @JsonFormat(pattern = "yyyy-MM-dd", timezone = "GMT+8")
    private Date finishDate; // 竣工日期
    private Long measureType; // 工程度量方式
    private String measureTypeName; // 工程度量方式名称
    private String measureValue; // 度量值
    private Long visitPlanId; // 回访计划id
    private String handleFlag; // 处理标识
    @JsonFormat(pattern = "yyyy-MM-dd", timezone = "GMT+8")
    private Date lastHandleDate; // 最新处理日期
    @JsonFormat(pattern = "yyyy-MM-dd", timezone = "GMT+8")
    private Date planHandleDate; // 计划处理完成日期
    private Integer followNum;//跟踪次数

    private List<ReturnVisitRecordDetailVO> returnVisitRecordDetailList = new ArrayList<>(); // 工程管理-回访记录问题详情
    private List<ReturnVisitHandleDetailVO> handleList = new ArrayList<>();

    public String getBillCode() {
        return billCode;
    }

    public void setBillCode(String billCode) {
        this.billCode = billCode;
    }

    public Long getOrgId() {
        return orgId;
    }

    public void setOrgId(Long orgId) {
        this.orgId = orgId;
    }

    public String getOrgName() {
        return orgName;
    }

    public void setOrgName(String orgName) {
        this.orgName = orgName;
    }

    public Integer getBillState() {
        return billState;
    }

    public void setBillState(Integer billState) {
        this.billState = billState;
    }

    public String getCreateUserName() {
        return createUserName;
    }

    public void setCreateUserName(String createUserName) {
        this.createUserName = createUserName;
    }

    public String getUpdateUserName() {
        return updateUserName;
    }

    public void setUpdateUserName(String updateUserName) {
        this.updateUserName = updateUserName;
    }

    public String getRemark() {
        return remark;
    }

    public void setRemark(String remark) {
        this.remark = remark;
    }

    @ReferSerialTransfer(referCode = "idm-org")
    public Long getParentOrgId() {
        return parentOrgId;
    }

    @ReferDeserialTransfer
    public void setParentOrgId(Long parentOrgId) {
        this.parentOrgId = parentOrgId;
    }

    public String getParentOrgName() {
        return parentOrgName;
    }

    public void setParentOrgName(String parentOrgName) {
        this.parentOrgName = parentOrgName;
    }

    @ReferSerialTransfer(referCode = "project-set")
    public Long getProjectId() {
        return projectId;
    }

    @ReferDeserialTransfer
    public void setProjectId(Long projectId) {
        this.projectId = projectId;
    }

    public String getProjectName() {
        return projectName;
    }

    public void setProjectName(String projectName) {
        this.projectName = projectName;
    }

    public Date getVisitDate() {
        return visitDate;
    }

    public void setVisitDate(Date visitDate) {
        this.visitDate = visitDate;
    }

    @ReferSerialTransfer(referCode = "idm-user")
    public Long getDutyPerson() {
        return dutyPerson;
    }

    @ReferDeserialTransfer
    public void setDutyPerson(Long dutyPerson) {
        this.dutyPerson = dutyPerson;
    }

    public String getDutyPersonName() {
        return dutyPersonName;
    }

    public void setDutyPersonName(String dutyPersonName) {
        this.dutyPersonName = dutyPersonName;
    }

    public String getDutyPersonPhone() {
        return dutyPersonPhone;
    }

    public void setDutyPersonPhone(String dutyPersonPhone) {
        this.dutyPersonPhone = dutyPersonPhone;
    }

    public Long getBuildUnitId() {
        return buildUnitId;
    }

    public void setBuildUnitId(Long buildUnitId) {
        this.buildUnitId = buildUnitId;
    }

    public String getBuildUnitName() {
        return buildUnitName;
    }

    public void setBuildUnitName(String buildUnitName) {
        this.buildUnitName = buildUnitName;
    }

    public Long getCommitUser() {
        return commitUser;
    }

    public void setCommitUser(Long commitUser) {
        this.commitUser = commitUser;
    }

    public String getCommitUserName() {
        return commitUserName;
    }

    public void setCommitUserName(String commitUserName) {
        this.commitUserName = commitUserName;
    }

    public Date getCommitDate() {
        return commitDate;
    }

    public void setCommitDate(Date commitDate) {
        this.commitDate = commitDate;
    }

    public Long getEngineeringType() {
        return engineeringType;
    }

    public void setEngineeringType(Long engineeringType) {
        this.engineeringType = engineeringType;
    }

    public String getEngineeringTypeName() {
        return engineeringTypeName;
    }

    public void setEngineeringTypeName(String engineeringTypeName) {
        this.engineeringTypeName = engineeringTypeName;
    }

    public Long getVisitType() {
        return visitType;
    }

    public void setVisitType(Long visitType) {
        this.visitType = visitType;
    }

    public String getVisitTypeName() {
        return visitTypeName;
    }

    public void setVisitTypeName(String visitTypeName) {
        this.visitTypeName = visitTypeName;
    }

    public Date getFinishDate() {
        return finishDate;
    }

    public void setFinishDate(Date finishDate) {
        this.finishDate = finishDate;
    }

    public Long getMeasureType() {
        return measureType;
    }

    public void setMeasureType(Long measureType) {
        this.measureType = measureType;
    }

    public String getMeasureTypeName() {
        return measureTypeName;
    }

    public void setMeasureTypeName(String measureTypeName) {
        this.measureTypeName = measureTypeName;
    }

    public String getMeasureValue() {
        return measureValue;
    }

    public void setMeasureValue(String measureValue) {
        this.measureValue = measureValue;
    }

    public Long getVisitPlanId() {
        return visitPlanId;
    }

    public void setVisitPlanId(Long visitPlanId) {
        this.visitPlanId = visitPlanId;
    }

    public String getHandleFlag() {
        return handleFlag;
    }

    public void setHandleFlag(String handleFlag) {
        this.handleFlag = handleFlag;
    }

    public Date getLastHandleDate() {
        return lastHandleDate;
    }

    public void setLastHandleDate(Date lastHandleDate) {
        this.lastHandleDate = lastHandleDate;
    }

    public Date getPlanHandleDate() {
        return planHandleDate;
    }

    public void setPlanHandleDate(Date planHandleDate) {
        this.planHandleDate = planHandleDate;
    }

    public Integer getFollowNum() {
        return followNum;
    }

    public void setFollowNum(Integer followNum) {
        this.followNum = followNum;
    }

    public List<ReturnVisitRecordDetailVO> getReturnVisitRecordDetailList() {
        return returnVisitRecordDetailList;
    }

    public void setReturnVisitRecordDetailList(List<ReturnVisitRecordDetailVO> returnVisitRecordDetailList) {
        this.returnVisitRecordDetailList = returnVisitRecordDetailList;
    }

    public List<ReturnVisitHandleDetailVO> getHandleList() {
        return handleList;
    }

    public void setHandleList(List<ReturnVisitHandleDetailVO> handleList) {
        this.handleList = handleList;
    }
}
