package com.ejianc.business.projectmanage.vo;

import java.util.Date;
import java.math.*;
import java.util.List;
import java.util.ArrayList;
import java.io.Serializable;

import com.ejianc.framework.skeleton.refer.annotation.ReferDeserialTransfer;
import com.ejianc.framework.skeleton.refer.annotation.ReferSerialTransfer;
import com.ejianc.framework.skeleton.template.BaseVO;
import com.fasterxml.jackson.annotation.JsonFormat;


/**
 * 工程管理-年度回访计划
 *
 * @author generator
 */
public class ReturnVisitPlanVO extends BaseVO {
    private static final long serialVersionUID = 1L;

    private String billCode; // 单据编码
    private Long orgId; // 组织id
    private String orgName; // 组织名称
    private Integer billState; // 单据状态
    private String createUserName; // 编制人
    private String updateUserName; // 修改者
    private String remark; // 备注
    private Long parentOrgId; // 单位id
    private String parentOrgName; // 单位名称
    private Long projectId; // 工程id
    private String projectName; // 工程名称
    @JsonFormat(pattern = "yyyy-MM-dd", timezone = "GMT+8")
    private Date planVisitDate; // 计划回访日期
    @JsonFormat(pattern = "yyyy-MM-dd", timezone = "GMT+8")
    private Date finishDate; // 竣工日期
    @JsonFormat(pattern = "yyyy-MM-dd", timezone = "GMT+8")
    private Date finishYearDate; // 竣工一年日期
    @JsonFormat(pattern = "yyyy-MM-dd", timezone = "GMT+8")
    private Date periodEndDate; // 保修期截止日期
    private Long dutyPerson; // 回访负责人
    private String dutyPersonName; // 回访负责人名称
    private String dutyPersonPhone; // 回访负责人联系方式
    private Long constructId; // 建设单位
    private String constructName; // 建设单位名称
    private String constructPersonName; // 建设单位联系人
    private String constructPersonPhone; // 建设单位联系方式
    private String userCompanyName; // 使用单位名称
    private String userCompanyPersonName; // 使用单位联系人
    private String userCompanyPersonPhone; // 使用单位联系方式
    private Long commitUser; // 提交人
    private String commitUserName; // 提交人名称
    @JsonFormat(pattern = "yyyy-MM-dd", timezone = "GMT+8")
    private Date commitDate; // 提交日期


    public String getBillCode() {
        return billCode;
    }

    public void setBillCode(String billCode) {
        this.billCode = billCode;
    }

    public Long getOrgId() {
        return orgId;
    }

    public void setOrgId(Long orgId) {
        this.orgId = orgId;
    }

    public String getOrgName() {
        return orgName;
    }

    public void setOrgName(String orgName) {
        this.orgName = orgName;
    }

    public Integer getBillState() {
        return billState;
    }

    public void setBillState(Integer billState) {
        this.billState = billState;
    }

    public String getCreateUserName() {
        return createUserName;
    }

    public void setCreateUserName(String createUserName) {
        this.createUserName = createUserName;
    }

    public String getUpdateUserName() {
        return updateUserName;
    }

    public void setUpdateUserName(String updateUserName) {
        this.updateUserName = updateUserName;
    }

    public String getRemark() {
        return remark;
    }

    public void setRemark(String remark) {
        this.remark = remark;
    }
    @ReferSerialTransfer(referCode="idm-org")
    public Long getParentOrgId() {
        return parentOrgId;
    }
    @ReferDeserialTransfer
    public void setParentOrgId(Long parentOrgId) {
        this.parentOrgId = parentOrgId;
    }

    public String getParentOrgName() {
        return parentOrgName;
    }

    public void setParentOrgName(String parentOrgName) {
        this.parentOrgName = parentOrgName;
    }

    @ReferSerialTransfer(referCode = "project-set")
    public Long getProjectId() {
        return projectId;
    }

    @ReferDeserialTransfer
    public void setProjectId(Long projectId) {
        this.projectId = projectId;
    }

    public String getProjectName() {
        return projectName;
    }

    public void setProjectName(String projectName) {
        this.projectName = projectName;
    }

    public Date getPlanVisitDate() {
        return planVisitDate;
    }

    public void setPlanVisitDate(Date planVisitDate) {
        this.planVisitDate = planVisitDate;
    }

    public Date getFinishDate() {
        return finishDate;
    }

    public void setFinishDate(Date finishDate) {
        this.finishDate = finishDate;
    }

    public Date getFinishYearDate() {
        return finishYearDate;
    }

    public void setFinishYearDate(Date finishYearDate) {
        this.finishYearDate = finishYearDate;
    }

    public Date getPeriodEndDate() {
        return periodEndDate;
    }

    public void setPeriodEndDate(Date periodEndDate) {
        this.periodEndDate = periodEndDate;
    }

    @ReferSerialTransfer(referCode = "idm-user")
    public Long getDutyPerson() {
        return dutyPerson;
    }

    @ReferDeserialTransfer
    public void setDutyPerson(Long dutyPerson) {
        this.dutyPerson = dutyPerson;
    }

    public String getDutyPersonName() {
        return dutyPersonName;
    }

    public void setDutyPersonName(String dutyPersonName) {
        this.dutyPersonName = dutyPersonName;
    }

    public String getDutyPersonPhone() {
        return dutyPersonPhone;
    }

    public void setDutyPersonPhone(String dutyPersonPhone) {
        this.dutyPersonPhone = dutyPersonPhone;
    }

    @ReferSerialTransfer(referCode = "support-customer,support-supplier")
    public Long getConstructId() {
        return constructId;
    }
    @ReferDeserialTransfer
    public void setConstructId(Long constructId) {
        this.constructId = constructId;
    }

    public String getConstructName() {
        return constructName;
    }

    public void setConstructName(String constructName) {
        this.constructName = constructName;
    }

    public String getConstructPersonName() {
        return constructPersonName;
    }

    public void setConstructPersonName(String constructPersonName) {
        this.constructPersonName = constructPersonName;
    }

    public String getConstructPersonPhone() {
        return constructPersonPhone;
    }

    public void setConstructPersonPhone(String constructPersonPhone) {
        this.constructPersonPhone = constructPersonPhone;
    }

    public String getUserCompanyName() {
        return userCompanyName;
    }

    public void setUserCompanyName(String userCompanyName) {
        this.userCompanyName = userCompanyName;
    }

    public String getUserCompanyPersonName() {
        return userCompanyPersonName;
    }

    public void setUserCompanyPersonName(String userCompanyPersonName) {
        this.userCompanyPersonName = userCompanyPersonName;
    }

    public String getUserCompanyPersonPhone() {
        return userCompanyPersonPhone;
    }

    public void setUserCompanyPersonPhone(String userCompanyPersonPhone) {
        this.userCompanyPersonPhone = userCompanyPersonPhone;
    }

    public Long getCommitUser() {
        return commitUser;
    }

    public void setCommitUser(Long commitUser) {
        this.commitUser = commitUser;
    }

    public String getCommitUserName() {
        return commitUserName;
    }

    public void setCommitUserName(String commitUserName) {
        this.commitUserName = commitUserName;
    }

    public Date getCommitDate() {
        return commitDate;
    }

    public void setCommitDate(Date commitDate) {
        this.commitDate = commitDate;
    }

}
