package com.ejianc.business.appliances.vo;

import java.util.Date;
import java.math.*;
import java.util.List;
import java.util.ArrayList;
import java.io.Serializable;

import com.ejianc.framework.skeleton.refer.annotation.ReferDeserialTransfer;
import com.ejianc.framework.skeleton.refer.annotation.ReferSerialTransfer;
import com.ejianc.framework.skeleton.template.BaseVO;

import com.ejianc.business.appliances.vo.MeteringRegisterDetailVO;
import com.fasterxml.jackson.annotation.JsonFormat;

/**
 * 器具-计量器具登记
 * 
 * @author generator
 * 
 */
public class MeteringRegisterVO extends BaseVO {
    private static final long serialVersionUID = 1L;
    
    private String billCode; // 单据编码
    private Long orgId; // 组织id
    private String orgName; // 组织名称
    private Integer billState; // 单据状态
    private String createUserName; // 编制人
    private Long operatorId; // 经办人ID
    private String operatorName; // 经办人姓名
    private String updateUserName; // 修改者
    private String remark; // 备注
    private Long patrolGroupId; // 所属巡检组id
    private String patrolGroup; // 所属巡检组：1、巡检一组 2、巡检二组 3、巡检三组
    private Long projectId; // 工程名称id
    private String projectName; // 工程名称
    private Long technologyId; // 项目技术负责人
    private String technologyName; // 项目技术负责人名称
    private Long engineeringTypeId; // 工程类别
    private String engineeringType; // 工程类型名称
    private Long testersId; // 试验员
    private String testersName; // 试验员名称
    @JsonFormat(shape = JsonFormat.Shape.STRING, pattern = "yyyy-MM-dd", timezone = "GMT+8")
    private Date startDate; // 进场日期
    private Long structureType; // 结构类型
    private String structureTypeName; // 结构类型名称
    @JsonFormat(shape = JsonFormat.Shape.STRING, pattern = "yyyy-MM-dd", timezone = "GMT+8")
    private Date workDate;//开工日期
    
    private List<MeteringRegisterDetailVO> meteringRegisterDetailList = new ArrayList<>(); // 器具-计量器具登记详情

    public String getBillCode() {
        return billCode;
    }

    public void setBillCode(String billCode) {
        this.billCode = billCode;
    }
    public Long getOrgId() {
        return orgId;
    }

    public void setOrgId(Long orgId) {
        this.orgId = orgId;
    }
    public String getOrgName() {
        return orgName;
    }

    public void setOrgName(String orgName) {
        this.orgName = orgName;
    }
    public Integer getBillState() {
        return billState;
    }

    public void setBillState(Integer billState) {
        this.billState = billState;
    }
    public String getCreateUserName() {
        return createUserName;
    }

    public void setCreateUserName(String createUserName) {
        this.createUserName = createUserName;
    }
    public Long getOperatorId() {
        return operatorId;
    }

    public void setOperatorId(Long operatorId) {
        this.operatorId = operatorId;
    }
    public String getOperatorName() {
        return operatorName;
    }

    public void setOperatorName(String operatorName) {
        this.operatorName = operatorName;
    }
    public String getUpdateUserName() {
        return updateUserName;
    }

    public void setUpdateUserName(String updateUserName) {
        this.updateUserName = updateUserName;
    }
    public String getRemark() {
        return remark;
    }

    public void setRemark(String remark) {
        this.remark = remark;
    }
    @ReferSerialTransfer(referCode="support-defdoc")
    public Long getPatrolGroupId() {
        return patrolGroupId;
    }
    @ReferDeserialTransfer
    public void setPatrolGroupId(Long patrolGroupId) {
        this.patrolGroupId = patrolGroupId;
    }
    public String getPatrolGroup() {
        return patrolGroup;
    }

    public void setPatrolGroup(String patrolGroup) {
        this.patrolGroup = patrolGroup;
    }
    @ReferSerialTransfer(referCode="project-set")
    public Long getProjectId() {
        return projectId;
    }
    @ReferDeserialTransfer
    public void setProjectId(Long projectId) {
        this.projectId = projectId;
    }
    public String getProjectName() {
        return projectName;
    }

    public void setProjectName(String projectName) {
        this.projectName = projectName;
    }
    @ReferSerialTransfer(referCode="idm-user")
    public Long getTechnologyId() {
        return technologyId;
    }
    @ReferDeserialTransfer
    public void setTechnologyId(Long technologyId) {
        this.technologyId = technologyId;
    }
    public String getTechnologyName() {
        return technologyName;
    }

    public void setTechnologyName(String technologyName) {
        this.technologyName = technologyName;
    }
    @ReferSerialTransfer(referCode="support-defdoc")
    public Long getEngineeringTypeId() {
        return engineeringTypeId;
    }
    @ReferDeserialTransfer
    public void setEngineeringTypeId(Long engineeringTypeId) {
        this.engineeringTypeId = engineeringTypeId;
    }
    public String getEngineeringType() {
        return engineeringType;
    }

    public void setEngineeringType(String engineeringType) {
        this.engineeringType = engineeringType;
    }
    @ReferSerialTransfer(referCode="idm-user")
    public Long getTestersId() {
        return testersId;
    }
    @ReferDeserialTransfer
    public void setTestersId(Long testersId) {
        this.testersId = testersId;
    }
    public String getTestersName() {
        return testersName;
    }

    public void setTestersName(String testersName) {
        this.testersName = testersName;
    }

    public Date getStartDate() {
        return startDate;
    }

    public void setStartDate(Date startDate) {
        this.startDate = startDate;
    }

    @ReferSerialTransfer(referCode="support-defdoc")
    public Long getStructureType() {
        return structureType;
    }
    @ReferDeserialTransfer
    public void setStructureType(Long structureType) {
        this.structureType = structureType;
    }
    public String getStructureTypeName() {
        return structureTypeName;
    }

    public void setStructureTypeName(String structureTypeName) {
        this.structureTypeName = structureTypeName;
    }
    
     public List<MeteringRegisterDetailVO> getMeteringRegisterDetailList() {
        return meteringRegisterDetailList;
     }

     public void setMeteringRegisterDetailList(List<MeteringRegisterDetailVO> meteringRegisterDetailList) {
        this.meteringRegisterDetailList = meteringRegisterDetailList;
     }

    public Date getWorkDate() {
        return workDate;
    }

    public void setWorkDate(Date workDate) {
        this.workDate = workDate;
    }
}
