package com.ejianc.business.worklog.vo;

import java.util.Date;
import java.math.*;
import java.util.List;
import java.util.ArrayList;
import java.io.Serializable;

import com.ejianc.framework.skeleton.refer.annotation.ReferDeserialTransfer;
import com.ejianc.framework.skeleton.refer.annotation.ReferSerialTransfer;
import com.ejianc.framework.skeleton.template.BaseVO;
import com.fasterxml.jackson.annotation.JsonFormat;


/**
 * 指标线上化-指标报送
 *
 * @author generator
 */
public class OrgIndexSubmitVO extends BaseVO {
    private static final long serialVersionUID = 1L;

    private String billCode; // 单据编码
    private Long orgId; // 组织id
    private String orgName; // 组织名称
    private Integer billState; // 单据状态
    private String createUserName; // 编制人
    private Long operatorId; // 经办人ID
    private String operatorName; // 经办人姓名
    private String updateUserName; // 修改者----
    private String remark; // 备注
    private String manageType; // 管理模块
    private Long departmentId; // 责任部门
    private String departmentName; // 
    private String indexSource; // 指标来源
    private String indexRemark; // 指标内容
    private String indexName; // 指标名称
    private String indexType; // 指标分类(1-定量类 2-定性类 3-完成率类)
    private String indexRule; // 指标取数规则
    private String indexFrom; // 指标制定依据
    private String indexFormula; // 指标测算公式
    private Integer indexYear; // 年份
    private String dutyPerson; // 主控人员
    private String dutyPersonName; // 主控人员名称
    private BigDecimal indexPer; // 重要性占比
    private String workSplit; // 工作阶段拆分
    private String targetRemark; // 里程碑目标
    @JsonFormat(shape = JsonFormat.Shape.STRING, pattern = "yyyy-MM-dd", timezone = "GMT+8")
    private Date startDate; // 开始时间
    @JsonFormat(shape = JsonFormat.Shape.STRING, pattern = "yyyy-MM-dd", timezone = "GMT+8")
    private Date endDate; // 结束时间
    private Long pid; // 父id
    private String innerCode; // 内码
    private String innerName; // 内码名称
    private String parentName; // 父名称
    private Integer sort; // 排序
    private List<OrgIndexSubmitVO> children;//树形结构
    private String indexLevel;//指标级别(一级指标、二级指标)

    public String getBillCode() {
        return billCode;
    }

    public void setBillCode(String billCode) {
        this.billCode = billCode;
    }

    public Long getOrgId() {
        return orgId;
    }

    public void setOrgId(Long orgId) {
        this.orgId = orgId;
    }

    public String getOrgName() {
        return orgName;
    }

    public void setOrgName(String orgName) {
        this.orgName = orgName;
    }

    public Integer getBillState() {
        return billState;
    }

    public void setBillState(Integer billState) {
        this.billState = billState;
    }

    public String getCreateUserName() {
        return createUserName;
    }

    public void setCreateUserName(String createUserName) {
        this.createUserName = createUserName;
    }

    public Long getOperatorId() {
        return operatorId;
    }

    public void setOperatorId(Long operatorId) {
        this.operatorId = operatorId;
    }

    public String getOperatorName() {
        return operatorName;
    }

    public void setOperatorName(String operatorName) {
        this.operatorName = operatorName;
    }

    public String getUpdateUserName() {
        return updateUserName;
    }

    public void setUpdateUserName(String updateUserName) {
        this.updateUserName = updateUserName;
    }

    public String getRemark() {
        return remark;
    }

    public void setRemark(String remark) {
        this.remark = remark;
    }

    public String getManageType() {
        return manageType;
    }

    public void setManageType(String manageType) {
        this.manageType = manageType;
    }

    @ReferSerialTransfer(referCode = "idm-dept")
    public Long getDepartmentId() {
        return departmentId;
    }

    @ReferDeserialTransfer
    public void setDepartmentId(Long departmentId) {
        this.departmentId = departmentId;
    }

    public String getDepartmentName() {
        return departmentName;
    }

    public void setDepartmentName(String departmentName) {
        this.departmentName = departmentName;
    }

    public String getIndexSource() {
        return indexSource;
    }

    public void setIndexSource(String indexSource) {
        this.indexSource = indexSource;
    }

    public String getIndexRemark() {
        return indexRemark;
    }

    public void setIndexRemark(String indexRemark) {
        this.indexRemark = indexRemark;
    }

    public String getIndexName() {
        return indexName;
    }

    public void setIndexName(String indexName) {
        this.indexName = indexName;
    }

    public String getIndexType() {
        return indexType;
    }

    public void setIndexType(String indexType) {
        this.indexType = indexType;
    }

    public String getIndexRule() {
        return indexRule;
    }

    public void setIndexRule(String indexRule) {
        this.indexRule = indexRule;
    }

    public String getIndexFrom() {
        return indexFrom;
    }

    public void setIndexFrom(String indexFrom) {
        this.indexFrom = indexFrom;
    }

    public String getIndexFormula() {
        return indexFormula;
    }

    public void setIndexFormula(String indexFormula) {
        this.indexFormula = indexFormula;
    }

    public Integer getIndexYear() {
        return indexYear;
    }

    public void setIndexYear(Integer indexYear) {
        this.indexYear = indexYear;
    }

    public String getDutyPerson() {
        return dutyPerson;
    }

    public void setDutyPerson(String dutyPerson) {
        this.dutyPerson = dutyPerson;
    }

    public String getDutyPersonName() {
        return dutyPersonName;
    }

    public void setDutyPersonName(String dutyPersonName) {
        this.dutyPersonName = dutyPersonName;
    }

    public BigDecimal getIndexPer() {
        return indexPer;
    }

    public void setIndexPer(BigDecimal indexPer) {
        this.indexPer = indexPer;
    }

    public String getWorkSplit() {
        return workSplit;
    }

    public void setWorkSplit(String workSplit) {
        this.workSplit = workSplit;
    }

    public String getTargetRemark() {
        return targetRemark;
    }

    public void setTargetRemark(String targetRemark) {
        this.targetRemark = targetRemark;
    }

    public Date getStartDate() {
        return startDate;
    }

    public void setStartDate(Date startDate) {
        this.startDate = startDate;
    }

    public Date getEndDate() {
        return endDate;
    }

    public void setEndDate(Date endDate) {
        this.endDate = endDate;
    }

    public Long getPid() {
        return pid;
    }

    public void setPid(Long pid) {
        this.pid = pid;
    }

    public String getInnerCode() {
        return innerCode;
    }

    public void setInnerCode(String innerCode) {
        this.innerCode = innerCode;
    }

    public String getInnerName() {
        return innerName;
    }

    public void setInnerName(String innerName) {
        this.innerName = innerName;
    }

    public String getParentName() {
        return parentName;
    }

    public void setParentName(String parentName) {
        this.parentName = parentName;
    }

    public Integer getSort() {
        return sort;
    }

    public void setSort(Integer sort) {
        this.sort = sort;
    }

    public List<OrgIndexSubmitVO> getChildren() {
        return children;
    }

    public void setChildren(List<OrgIndexSubmitVO> children) {
        this.children = children;
    }

    public String getIndexLevel() {
        return indexLevel;
    }

    public void setIndexLevel(String indexLevel) {
        this.indexLevel = indexLevel;
    }
}
