package com.ejianc.business.appliances.vo;

import java.util.Date;
import java.math.*;
import java.util.List;
import java.util.ArrayList;
import java.io.Serializable;

import com.ejianc.framework.skeleton.refer.annotation.ReferDeserialTransfer;
import com.ejianc.framework.skeleton.refer.annotation.ReferSerialTransfer;
import com.ejianc.framework.skeleton.template.BaseVO;

import com.ejianc.business.appliances.vo.MeteringPlanDetailVO;
import com.fasterxml.jackson.annotation.JsonFormat;

/**
 * 器具-计量器具计划
 * 
 * @author generator
 * 
 */
public class MeteringPlanVO extends BaseVO {
    private static final long serialVersionUID = 1L;
    
    private String billCode; // 单据编码
    private Long orgId; // 组织id
    private String orgName; // 组织名称
    private Integer billState; // 单据状态（审批必须字段）
    private String createUserName; // 编制人
    private Long operatorId; // 经办人ID
    private String operatorName; // 经办人姓名
    private String updateUserName; // 修改者
    private String remark; // 备注
    private Long projectId; // 项目id
    private String projectName; // 项目名称
    @JsonFormat(shape = JsonFormat.Shape.STRING, pattern = "yyyy-MM-dd", timezone = "GMT+8")
    private Date serviceDate; // 编制日期
    private Long departmentId; // 所属单位
    private String departmentName; // 所属单位名称
    private String planName; // 计划名称
    private Long patrolGroup; // 所属巡检组
    private String patrolGroupName; // 所属巡检组名称
    
    private List<MeteringPlanDetailVO> meteringPlanDetailList = new ArrayList<>(); // 器具-计量器具计划详情

    public String getBillCode() {
        return billCode;
    }

    public void setBillCode(String billCode) {
        this.billCode = billCode;
    }
    public Long getOrgId() {
        return orgId;
    }

    public void setOrgId(Long orgId) {
        this.orgId = orgId;
    }
    public String getOrgName() {
        return orgName;
    }

    public void setOrgName(String orgName) {
        this.orgName = orgName;
    }
    public Integer getBillState() {
        return billState;
    }

    public void setBillState(Integer billState) {
        this.billState = billState;
    }
    public String getCreateUserName() {
        return createUserName;
    }

    public void setCreateUserName(String createUserName) {
        this.createUserName = createUserName;
    }
    public Long getOperatorId() {
        return operatorId;
    }

    public void setOperatorId(Long operatorId) {
        this.operatorId = operatorId;
    }
    public String getOperatorName() {
        return operatorName;
    }

    public void setOperatorName(String operatorName) {
        this.operatorName = operatorName;
    }
    public String getUpdateUserName() {
        return updateUserName;
    }

    public void setUpdateUserName(String updateUserName) {
        this.updateUserName = updateUserName;
    }
    public String getRemark() {
        return remark;
    }

    public void setRemark(String remark) {
        this.remark = remark;
    }
    @ReferSerialTransfer(referCode="project-set")
    public Long getProjectId() {
        return projectId;
    }
    @ReferDeserialTransfer
    public void setProjectId(Long projectId) {
        this.projectId = projectId;
    }
    public String getProjectName() {
        return projectName;
    }

    public void setProjectName(String projectName) {
        this.projectName = projectName;
    }
    public Date getServiceDate() {
        return serviceDate;
    }

    public void setServiceDate(Date serviceDate) {
        this.serviceDate = serviceDate;
    }
    @ReferSerialTransfer(referCode="idm-org")
    public Long getDepartmentId() {
        return departmentId;
    }
    @ReferDeserialTransfer
    public void setDepartmentId(Long departmentId) {
        this.departmentId = departmentId;
    }
    public String getDepartmentName() {
        return departmentName;
    }

    public void setDepartmentName(String departmentName) {
        this.departmentName = departmentName;
    }
    public String getPlanName() {
        return planName;
    }

    public void setPlanName(String planName) {
        this.planName = planName;
    }
    @ReferSerialTransfer(referCode="support-defdoc")
    public Long getPatrolGroup() {
        return patrolGroup;
    }
    @ReferDeserialTransfer
    public void setPatrolGroup(Long patrolGroup) {
        this.patrolGroup = patrolGroup;
    }
    public String getPatrolGroupName() {
        return patrolGroupName;
    }

    public void setPatrolGroupName(String patrolGroupName) {
        this.patrolGroupName = patrolGroupName;
    }
    
     public List<MeteringPlanDetailVO> getMeteringPlanDetailList() {
        return meteringPlanDetailList;
     }

     public void setMeteringPlanDetailList(List<MeteringPlanDetailVO> meteringPlanDetailList) {
        this.meteringPlanDetailList = meteringPlanDetailList;
     }
}
